/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.components.scheduler.impl;

import integratedtoolkit.api.ITExecution;
import integratedtoolkit.comm.Comm;
import integratedtoolkit.components.impl.TaskScheduler;
import integratedtoolkit.components.scheduler.SchedulerPolicies;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.Task;
import integratedtoolkit.types.data.DataAccessId;
import integratedtoolkit.types.data.DataInstanceId;
import integratedtoolkit.types.parameter.DependencyParameter;
import integratedtoolkit.types.parameter.Parameter;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.types.resources.Worker;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.log4j.Logger;

public class DefaultSchedulerPolicies
extends SchedulerPolicies {
    protected static final Logger logger = Logger.getLogger("integratedtoolkit.Components.TaskDispatcher.TaskScheduler");
    protected static final boolean debug = logger.isDebugEnabled();

    @Override
    public PriorityQueue<SchedulerPolicies.ObjectValue<Task>> sortTasksForResource(Worker<?> host, List<Task> tasks, TaskScheduler.ExecutionProfile[][] profiles) {
        PriorityQueue<SchedulerPolicies.ObjectValue<Task>> pq = new PriorityQueue<SchedulerPolicies.ObjectValue<Task>>();
        for (Task t : tasks) {
            Parameter[] params;
            if (!host.canRun(t.getTaskParams().getId())) continue;
            int score = 0;
            for (Parameter p : params = t.getTaskParams().getParameters()) {
                if (!(p instanceof DependencyParameter)) continue;
                DependencyParameter fp = (DependencyParameter)p;
                DataInstanceId dId = null;
                switch (fp.getDirection()) {
                    case IN: {
                        DataAccessId.RAccessId raId = (DataAccessId.RAccessId)fp.getDataAccessId();
                        dId = raId.getReadDataInstance();
                        break;
                    }
                    case INOUT: {
                        DataAccessId.RWAccessId rwaId = (DataAccessId.RWAccessId)fp.getDataAccessId();
                        dId = rwaId.getReadDataInstance();
                        break;
                    }
                }
                if (dId == null) continue;
                HashSet<Resource> hosts = Comm.getData(dId.getRenaming()).getAllHosts();
                for (Resource h : hosts) {
                    if (h == null || h.compareTo(host) != 0) continue;
                    ++score;
                }
            }
            logger.info("Available Resource: " + host.getName() + ". Task: " + t.getId() + ", score: " + score);
            pq.add(new SchedulerPolicies.ObjectValue<Task>(this, t, score));
        }
        return pq;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PriorityQueue<SchedulerPolicies.ObjectValue<Worker<?>>> sortResourcesForTask(Task t, Set<Worker<?>> resources, TaskScheduler.ExecutionProfile[][] profiles) {
        void var9_11;
        PriorityQueue pq = new PriorityQueue();
        Parameter[] params = t.getTaskParams().getParameters();
        HashMap<Resource, Integer> hostToScore = new HashMap<Resource, Integer>(params.length * 2);
        Parameter[] arr$ = params;
        int len$ = arr$.length;
        boolean bl = false;
        while (var9_11 < len$) {
            Parameter p = arr$[var9_11];
            if (p instanceof DependencyParameter && p.getDirection() != ITExecution.ParamDirection.OUT) {
                DependencyParameter dp = (DependencyParameter)p;
                DataInstanceId dId = null;
                switch (dp.getDirection()) {
                    case IN: {
                        DataAccessId.RAccessId raId = (DataAccessId.RAccessId)dp.getDataAccessId();
                        dId = raId.getReadDataInstance();
                        break;
                    }
                    case INOUT: {
                        DataAccessId.RWAccessId rwaId = (DataAccessId.RWAccessId)dp.getDataAccessId();
                        dId = rwaId.getReadDataInstance();
                        break;
                    }
                }
                if (dId != null) {
                    HashSet<Resource> hosts = Comm.getData(dId.getRenaming()).getAllHosts();
                    for (Resource host : hosts) {
                        if (host == null) continue;
                        Integer score = (Integer)hostToScore.get(host);
                        if (score == null) {
                            score = new Integer(0);
                            hostToScore.put(host, score);
                        }
                        hostToScore.put(host, score + 1);
                    }
                }
            }
            ++var9_11;
        }
        LinkedList shuffled_resources = new LinkedList();
        shuffled_resources.addAll(resources);
        Collections.shuffle(shuffled_resources);
        for (Worker worker : shuffled_resources) {
            Integer score = (Integer)hostToScore.get(worker);
            if (score == null) {
                pq.offer(new SchedulerPolicies.ObjectValue<Worker>(this, worker, 0));
                logger.info("Resource: " + worker.getName() + ", score: 0");
                continue;
            }
            pq.offer(new SchedulerPolicies.ObjectValue<Worker>(this, worker, score));
            logger.info("Resource: " + worker.getName() + ", score: " + score);
        }
        return pq;
    }

    @Override
    public SchedulerPolicies.OwnerTask[] stealTasks(Worker<?> destResource, HashMap<String, LinkedList<Task>> pendingTasks, int numberOfTasks, TaskScheduler.ExecutionProfile[][] profiles) {
        SchedulerPolicies.OwnerTask[] stolenTasks = new SchedulerPolicies.OwnerTask[numberOfTasks];
        PriorityQueue<SchedulerPolicies.ObjectValue<SchedulerPolicies.OwnerTask>> pq = new PriorityQueue<SchedulerPolicies.ObjectValue<SchedulerPolicies.OwnerTask>>();
        for (Map.Entry<String, LinkedList<Task>> e : pendingTasks.entrySet()) {
            String ownerName = e.getKey();
            LinkedList<Task> candidates = e.getValue();
            for (Task t : candidates) {
                int score = 0;
                if (t.isSchedulingStrongForced()) continue;
                if (!t.isSchedulingForced()) {
                    score = 10000;
                }
                if (destResource.canRun(t.getTaskParams().getId())) {
                    Parameter[] params;
                    block6: for (Parameter p : params = t.getTaskParams().getParameters()) {
                        if (!(p instanceof DependencyParameter)) continue;
                        DependencyParameter dp = (DependencyParameter)p;
                        DataInstanceId dId = null;
                        switch (dp.getDirection()) {
                            case IN: {
                                DataAccessId.RAccessId raId = (DataAccessId.RAccessId)dp.getDataAccessId();
                                dId = raId.getReadDataInstance();
                                break;
                            }
                            case INOUT: {
                                DataAccessId.RWAccessId rwaId = (DataAccessId.RWAccessId)dp.getDataAccessId();
                                dId = rwaId.getReadDataInstance();
                                break;
                            }
                        }
                        if (dId == null) continue;
                        HashSet<Resource> hosts = Comm.getData(dId.getRenaming()).getAllHosts();
                        for (Resource host : hosts) {
                            if (host == null) continue;
                            if (host.equals(ownerName)) {
                                --score;
                                continue block6;
                            }
                            if (!host.equals(destResource)) continue;
                            score += 2;
                            continue block6;
                        }
                    }
                }
                pq.offer(new SchedulerPolicies.ObjectValue<SchedulerPolicies.OwnerTask>(this, new SchedulerPolicies.OwnerTask(this, ownerName, t), score));
            }
        }
        for (int i = 0; pq.iterator().hasNext() && i < numberOfTasks; ++i) {
            stolenTasks[i] = (SchedulerPolicies.OwnerTask)((SchedulerPolicies.ObjectValue)pq.iterator().next()).o;
        }
        return stolenTasks;
    }

    @Override
    public LinkedList<Implementation<?>> sortImplementationsForResource(LinkedList<Implementation<?>> runnable, Worker<?> resource, TaskScheduler.ExecutionProfile[][] profiles) {
        LinkedList sorted = new LinkedList();
        sorted.addAll(runnable);
        return sorted;
    }
}

