/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.loader;

import integratedtoolkit.types.annotations.Method;
import integratedtoolkit.types.annotations.Orchestration;
import integratedtoolkit.types.annotations.Service;
import integratedtoolkit.util.ErrorManager;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.MethodCall;

public class LoaderUtils {
    public static java.lang.reflect.Method checkRemote(CtMethod method, java.lang.reflect.Method[] remoteMethods) throws NotFoundException {
        for (java.lang.reflect.Method remote : remoteMethods) {
            if (remote.isAnnotationPresent(Method.class)) {
                if (!LoaderUtils.isSelectedMethod(method, remote)) continue;
                return remote;
            }
            if (remote.isAnnotationPresent(Service.class)) {
                if (!LoaderUtils.isSelectedService(method, remote)) continue;
                return remote;
            }
            ErrorManager.error("Task '" + remote.getName() + "' does not have @Method or @Service annotation.\n" + "Check the COMPSs manual for more information.");
        }
        return null;
    }

    private static boolean isSelectedMethod(CtMethod method, java.lang.reflect.Method remote) throws NotFoundException {
        Class<?>[] paramClassRemote;
        Method methodAnnot = remote.getAnnotation(Method.class);
        String nameRemote = methodAnnot.name();
        if (nameRemote.equals("[unassigned]")) {
            nameRemote = remote.getName();
        }
        if (!nameRemote.equals(method.getName())) {
            return false;
        }
        boolean matchesClass = false;
        String[] remoteDeclaringClasses = methodAnnot.declaringClass();
        for (int i = 0; i < remoteDeclaringClasses.length && !matchesClass; ++i) {
            String remoteDeclaringClass = remoteDeclaringClasses[i];
            matchesClass = remoteDeclaringClass.compareTo(method.getDeclaringClass().getName()) == 0;
        }
        if (!matchesClass) {
            return false;
        }
        CtClass[] paramClassCurrent = method.getParameterTypes();
        if (paramClassCurrent.length != (paramClassRemote = remote.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < paramClassCurrent.length; ++i) {
            if (paramClassCurrent[i].getName().equals(paramClassRemote[i].getCanonicalName())) continue;
            return false;
        }
        return true;
    }

    private static boolean isSelectedService(CtMethod method, java.lang.reflect.Method remote) throws NotFoundException {
        String nsp;
        Class<?>[] paramClassRemote;
        Service serviceAnnot = remote.getAnnotation(Service.class);
        String nameRemote = serviceAnnot.operation();
        if (nameRemote.equals("[unassigned]")) {
            nameRemote = remote.getName();
        }
        if (!nameRemote.equals(method.getName())) {
            return false;
        }
        CtClass[] paramClassCurrent = method.getParameterTypes();
        if (paramClassCurrent.length != (paramClassRemote = remote.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < paramClassCurrent.length; ++i) {
            if (paramClassCurrent[i].getName().equals(paramClassRemote[i].getCanonicalName())) continue;
            return false;
        }
        String packName = method.getDeclaringClass().getPackageName();
        return packName.equals(nsp = LoaderUtils.combineServiceMetadata(serviceAnnot));
    }

    private static String combineServiceMetadata(Service annot) {
        String namespace = annot.namespace();
        String service = annot.name();
        String port = annot.port();
        int startIndex = namespace.indexOf("//www.");
        startIndex = startIndex < 0 ? ((startIndex = namespace.indexOf("http://")) >= 0 ? (startIndex += "http://".length()) : 0) : (startIndex += "//www.".length());
        namespace = namespace.substring(startIndex).replace('/', '.').replace('-', '.').replace(':', '.');
        return "dummy." + namespace + '.' + service + '.' + port;
    }

    public static boolean isStreamClose(MethodCall mc) {
        String className;
        String fullName;
        return mc.getMethodName().equals("close") && (fullName = mc.getClassName()).startsWith("java.io.") && ((className = fullName.substring(8)).equals("FileInputStream") || className.equals("FileOutputStream") || className.equals("InputStreamReader") || className.equals("BufferedReader") || className.equals("FileWriter") || className.equals("PrintWriter") || className.equals("FileReader") || className.equals("OutputStreamWriter") || className.equals("BufferedInputStream") || className.equals("BufferedOutputStream") || className.equals("BufferedWriter") || className.equals("PrintStream") || className.equals("RandomAccessFile") || className.equals("DataInputStream") || className.equals("DataOutputStream"));
    }

    public static String randomName(int length, String prefix) {
        if (length < 1) {
            return prefix;
        }
        Random r = new Random();
        StringBuilder buffer = new StringBuilder();
        int gap = 10;
        for (int i = 0; i < length; ++i) {
            char c = (char)(r.nextInt(gap) + 48);
            buffer.append(c);
        }
        return prefix + buffer.toString();
    }

    public static boolean isMainMethod(CtMethod m) throws NotFoundException {
        return m.getName().equals("main") && m.getParameterTypes().length == 1 && m.getParameterTypes()[0].getName().equals(String[].class.getCanonicalName());
    }

    public static boolean isOrchestration(CtMethod m) {
        return m.hasAnnotation(Orchestration.class);
    }

    public static boolean contains(CtMethod[] methods, CtMethod method) {
        for (CtMethod m : methods) {
            if (!m.equals(method) || !method.getDeclaringClass().equals(m.getDeclaringClass())) continue;
            return true;
        }
        return false;
    }

    public static StringBuilder replaceMethodName(StringBuilder executeTask, String methodName) {
        String patternStr = ",\"" + methodName + "\",";
        int start = executeTask.toString().indexOf(patternStr);
        int end = start + patternStr.length();
        return executeTask.replace(start, end, ",\"" + methodName + "WithUR\",");
    }

    public static StringBuilder modifyString(StringBuilder executeTask, int numParams, String appNameParam, String slaIdParam, String urNameParam, String primaryHostParam, String transferIdParam) {
        int newParams = 5;
        StringBuilder params = new StringBuilder(appNameParam);
        params.append(",");
        params.append(slaIdParam);
        params.append(",");
        params.append(urNameParam);
        params.append(",");
        params.append(primaryHostParam);
        params.append(",");
        params.append(transferIdParam);
        params.append("});");
        String patternStr = numParams == 0 ? "0,null);" : "," + numParams + ",";
        int start = executeTask.toString().indexOf(patternStr);
        int end = start + patternStr.length();
        if (numParams == 0) {
            return executeTask.replace(start, end, newParams + ",new Object[]{" + params);
        }
        executeTask.replace(start + 1, end - 1, Integer.toString(numParams + newParams));
        executeTask.replace(executeTask.length() - 3, executeTask.length(), "");
        return executeTask.append("," + params);
    }

    public static Object runMethodOnObject(Object o, Class<?> methodClass, String methodName, Object[] values, Class<?>[] types) throws Throwable {
        java.lang.reflect.Method method = null;
        try {
            method = methodClass.getMethod(methodName, types);
        }
        catch (SecurityException e) {
            ErrorManager.error("Error writing the instrumented class file");
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            String errMsg = "Requested method " + methodName + " of " + methodClass + " not found\n" + "Types length is " + types.length + "\n";
            for (Class<?> type : types) {
                errMsg = errMsg + "Type is " + type;
            }
            ErrorManager.error(errMsg);
        }
        Object retValue = null;
        try {
            retValue = method.invoke(o, values);
        }
        catch (IllegalArgumentException e) {
            ErrorManager.error("Wrong argument passed to method " + methodName, e);
        }
        catch (IllegalAccessException e) {
            ErrorManager.error("Cannot access method " + methodName, e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        return retValue;
    }

    public static boolean isFileDelete(MethodCall mc) {
        if (mc.getMethodName().equals("delete")) {
            return mc.getClassName().compareTo("java.io.File") == 0;
        }
        return false;
    }
}

