/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.loader.total;

import integratedtoolkit.api.IntegratedToolkit;
import integratedtoolkit.loader.LoaderAPI;
import integratedtoolkit.util.ErrorManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class StreamRegistry {
    private LoaderAPI itApi;
    private TreeMap<String, StreamList> fileToStreams;
    HashSet<String> taskFiles;
    private boolean onWindows;
    private String tempDirPath;
    private static final Logger logger = Logger.getLogger("integratedtoolkit.Loader");
    private static final boolean debug = logger.isDebugEnabled();
    private static final String lineSep = System.getProperty("line.separator");

    public StreamRegistry(LoaderAPI api) {
        this.itApi = api;
        this.fileToStreams = new TreeMap();
        this.taskFiles = new HashSet();
        this.onWindows = File.separatorChar == '\\';
        this.tempDirPath = api.getTempDir();
    }

    public FileInputStream newFileInputStream(File file) throws FileNotFoundException {
        StreamDirection direction = StreamDirection.IN;
        StreamList list = this.obtainList(file, direction);
        FileInputStream fis = new FileInputStream(list.getRenaming());
        list.addStream(fis);
        try {
            list.addFD(fis.getFD());
        }
        catch (IOException e) {
            throw new FileNotFoundException("Loader - Error creating FileInputStream for file " + file + lineSep + e.getMessage());
        }
        return fis;
    }

    public FileInputStream newFileInputStream(String fileName) throws FileNotFoundException {
        return this.newFileInputStream(new File(fileName));
    }

    public FileInputStream newFileInputStream(FileDescriptor fd) {
        StreamList list = this.obtainList(fd);
        FileInputStream fis = new FileInputStream(fd);
        if (list != null) {
            list.addStream(fis);
        }
        return fis;
    }

    public FileOutputStream newFileOutputStream(File file, boolean append) throws FileNotFoundException {
        StreamDirection direction = append ? StreamDirection.INOUT : StreamDirection.OUT;
        StreamList list = this.obtainList(file, direction);
        FileOutputStream fos = new FileOutputStream(list.getRenaming(), append);
        list.addStream(fos);
        try {
            list.addFD(fos.getFD());
        }
        catch (IOException e) {
            throw new FileNotFoundException("Loader - Error creating FileOutputStream for file " + file + lineSep + e.getMessage());
        }
        return fos;
    }

    public FileOutputStream newFileOutputStream(File file) throws FileNotFoundException {
        return this.newFileOutputStream(file, false);
    }

    public FileOutputStream newFileOutputStream(String fileName, boolean append) throws FileNotFoundException {
        return this.newFileOutputStream(new File(fileName), append);
    }

    public FileOutputStream newFileOutputStream(String fileName) throws FileNotFoundException {
        return this.newFileOutputStream(new File(fileName), false);
    }

    public FileOutputStream newFileOutputStream(FileDescriptor fd) {
        StreamList list = this.obtainList(fd);
        FileOutputStream fos = new FileOutputStream(fd);
        if (list != null) {
            list.addStream(fos);
        }
        return fos;
    }

    public void newFilterStream(Object stream, Object filter) {
        this.replaceStream(stream, filter);
    }

    public RandomAccessFile newRandomAccessFile(File file, String mode) throws FileNotFoundException {
        StreamDirection direction = mode.length() == 1 ? StreamDirection.IN : StreamDirection.INOUT;
        StreamList list = this.obtainList(file, direction);
        RandomAccessFile raf = new RandomAccessFile(list.getRenaming(), mode);
        list.addStream(raf);
        try {
            list.addFD(raf.getFD());
        }
        catch (IOException e) {
            throw new FileNotFoundException("Loader - Error creating RandomAccessFile for file " + file + lineSep + e.getMessage());
        }
        return raf;
    }

    public RandomAccessFile newRandomAccessFile(String fileName, String mode) throws FileNotFoundException {
        return this.newRandomAccessFile(new File(fileName), mode);
    }

    public FileReader newFileReader(File file) throws FileNotFoundException {
        StreamDirection direction = StreamDirection.IN;
        StreamList list = this.obtainList(file, direction);
        FileReader fr = new FileReader(list.getRenaming());
        list.addStream(fr);
        return fr;
    }

    public FileReader newFileReader(String fileName) throws FileNotFoundException {
        return this.newFileReader(new File(fileName));
    }

    public FileReader newFileReader(FileDescriptor fd) {
        StreamList list = this.obtainList(fd);
        FileReader fr = new FileReader(fd);
        if (list != null) {
            list.addStream(fr);
        }
        return fr;
    }

    public InputStreamReader newInputStreamReader(InputStream is) {
        InputStreamReader isr = new InputStreamReader(is);
        this.replaceStream(is, isr);
        return isr;
    }

    public InputStreamReader newInputStreamReader(InputStream is, Charset cs) {
        InputStreamReader isr = new InputStreamReader(is, cs);
        this.replaceStream(is, isr);
        return isr;
    }

    public InputStreamReader newInputStreamReader(InputStream is, CharsetDecoder dec) {
        InputStreamReader isr = new InputStreamReader(is, dec);
        this.replaceStream(is, isr);
        return isr;
    }

    public InputStreamReader newInputStreamReader(InputStream is, String charsetName) throws UnsupportedEncodingException {
        InputStreamReader isr = new InputStreamReader(is, charsetName);
        this.replaceStream(is, isr);
        return isr;
    }

    public BufferedReader newBufferedReader(Reader r) {
        BufferedReader br = new BufferedReader(r);
        this.replaceStream(r, br);
        return br;
    }

    public BufferedReader newBufferedReader(Reader r, int size) {
        BufferedReader br = new BufferedReader(r, size);
        this.replaceStream(r, br);
        return br;
    }

    public FileWriter newFileWriter(File file, boolean append) throws IOException {
        StreamDirection direction = append ? StreamDirection.INOUT : StreamDirection.OUT;
        StreamList list = this.obtainList(file, direction);
        FileWriter fw = new FileWriter(list.getRenaming(), append);
        list.addStream(fw);
        return fw;
    }

    public FileWriter newFileWriter(File file) throws IOException {
        return this.newFileWriter(file, false);
    }

    public FileWriter newFileWriter(String fileName, boolean append) throws IOException {
        return this.newFileWriter(new File(fileName), append);
    }

    public FileWriter newFileWriter(String fileName) throws IOException {
        return this.newFileWriter(new File(fileName), false);
    }

    public FileWriter newFileWriter(FileDescriptor fd) {
        StreamList list = this.obtainList(fd);
        FileWriter fw = new FileWriter(fd);
        if (list != null) {
            list.addStream(fw);
        }
        return fw;
    }

    public OutputStreamWriter newOutputStreamWriter(OutputStream os) {
        OutputStreamWriter osw = new OutputStreamWriter(os);
        this.replaceStream(os, osw);
        return osw;
    }

    public OutputStreamWriter newOutputStreamWriter(OutputStream os, Charset cs) {
        OutputStreamWriter osw = new OutputStreamWriter(os, cs);
        this.replaceStream(os, osw);
        return osw;
    }

    public OutputStreamWriter newOutputStreamWriter(OutputStream os, CharsetEncoder dec) {
        OutputStreamWriter osw = new OutputStreamWriter(os, dec);
        this.replaceStream(os, osw);
        return osw;
    }

    public OutputStreamWriter newOutputStreamWriter(OutputStream os, String charsetName) throws UnsupportedEncodingException {
        OutputStreamWriter osw = new OutputStreamWriter(os, charsetName);
        this.replaceStream(os, osw);
        return osw;
    }

    public BufferedWriter newBufferedWriter(Writer w) {
        BufferedWriter bw = new BufferedWriter(w);
        this.replaceStream(w, bw);
        return bw;
    }

    public BufferedWriter newBufferedWriter(Writer w, int size) {
        BufferedWriter bw = new BufferedWriter(w, size);
        this.replaceStream(w, bw);
        return bw;
    }

    public PrintStream newPrintStream(File file) throws FileNotFoundException {
        StreamDirection direction = StreamDirection.OUT;
        StreamList list = this.obtainList(file, direction);
        PrintStream ps = new PrintStream(list.getRenaming());
        list.addStream(ps);
        return ps;
    }

    public PrintStream newPrintStream(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        StreamDirection direction = StreamDirection.OUT;
        StreamList list = this.obtainList(file, direction);
        PrintStream ps = new PrintStream(list.getRenaming(), csn);
        list.addStream(ps);
        return ps;
    }

    public PrintStream newPrintStream(String fileName) throws FileNotFoundException {
        return this.newPrintStream(new File(fileName));
    }

    public PrintStream newPrintStream(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        return this.newPrintStream(new File(fileName), csn);
    }

    public PrintStream newPrintStream(OutputStream os) {
        PrintStream ps = new PrintStream(os);
        this.replaceStream(os, ps);
        return ps;
    }

    public PrintStream newPrintStream(OutputStream os, boolean autoFlush) {
        PrintStream ps = new PrintStream(os, autoFlush);
        this.replaceStream(os, ps);
        return ps;
    }

    public PrintStream newPrintStream(OutputStream os, boolean autoFlush, String encoding) throws UnsupportedEncodingException {
        PrintStream ps = new PrintStream(os, autoFlush, encoding);
        this.replaceStream(os, ps);
        return ps;
    }

    public PrintWriter newPrintWriter(File file) throws FileNotFoundException {
        StreamDirection direction = StreamDirection.OUT;
        StreamList list = this.obtainList(file, direction);
        PrintWriter pw = new PrintWriter(list.getRenaming());
        list.addStream(pw);
        return pw;
    }

    public PrintWriter newPrintWriter(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        StreamDirection direction = StreamDirection.OUT;
        StreamList list = this.obtainList(file, direction);
        PrintWriter pw = new PrintWriter(list.getRenaming(), csn);
        list.addStream(pw);
        return pw;
    }

    public PrintWriter newPrintWriter(String fileName) throws FileNotFoundException {
        return this.newPrintWriter(new File(fileName));
    }

    public PrintWriter newPrintWriter(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        return this.newPrintWriter(new File(fileName), csn);
    }

    public PrintWriter newPrintWriter(OutputStream os) {
        PrintWriter pw = new PrintWriter(os);
        this.replaceStream(os, pw);
        return pw;
    }

    public PrintWriter newPrintWriter(OutputStream os, boolean autoFlush) {
        PrintWriter pw = new PrintWriter(os, autoFlush);
        this.replaceStream(os, pw);
        return pw;
    }

    public PrintWriter newPrintWriter(Writer w) {
        PrintWriter pw = new PrintWriter(w);
        this.replaceStream(w, pw);
        return pw;
    }

    public PrintWriter newPrintWriter(Writer w, boolean autoFlush) {
        PrintWriter pw = new PrintWriter(w, autoFlush);
        this.replaceStream(w, pw);
        return pw;
    }

    private StreamList obtainList(File file, StreamDirection direction) {
        StreamList list;
        String path = null;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            ErrorManager.fatal("Cannot create stream for file " + file.getAbsolutePath() + " with direction " + (Object)((Object)direction), e);
        }
        if (this.onWindows) {
            path = path.toLowerCase();
        }
        if ((list = this.fileToStreams.get(path)) == null) {
            if (debug) {
                logger.debug("First stream on the list for file " + path + " with direction " + (Object)((Object)direction));
            }
            String renaming = null;
            switch (direction) {
                case IN: {
                    renaming = this.itApi.getFile(path, this.tempDirPath);
                    break;
                }
                case OUT: {
                    renaming = this.itApi.openFile(path, IntegratedToolkit.OpenMode.WRITE);
                    break;
                }
                case INOUT: {
                    renaming = this.itApi.openFile(path, IntegratedToolkit.OpenMode.APPEND);
                }
            }
            list = new StreamList(renaming, direction);
            this.fileToStreams.put(path, list);
        }
        if (direction != StreamDirection.IN) {
            list.setWritten(true);
        }
        if (debug) {
            logger.debug("New stream for file " + path + " with renaming " + list.getRenaming() + " and direction " + (Object)((Object)direction));
        }
        return list;
    }

    private StreamList obtainList(FileDescriptor fd) {
        for (StreamList list : this.fileToStreams.values()) {
            if (!list.containsFD(fd)) continue;
            if (debug) {
                logger.debug("Found list for file descriptor " + fd + ": file " + list.getRenaming());
            }
            return list;
        }
        return null;
    }

    private void replaceStream(Object oldStream, Object newStream) {
        for (Map.Entry<String, StreamList> e : this.fileToStreams.entrySet()) {
            StreamList list = e.getValue();
            ListIterator<Object> listIt = list.getIterator();
            while (listIt.hasNext()) {
                Object listStream = listIt.next();
                if (!listStream.equals(oldStream)) continue;
                listIt.set(newStream);
                if (!debug) continue;
                logger.debug("Replaced stream of " + oldStream.getClass() + " by another of " + newStream.getClass());
            }
        }
    }

    public void streamClosed(Object stream) {
        Iterator<Map.Entry<String, StreamList>> entryIt = this.fileToStreams.entrySet().iterator();
        boolean found = false;
        while (entryIt.hasNext()) {
            Map.Entry<String, StreamList> e = entryIt.next();
            StreamList list = e.getValue();
            ListIterator<Object> listIt = list.getIterator();
            while (listIt.hasNext()) {
                Object listStream = listIt.next();
                if (!listStream.equals(stream)) continue;
                listIt.remove();
                found = true;
            }
            if (!found) continue;
            if (debug) {
                logger.debug("Found closed stream of " + stream.getClass());
            }
            if (!list.isEmpty()) break;
            if (debug) {
                logger.debug("Empty stream list");
            }
            if (list.isFirstStreamInput() && list.getWritten()) {
                String filePath = e.getKey();
                String oldRen = list.getRenaming();
                String newRen = this.itApi.openFile(filePath, IntegratedToolkit.OpenMode.WRITE);
                File f = new File(oldRen);
                f.renameTo(new File(newRen));
                if (debug) {
                    logger.debug("Renamed and moved file from " + oldRen + " to " + newRen);
                }
            }
            entryIt.remove();
            break;
        }
    }

    public boolean isTaskFile(String fileName) {
        File f = new File(fileName);
        return this.taskFiles.contains(f.getAbsolutePath());
    }

    public void addTaskFile(String fileName) {
        File f = new File(fileName);
        this.taskFiles.add(f.getAbsolutePath());
    }

    private class StreamList {
        private String fileRenaming;
        private boolean firstIsInputStream;
        private boolean written;
        private List<Object> list;
        private List<FileDescriptor> fds;

        public StreamList(String renaming, StreamDirection direction) {
            this.fileRenaming = renaming;
            this.firstIsInputStream = direction == StreamDirection.IN;
            this.written = false;
            this.list = new LinkedList<Object>();
            this.fds = new LinkedList<FileDescriptor>();
        }

        public void addStream(Object stream) {
            this.list.add(stream);
        }

        public void addFD(FileDescriptor fd) {
            this.fds.add(fd);
        }

        public String getRenaming() {
            return this.fileRenaming;
        }

        public boolean isFirstStreamInput() {
            return this.firstIsInputStream;
        }

        public boolean getWritten() {
            return this.written;
        }

        public ListIterator<Object> getIterator() {
            return (ListIterator)this.list.iterator();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public boolean containsFD(FileDescriptor fd) {
            return this.fds.contains(fd);
        }

        public void setWritten(boolean b) {
            this.written = b;
        }
    }

    private static enum StreamDirection {
        IN,
        OUT,
        INOUT;

    }
}

