/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.data;

import integratedtoolkit.comm.Comm;
import integratedtoolkit.types.data.AccessParams;
import integratedtoolkit.types.data.DataAccessId;
import integratedtoolkit.types.data.DataInstanceId;
import java.util.LinkedList;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public abstract class DataInfo {
    private static final int FIRST_FILE_ID = 1;
    private static final int FIRST_VERSION_ID = 1;
    protected int dataId = nextDataId++;
    protected TreeMap<Integer, Version> versions = new TreeMap();
    protected Version currentVersion = new Version(this.dataId, 1);
    protected static int nextDataId;
    protected int currentVersionId = 1;
    private int readers;
    protected boolean toDelete;

    public static void init() {
        nextDataId = 1;
    }

    public DataInfo() {
        this.versions.put(this.currentVersionId, this.currentVersion);
        this.readers = 0;
    }

    public int getDataId() {
        return this.dataId;
    }

    public int getLastVersionId() {
        return this.currentVersionId;
    }

    public DataInstanceId getLastDataInstanceId() {
        return this.currentVersion.dataInstanceId;
    }

    public LinkedList<DataInstanceId> getAllDataInstances() {
        LinkedList<DataInstanceId> renamings = new LinkedList<DataInstanceId>();
        for (Version version : this.versions.values()) {
            renamings.add(version.dataInstanceId);
        }
        return renamings;
    }

    public int getNumberOfVersions() {
        return this.versions.size();
    }

    public int getReaders() {
        return this.readers;
    }

    public Integer getReadersForVersion(int versionId) {
        return this.versions.get(versionId).getReaders();
    }

    public void addVersion() {
        ++this.currentVersionId;
        Version newVersion = new Version(this.dataId, this.currentVersionId);
        this.versions.put(this.currentVersionId, newVersion);
        this.currentVersion = newVersion;
    }

    public int willBeRead(int methodId) {
        int i = this.currentVersion.willBeRead(methodId);
        ++this.readers;
        return i;
    }

    public Integer versionHasBeenRead(int versionId, int methodId) {
        int i = this.versions.get(versionId).hasBeenRead(methodId);
        --this.readers;
        return i;
    }

    public void removeVersion(int versionId) {
        this.versions.remove(versionId);
    }

    public DataAccessId manageAccess(AccessParams.AccessMode mode, int readerId, boolean debug, Logger logger) {
        DataAccessId daId = null;
        switch (mode) {
            case R: {
                this.willBeRead(readerId);
                daId = new DataAccessId.RAccessId(this.getLastDataInstanceId());
                if (!debug) break;
                StringBuilder sb = new StringBuilder("");
                sb.append("Access:").append("\n");
                sb.append("  * Type: R").append("\n");
                sb.append("  * Read Datum: d").append(daId.getDataId()).append("v").append(((DataAccessId.RAccessId)daId).getRVersionId()).append("\n");
                logger.debug(sb.toString());
                break;
            }
            case W: {
                this.addVersion();
                daId = new DataAccessId.WAccessId(this.getLastDataInstanceId());
                if (!debug) break;
                StringBuilder sb = new StringBuilder("");
                sb.append("Access:").append("\n");
                sb.append("  * Type: W").append("\n");
                sb.append("  * Write Datum: d").append(daId.getDataId()).append("v").append(((DataAccessId.WAccessId)daId).getWVersionId()).append("\n");
                logger.debug(sb.toString());
                break;
            }
            case RW: {
                int versionReaders = this.willBeRead(readerId);
                DataInstanceId readInstance = this.getLastDataInstanceId();
                this.addVersion();
                DataInstanceId writtenInstance = this.getLastDataInstanceId();
                boolean preserveSourceData = versionReaders > 1;
                daId = new DataAccessId.RWAccessId(readInstance, writtenInstance, preserveSourceData);
                if (!debug) break;
                StringBuilder sb = new StringBuilder("");
                sb.append("Access:").append("\n");
                sb.append("  * Type: RW").append("\n");
                sb.append("  * Read Datum: d").append(daId.getDataId()).append("v").append(((DataAccessId.RWAccessId)daId).getRVersionId()).append("\n");
                sb.append("  * Write Datum: d").append(daId.getDataId()).append("v").append(((DataAccessId.RWAccessId)daId).getWVersionId()).append("\n");
                logger.debug(sb.toString());
            }
        }
        return daId;
    }

    public boolean isToDelete() {
        return this.toDelete;
    }

    public void setToDelete(boolean deleted) {
        this.toDelete = deleted;
    }

    protected class Version {
        private int readers = 0;
        private DataInstanceId dataInstanceId;

        public Version(int dataId, int versionId) {
            this.dataInstanceId = new DataInstanceId(dataId, versionId);
            Comm.registerData(this.dataInstanceId.getRenaming());
        }

        public int willBeRead(int methodId) {
            ++this.readers;
            return this.readers;
        }

        public int hasBeenRead(int methodId) {
            --this.readers;
            return this.readers;
        }

        public int getReaders() {
            return this.readers;
        }
    }
}

