/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.data.operation;

import integratedtoolkit.types.data.operation.DataOperation;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;

public class OneOpWithSemListener
extends DataOperation.EventListener {
    private static final Logger logger = Logger.getLogger("integratedtoolkit.Components.TaskDispatcher.FileTransferManager");
    private static final boolean debug = logger.isDebugEnabled();
    private Semaphore sem;

    public OneOpWithSemListener(Semaphore sem) {
        logger.debug("Listener for OP with Semaphore Listener: " + sem.toString());
        this.sem = sem;
    }

    @Override
    public void notifyEnd(DataOperation fOp) {
        logger.debug("Listener for OP with Semaphore Listener: " + this.sem.toString() + "released");
        this.sem.release();
    }

    @Override
    public void notifyFailure(DataOperation fOp, Exception e) {
        if (debug) {
            logger.error("THREAD " + Thread.currentThread().getName() + " File Operation failed on " + fOp.getName() + ", file role is OPEN_FILE" + ", operation end state is FAILED", e);
        } else {
            logger.error("THREAD " + Thread.currentThread().getName() + " File Operation failed on " + fOp.getName() + ", file role is OPEN_FILE" + ", operation end state is FAILED");
        }
        this.sem.release();
    }
}

