/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.document;

import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.w3c.dom.Node;

public abstract class Document
extends PoolElement {
    private static final String METHOD_PREFIX = "document.";
    private static final String ALLOCATE = "document.allocate";
    private static final String DELETE = "document.delete";
    private static final String INFO = "document.info";
    private static final String UPDATE = "document.update";
    private static final String CHOWN = "document.chown";
    private static final String CHMOD = "document.chmod";
    private static final String CLONE = "document.clone";
    private static final String RENAME = "document.rename";

    public Document(int n, Client client) {
        super(n, client);
    }

    public Document(Node node, Client client) {
        super(node, client);
    }

    protected static OneResponse allocate(Client client, String string, int n) {
        return client.call(ALLOCATE, string, n);
    }

    public OneResponse info() {
        return this.client.call(INFO, this.id);
    }

    public OneResponse delete() {
        return this.client.call(DELETE, this.id);
    }

    public OneResponse update(String string) {
        return this.update(string, false);
    }

    public OneResponse update(String string, boolean bl) {
        return this.client.call(UPDATE, this.id, string, bl);
    }

    public OneResponse publish(boolean bl) {
        int n = bl ? 1 : 0;
        return this.chmod(-1, -1, -1, n, -1, -1, -1, -1, -1);
    }

    public OneResponse chown(int n, int n2) {
        return this.client.call(CHOWN, this.id, n, n2);
    }

    public OneResponse chmod(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return Document.chmod(this.client, CHMOD, this.id, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public OneResponse chmod(String string) {
        return Document.chmod(this.client, CHMOD, this.id, string);
    }

    public OneResponse chmod(int n) {
        return Document.chmod(this.client, CHMOD, this.id, n);
    }

    public OneResponse clone(String string) {
        return this.client.call(CLONE, this.id, string);
    }

    public OneResponse rename(String string) {
        return this.client.call(RENAME, this.id, string);
    }

    public OneResponse publish() {
        return this.publish(true);
    }

    public OneResponse unpublish() {
        return this.publish(false);
    }

    public OneResponse chown(int n) {
        return this.chown(n, -1);
    }

    public OneResponse chgrp(int n) {
        return this.chown(-1, n);
    }
}

