/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.util;

import com.trilead.ssh2.log.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedList;

public class TimeoutService {
    private static final Logger log = Logger.getLogger(TimeoutService.class);
    private static final LinkedList<TimeoutToken> todolist = new LinkedList();
    private static Thread timeoutThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final TimeoutToken addTimeoutHandler(long runTime, Runnable handler) {
        TimeoutToken token = new TimeoutToken(runTime, handler);
        LinkedList<TimeoutToken> linkedList = todolist;
        synchronized (linkedList) {
            todolist.add(token);
            Collections.sort(todolist);
            if (timeoutThread != null) {
                timeoutThread.interrupt();
            } else {
                timeoutThread = new TimeoutThread();
                timeoutThread.setDaemon(true);
                timeoutThread.start();
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void cancelTimeoutHandler(TimeoutToken token) {
        LinkedList<TimeoutToken> linkedList = todolist;
        synchronized (linkedList) {
            todolist.remove(token);
            if (timeoutThread != null) {
                timeoutThread.interrupt();
            }
        }
    }

    private static class TimeoutThread
    extends Thread {
        private TimeoutThread() {
        }

        public void run() {
            LinkedList linkedList = todolist;
            synchronized (linkedList) {
                block7: while (true) {
                    while (true) {
                        if (todolist.size() == 0) {
                            timeoutThread = null;
                            return;
                        }
                        long now = System.currentTimeMillis();
                        TimeoutToken tt = (TimeoutToken)todolist.getFirst();
                        if (tt.runTime > now) {
                            try {
                                todolist.wait(tt.runTime - now);
                            }
                            catch (InterruptedException e) {}
                            continue;
                        }
                        todolist.removeFirst();
                        try {
                            tt.handler.run();
                            continue block7;
                        }
                        catch (Exception e) {
                            StringWriter sw = new StringWriter();
                            e.printStackTrace(new PrintWriter(sw));
                            log.log(20, "Exeception in Timeout handler:" + e.getMessage() + "(" + sw.toString() + ")");
                            continue;
                        }
                        break;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimeoutToken
    implements Comparable<TimeoutToken> {
        private long runTime;
        private Runnable handler;

        private TimeoutToken(long runTime, Runnable handler) {
            this.runTime = runTime;
            this.handler = handler;
        }

        @Override
        public int compareTo(TimeoutToken t) {
            if (this.runTime > t.runTime) {
                return 1;
            }
            if (this.runTime == t.runTime) {
                return 0;
            }
            return -1;
        }
    }
}

