/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.gat.master;

import integratedtoolkit.gat.master.GATWorkerNode;
import integratedtoolkit.util.RequestDispatcher;
import integratedtoolkit.util.RequestQueue;
import integratedtoolkit.util.ThreadPool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import org.apache.log4j.Logger;
import org.gridlab.gat.GAT;
import org.gridlab.gat.URI;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.resources.SoftwareDescription;

public class CleanerExecutor {
    private static final String ANY_PROT = "any://";
    private static final String THREAD_POOL_START_ERR = "Error starting pool of threads";
    private static final String THREAD_POOL_STOP_ERR = "Error stopping pool of threads";
    private static final String CLEAN_JOB_ERR = "Error running clean job";
    private static final String POOL_NAME = "Cleaner";
    private static final int POOL_SIZE = 5;
    private int jobCount;
    private ThreadPool pool;
    private GATWorkerNode node;
    RequestQueue<Job> jobQueue;
    RequestQueue<SoftwareDescription> sdQueue = new RequestQueue();
    private static final Logger logger = Logger.getLogger("integratedtoolkit.Components.TaskDispatcher.FileTransferManager");
    private static final boolean debug = logger.isDebugEnabled();

    public CleanerExecutor(GATWorkerNode node) {
        this.jobQueue = new RequestQueue();
        this.pool = new ThreadPool(5, POOL_NAME, new CleanDispatcher(this.sdQueue, this.jobQueue, node));
        this.node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeScript(List<URI> cleanScripts, List<String> cleanParams) {
        String line;
        BufferedReader br;
        RequestQueue<Job> cleanParam;
        try {
            this.pool.startThreads();
        }
        catch (Exception e) {
            logger.error(THREAD_POOL_START_ERR, e);
            return;
        }
        RequestQueue<Job> e = this.jobQueue;
        synchronized (e) {
            this.jobCount = cleanScripts.size();
        }
        for (int i = 0; i < cleanScripts.size(); ++i) {
            URI script = cleanScripts.get(i);
            cleanParam = cleanParams.get(i);
            if (script == null) continue;
            if (debug) {
                logger.debug("Clean call: " + script + " " + (String)((Object)cleanParam));
            }
            try {
                String user;
                if (!this.node.isUserNeeded() && script.getUserInfo() != null) {
                    script.setUserInfo(null);
                }
                user = (user = script.getUserInfo()) == null ? "" : user + "@";
                SoftwareDescription sd = new SoftwareDescription();
                sd.addAttribute("uri", ANY_PROT + user + script.getHost());
                sd.setExecutable(script.getPath());
                sd.setArguments(((String)((Object)cleanParam)).split(" "));
                sd.addAttribute("job_number", i);
                sd.addAttribute("sandbox.root", "/tmp/");
                sd.addAttribute("sandbox.useroot", "true");
                sd.addAttribute("sandbox.delete", "false");
                if (debug) {
                    try {
                        org.gridlab.gat.io.File outFile = GAT.createFile(this.node.getContext(), "any:///" + System.getProperty("it.appLogDir") + "/cleaner.out");
                        sd.setStdout(outFile);
                        org.gridlab.gat.io.File errFile = GAT.createFile(this.node.getContext(), "any:///" + System.getProperty("it.appLogDir") + "/cleaner.err");
                        sd.setStderr(errFile);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                this.sdQueue.enqueue(sd);
                continue;
            }
            catch (Exception e3) {
                logger.error(CLEAN_JOB_ERR, e3);
                return;
            }
        }
        Long timeout = System.currentTimeMillis() + 60000L;
        while (this.jobCount > 0 && System.currentTimeMillis() < timeout) {
            Job job = this.jobQueue.dequeue();
            if (job == null) {
                cleanParam = this.jobQueue;
                synchronized (cleanParam) {
                    --this.jobCount;
                    continue;
                }
            }
            if (job.getState() == Job.JobState.STOPPED) {
                cleanParam = this.jobQueue;
                synchronized (cleanParam) {
                    --this.jobCount;
                    continue;
                }
            }
            if (job.getState() == Job.JobState.SUBMISSION_ERROR) {
                logger.error("Error running clean job: " + job);
                cleanParam = this.jobQueue;
                synchronized (cleanParam) {
                    --this.jobCount;
                    continue;
                }
            }
            this.jobQueue.enqueue(job);
            try {
                Thread.sleep(50L);
            }
            catch (Exception e4) {}
        }
        try {
            this.pool.stopThreads();
        }
        catch (Exception e5) {
            logger.error(THREAD_POOL_STOP_ERR, e5);
            return;
        }
        if (debug) {
            try {
                FileReader cleanOut = new FileReader(System.getProperty("it.appLogDir") + "/cleaner.out");
                br = new BufferedReader(cleanOut);
                line = br.readLine();
                while (line != null) {
                    logger.debug(line);
                    line = br.readLine();
                }
                br.close();
            }
            catch (Exception e6) {
                logger.error("Error moving cleaner.out", e6);
            }
            new File(System.getProperty("it.appLogDir") + "/cleaner.out").delete();
        }
        if (debug) {
            try {
                FileReader cleanErr = new FileReader(System.getProperty("it.appLogDir") + "/cleaner.err");
                br = new BufferedReader(cleanErr);
                line = br.readLine();
                while (line != null) {
                    logger.error(line);
                    line = br.readLine();
                }
                br.close();
            }
            catch (Exception e7) {
                logger.error("Error moving cleaner.err", e7);
            }
            new File(System.getProperty("it.appLogDir") + "/cleaner.err").delete();
        }
    }

    class CleanDispatcher
    extends RequestDispatcher<SoftwareDescription> {
        private RequestQueue<Job> jobQueue;
        private GATWorkerNode node;

        public CleanDispatcher(RequestQueue<SoftwareDescription> sdQueue, RequestQueue<Job> jobQueue, GATWorkerNode node) {
            super(sdQueue);
            this.jobQueue = jobQueue;
            this.node = node;
        }

        @Override
        public void processRequests() {
            SoftwareDescription sd;
            while ((sd = (SoftwareDescription)this.queue.dequeue()) != null) {
                try {
                    URI brokerURI = new URI((String)sd.getObjectAttribute("uri"));
                    ResourceBroker broker = GAT.createResourceBroker(this.node.getContext(), brokerURI);
                    Job job = broker.submitJob(new JobDescription(sd));
                    this.jobQueue.enqueue(job);
                }
                catch (Exception e) {
                    logger.error("Error submitting clean job", e);
                    this.jobQueue.enqueue(null);
                }
            }
        }
    }
}

