/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.sshtrilead;

import com.trilead.ssh2.Session;
import com.trilead.ssh2.StreamGobbler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.gridlab.gat.AdaptorNotApplicableException;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.cpi.FileInputStreamCpi;
import org.gridlab.gat.io.cpi.sshtrilead.SshTrileadFileAdaptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshTrileadFileInputStreamAdaptor
extends FileInputStreamCpi {
    private SshTrileadFileAdaptor file;
    private Session session;
    private InputStream sessionOutputStream;
    private InputStreamRunner job;

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = FileInputStreamCpi.getSupportedCapabilities();
        capabilities.put("close", true);
        capabilities.put("markSupported", true);
        capabilities.put("read", true);
        capabilities.put("skip", true);
        return capabilities;
    }

    public static String getDescription() {
        return "The SshTrilead FileInputStream Adaptor implements the FileInputStream object using the trilead ssh library. Trilead ssh is an open source full java ssh library. On the server side, the 'scp' program must be in the PATH. Connections with a remote ssh server can be made by using the username + password, username + keyfile, or with only a username, depending on the client and server settings.";
    }

    public static Preferences getSupportedPreferences() {
        Preferences preferences = FileInputStreamCpi.getSupportedPreferences();
        preferences.put("sshtrilead.caching.iswindows", (Object)"true");
        preferences.put("sshtrilead.caching.iscsh", (Object)"true");
        preferences.put("sshtrilead.cipher.client2server", (Object)"aes256-ctr,aes192-ctr,aes128-ctr,blowfish-ctr,aes256-cbc,aes192-cbc,aes128-cbc,blowfish-cbc");
        preferences.put("sshtrilead.cipher.server2client", (Object)"aes256-ctr,aes192-ctr,aes128-ctr,blowfish-ctr,aes256-cbc,aes192-cbc,aes128-cbc,blowfish-cbc");
        preferences.put("sshtrilead.tcp.nodelay", (Object)"false");
        preferences.put("sshtrilead.use.cached.connections", (Object)"true");
        preferences.put("sshtrilead.connect.timeout", (Object)"5000");
        preferences.put("sshtrilead.kex.timeout", (Object)"5000");
        preferences.put("sshtrilead.strictHostKeyChecking", (Object)"false");
        preferences.put("sshtrilead.noHostKeyChecking", (Object)"true");
        preferences.put("sftptrilead.strictHostKeyChecking", (Object)"false");
        preferences.put("sftptrilead.noHostKeyChecking", (Object)"true");
        return preferences;
    }

    public static String[] getSupportedSchemes() {
        return SshTrileadFileAdaptor.getSupportedSchemes();
    }

    public SshTrileadFileInputStreamAdaptor(GATContext gatContext, URI location) throws GATObjectCreationException, GATInvocationException {
        super(gatContext, location);
        if (location.refersToLocalHost()) {
            throw new AdaptorNotApplicableException("this adaptor cannot read local files");
        }
        this.file = new SshTrileadFileAdaptor(gatContext, location);
        if (!this.file.exists()) {
            throw new GATObjectCreationException("file does not exist");
        }
        if (this.file.isDirectory()) {
            throw new GATObjectCreationException("cannot read from directory");
        }
        if (!this.file.canRead()) {
            throw new GATObjectCreationException("cannot open file");
        }
        try {
            this.session = this.file.getSession();
        }
        catch (Throwable e) {
            throw new GATObjectCreationException("Could not create stream", e);
        }
        this.sessionOutputStream = this.session.getStdout();
        String command = "cat < " + SshTrileadFileAdaptor.protectAgainstShellMetas(this.file.getFixedPath());
        this.job = new InputStreamRunner(command);
        this.job.setDaemon(true);
        this.job.start();
    }

    public void mark(int readlimit) {
        this.sessionOutputStream.mark(readlimit);
    }

    public boolean markSupported() {
        return this.sessionOutputStream.markSupported();
    }

    public int read() throws GATInvocationException {
        try {
            return this.sessionOutputStream.read();
        }
        catch (IOException e) {
            throw new GATInvocationException("got exception", (Throwable)e);
        }
    }

    public int read(byte[] b, int off, int len) throws GATInvocationException {
        try {
            return this.sessionOutputStream.read(b, off, len);
        }
        catch (IOException e) {
            throw new GATInvocationException("got exception", (Throwable)e);
        }
    }

    public int read(byte[] b) throws GATInvocationException {
        try {
            return this.sessionOutputStream.read(b);
        }
        catch (IOException e) {
            throw new GATInvocationException("got exception", (Throwable)e);
        }
    }

    public void reset() throws GATInvocationException {
        try {
            this.sessionOutputStream.reset();
        }
        catch (IOException e) {
            throw new GATInvocationException("got exception", (Throwable)e);
        }
    }

    public long skip(long n) throws GATInvocationException {
        try {
            return this.sessionOutputStream.skip(n);
        }
        catch (IOException e) {
            throw new GATInvocationException("got exception", (Throwable)e);
        }
    }

    public void close() throws GATInvocationException {
        if (this.session != null) {
            try {
                this.sessionOutputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.job.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.session = null;
        }
    }

    private class InputStreamRunner
    extends Thread {
        private final String command;

        public InputStreamRunner(String command) {
            this.command = command;
        }

        public void run() {
            try {
                this.execCommand(this.command);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String[] execCommand(String cmd) throws Exception {
            try {
                String line;
                String[] result = new String[3];
                if (logger.isInfoEnabled()) {
                    logger.info("command: " + cmd);
                }
                SshTrileadFileInputStreamAdaptor.this.session.execCommand(cmd);
                StreamGobbler stderr = new StreamGobbler(SshTrileadFileInputStreamAdaptor.this.session.getStderr());
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)stderr));
                StringBuffer err = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    err.append(line);
                    err.append("\n");
                }
                result[1] = err.toString();
                while (SshTrileadFileInputStreamAdaptor.this.session.getExitStatus() == null) {
                    Thread.sleep(50L);
                }
                result[2] = "" + SshTrileadFileInputStreamAdaptor.this.session.getExitStatus();
                if (logger.isDebugEnabled()) {
                    logger.debug("STDERR: " + result[1]);
                    logger.debug("EXIT:   " + result[2]);
                }
                String[] stringArray = result;
                return stringArray;
            }
            finally {
                SshTrileadFileInputStreamAdaptor.this.session.close();
            }
        }
    }
}

