/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.comm;

import integratedtoolkit.comm.CommAdaptor;
import integratedtoolkit.types.AdaptorDescription;
import integratedtoolkit.types.COMPSsWorker;
import integratedtoolkit.types.data.LogicalData;
import integratedtoolkit.types.data.location.DataLocation;
import integratedtoolkit.types.data.location.URI;
import integratedtoolkit.types.resources.MasterResource;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.util.SharedDiskManager;
import integratedtoolkit.util.Tracer;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class Comm {
    protected static final boolean tracing = System.getProperty("it.tracing") != null && Integer.parseInt(System.getProperty("it.tracing")) > 0;
    protected static final int tracing_level = Integer.parseInt(System.getProperty("it.tracing"));
    private static final String defaultAdaptor = System.getProperty("it.comm");
    private static final HashMap<String, CommAdaptor> adaptors = new HashMap();
    protected static final Logger logger = Logger.getLogger("integratedtoolkit.Communication");
    private static final boolean debug = logger.isDebugEnabled();
    private static Map<String, LogicalData> data = Collections.synchronizedMap(new TreeMap());
    public static MasterResource appHost;

    public static synchronized void init() {
        appHost = new MasterResource();
        try {
            File[] fList;
            URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> sysclass = URLClassLoader.class;
            String itHome = System.getenv("IT_HOME");
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            File directory = new File(itHome + File.separator + "adaptors");
            for (File f : fList = directory.listFiles()) {
                File[] jarList;
                File adaptorMasterDir = new File(f.getAbsolutePath() + File.separator + "master");
                for (File jar : jarList = adaptorMasterDir.listFiles()) {
                    try {
                        method.invoke((Object)sysloader, new File(jar.getAbsolutePath()).toURI().toURL());
                    }
                    catch (Exception e) {
                        logger.error("COULD NOT LOAD ADAPTOR JAR " + jar.getAbsolutePath(), e);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("CAN NOT LOAD ANY ADAPTOR ", e);
        }
        if (tracing) {
            Tracer.init(tracing_level);
            Tracer.masterEventStart(Tracer.Event.STATIC_IT.getId());
        }
    }

    public static synchronized void addSharedDiskToMaster(String diskName, String mountPoint) {
        SharedDiskManager.addSharedToMachine(diskName, mountPoint, appHost);
    }

    public static synchronized COMPSsWorker initWorker(String name, HashMap<String, String> properties, TreeMap<String, AdaptorDescription> adaptorsDesc) throws Exception {
        CommAdaptor adaptor;
        String adaptorName = defaultAdaptor;
        if (adaptorsDesc.keySet().contains("integratedtoolkit.ws.master.WSAdaptor")) {
            adaptorName = "integratedtoolkit.ws.master.WSAdaptor";
        }
        if ((adaptor = adaptors.get(adaptorName)) == null) {
            try {
                Constructor<?> constrAdaptor = Class.forName(adaptorName).getConstructor(new Class[0]);
                adaptor = (CommAdaptor)constrAdaptor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                logger.error("Can not find adaptor class " + adaptorName + ".", e);
            }
            catch (NoSuchMethodException e) {
                logger.error("Class " + adaptorName + " has no valid constructor.", e);
            }
            catch (InstantiationException e) {
                logger.error("Can not instantiate adaptor " + adaptorName + ".", e);
            }
            catch (IllegalAccessException e) {
                logger.error("Illegal access on adaptor " + adaptorName + " creation", e);
            }
            catch (IllegalArgumentException e) {
                logger.error("Illegal argument on adaptor " + adaptorName + " creation", e);
            }
            catch (InvocationTargetException e) {
                logger.error("Wrong target for " + adaptorName + " invocation", e);
            }
            catch (Exception e) {
                logger.error(e);
            }
            adaptor.init();
            adaptors.put(adaptorName, adaptor);
        }
        if (debug) {
            logger.debug("Adaptor Name: " + adaptorName);
            logger.debug("Adaptors Keys: " + adaptorsDesc.keySet());
        }
        COMPSsWorker worker = null;
        AdaptorDescription ad = adaptorsDesc.get(adaptorName);
        if (ad != null && !adaptorName.equals("integratedtoolkit.ws.master.WSAdaptor")) {
            logger.debug("Checking adaptor properties...");
            ad.checkAdaptorProperties();
        }
        logger.debug("Init worker adaptor");
        worker = adaptor.initWorker(name, properties, adaptorsDesc);
        return worker;
    }

    public static synchronized void stop() {
        for (CommAdaptor adaptor : adaptors.values()) {
            adaptor.stop();
        }
    }

    public static synchronized LogicalData registerData(String dataId) {
        logger.debug("Register new data " + dataId);
        LogicalData logicalData = new LogicalData(dataId);
        data.put(dataId, logicalData);
        return logicalData;
    }

    public static synchronized LogicalData registerLocation(String dataId, DataLocation location) {
        logger.debug("Registering new Location for data " + dataId + ":");
        logger.debug("  * Location: " + location);
        LogicalData logicalData = data.get(dataId);
        logicalData.addLocation(location);
        return logicalData;
    }

    public static synchronized LogicalData registerValue(String dataId, Object value) {
        logger.debug("Register value " + value + "for data " + dataId);
        DataLocation location = DataLocation.getLocation(appHost, dataId);
        LogicalData logicalData = data.get(dataId);
        logicalData.addLocationAndValue(location, value);
        return logicalData;
    }

    public static synchronized Object clearValue(String dataId) {
        logger.debug("Clear value of data " + dataId);
        LogicalData logicalData = data.get(dataId);
        return logicalData.removeValue();
    }

    public static synchronized boolean existsData(String renaming) {
        return data.get(renaming) != null;
    }

    public static synchronized LogicalData getData(String dataId) {
        return data.get(dataId);
    }

    public static synchronized String dataDump() {
        StringBuilder sb = new StringBuilder("DATA DUMP\n");
        for (Map.Entry<String, LogicalData> lde : data.entrySet()) {
            sb.append("\t *").append(lde.getKey()).append(":\n");
            LogicalData ld = lde.getValue();
            for (URI u : ld.getURIs()) {
                sb.append("\t\t + ").append(u.toString()).append("\n");
                for (String adaptor : adaptors.keySet()) {
                    Object internal = u.getInternalURI(adaptor);
                    if (internal == null) continue;
                    sb.append("\t\t\t - ").append(internal.toString()).append("\n");
                }
            }
        }
        return sb.toString();
    }

    public static synchronized HashSet<LogicalData> getAllData(Resource host) {
        return LogicalData.getAllDataFromHost(host);
    }

    public static synchronized void removeData(String renaming) {
        logger.debug("Remove data " + renaming);
        LogicalData ld = data.remove(renaming);
        ld.isObsolete();
    }

    public static synchronized HashMap<String, CommAdaptor> getAdaptors() {
        return adaptors;
    }

    public static synchronized void stopSubmittedjobs() {
        for (CommAdaptor adaptor : adaptors.values()) {
            adaptor.stopSubmittedJobs();
        }
    }
}

