/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio;

import es.bsc.comm.CommException;
import es.bsc.comm.Connection;
import es.bsc.comm.MessageHandler;
import es.bsc.comm.nio.NIOException;
import es.bsc.comm.stage.Transfer;
import integratedtoolkit.nio.NIOAgent;
import integratedtoolkit.nio.commands.Command;
import org.apache.log4j.Logger;

public class NIOMessageHandler
implements MessageHandler {
    protected static final Logger LOGGER = Logger.getLogger("integratedtoolkit.Communication");
    private final NIOAgent agent;

    public NIOMessageHandler(NIOAgent agent) {
        this.agent = agent;
    }

    @Override
    public void init() throws CommException {
    }

    @Override
    public void errorHandler(Connection c, Transfer t, CommException ce) {
        LOGGER.debug("Received error type: " + (Object)((Object)((NIOException)ce).getError()));
        String errorText = "NIO Error: " + ce.getMessage() + " processing " + (t == null ? "null" : Integer.valueOf(t.hashCode())) + "\n";
        LOGGER.error(errorText, ce);
        this.agent.receivedRequestedDataNotAvailableError(c, t);
    }

    @Override
    public void dataReceived(Connection c, Transfer t) {
        LOGGER.debug("Received data " + (t.isFile() ? t.getFileName() : t.getObject()) + " through connection " + c.hashCode());
        this.agent.receivedData(c, t);
    }

    @Override
    public void commandReceived(Connection c, Transfer t) {
        try {
            Command cmd = (Command)t.getObject();
            LOGGER.debug("Received Command " + cmd + " through connection " + c.hashCode());
            cmd.agent = this.agent;
            cmd.handle(c);
        }
        catch (Exception e) {
            LOGGER.error("Error receving command. Finishing connection.", e);
            c.finishConnection();
        }
    }

    @Override
    public void writeFinished(Connection c, Transfer t) {
        LOGGER.debug("Finished sending " + (t.isFile() ? t.getFileName() : t.getObject()) + " through connection " + c.hashCode());
        this.agent.releaseSendSlot(c);
    }

    @Override
    public void connectionFinished(Connection c) {
        LOGGER.debug("Connection " + c.hashCode() + " finished");
    }

    @Override
    public void shutdown() {
    }
}

