/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio.master;

import es.bsc.comm.Connection;
import es.bsc.comm.nio.NIONode;
import integratedtoolkit.nio.NIOTracer;
import integratedtoolkit.nio.commands.CommandCheckWorker;
import integratedtoolkit.nio.master.NIOAdaptor;
import integratedtoolkit.nio.master.NIOWorkerNode;
import integratedtoolkit.nio.master.handlers.Ender;
import integratedtoolkit.nio.master.handlers.ProcessOut;
import integratedtoolkit.types.AdaptorDescription;
import integratedtoolkit.util.ErrorManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class WorkerStarter {
    protected static final boolean tracing = System.getProperty("it.tracing") != null && Integer.parseInt(System.getProperty("it.tracing")) > 0;
    protected static final int tracing_level = Integer.parseInt(System.getProperty("it.tracing"));
    private static final String DEPLOYMENT_ID = System.getProperty("it.uuid");
    protected static final Logger logger = Logger.getLogger("integratedtoolkit.Communication");
    protected static final boolean debug = logger.isDebugEnabled();
    private static final int NUM_THREADS = 16;
    private static final long MAX_WAIT_FOR_INIT = 20000L;
    private static final String ERROR_SHUTTING_DOWN_RETRY = "ERROR: Cannot shutdown failed worker PID process";
    private static TreeMap<String, WorkerStarter> addresstoWorkerStarter = new TreeMap();
    private boolean workerIsReady = false;
    private NIOWorkerNode nw;
    private TreeMap<String, AdaptorDescription> adaptorsDesc;

    public WorkerStarter(NIOWorkerNode nw, TreeMap<String, AdaptorDescription> adaptorsDesc) {
        this.nw = nw;
        this.adaptorsDesc = adaptorsDesc;
    }

    public static WorkerStarter getWorkerStarter(String address) {
        return addresstoWorkerStarter.get(address);
    }

    public void setWorkerIsReady() {
        this.workerIsReady = true;
    }

    public NIONode startWorker() throws Exception {
        String name = this.nw.getName();
        AdaptorDescription ad = this.adaptorsDesc.get("integratedtoolkit.nio.master.NIOAdaptor");
        if (ad == null) {
            ErrorManager.warn("Error getting the NIOAdaptor description for worker " + name);
            return null;
        }
        int minPort = this.adaptorsDesc.get("integratedtoolkit.nio.master.NIOAdaptor").getPortRange()[0];
        int maxPort = this.adaptorsDesc.get("integratedtoolkit.nio.master.NIOAdaptor").getPortRange()[1];
        String user = this.nw.getUser();
        NIONode n = null;
        int pid = -1;
        for (int port = minPort; port <= maxPort; ++port) {
            String[] command;
            ProcessOut po;
            if (pid != -1 && (po = WorkerStarter.executeCommand(user, name, command = WorkerStarter.getStopCommand(pid))).getExitValue() != 0) {
                logger.error(ERROR_SHUTTING_DOWN_RETRY);
            }
            if ((po = WorkerStarter.executeCommand(user, name, command = WorkerStarter.getStartCommand(this.nw, port))).getExitValue() == 0) {
                String output = po.getOutput();
                String[] lines = output.split("\n");
                pid = Integer.parseInt(lines[lines.length - 1]);
                long delay = 30L;
                n = new NIONode(name, port);
                String nodeName = this.nw.getName();
                addresstoWorkerStarter.put(nodeName, this);
                logger.debug("Worker process started. Checking connectivity...");
                CommandCheckWorker cmd = new CommandCheckWorker(DEPLOYMENT_ID, nodeName);
                for (long totalWait = 0L; !this.workerIsReady && totalWait < 20000L; totalWait += delay) {
                    Thread.sleep(delay);
                    if (debug) {
                        logger.debug("Sending check command to worker " + nodeName);
                    }
                    Connection c = NIOAdaptor.tm.startConnection(n);
                    c.sendCommand(cmd);
                    c.receive();
                    c.finishConnection();
                    delay = delay < 1900L ? delay * 2L : 2000L;
                }
            } else {
                throw new Exception("[START_CMD_ERROR]: Could not start the NIO worker in resource " + name + " through user " + user + ".\n" + "OUTPUT:" + po.getOutput() + "\n" + "ERROR:" + po.getError() + "\n");
            }
            if (!this.workerIsReady) {
                continue;
            }
            Runtime.getRuntime().addShutdownHook(new Ender(this.nw, pid));
            return n;
        }
        if (!this.workerIsReady) {
            throw new Exception("[TIMEOUT]: Could not start the NIO worker on resource " + name + " through user " + user + ".");
        }
        return n;
    }

    public static void ender(NIOWorkerNode node, int pid) {
        String user = node.getUser();
        String wD = node.getWorkingDir();
        String[] command = WorkerStarter.getStopCommand(pid);
        WorkerStarter.executeCommand(user, node.getName(), command);
        command = WorkerStarter.getCleanCommand(wD);
        WorkerStarter.executeCommand(user, node.getName(), command);
    }

    private static String[] getStartCommand(NIOWorkerNode node, int workerPort) {
        String libPath = node.getLibPath();
        String appDir = node.getAppDir();
        String workingDir = node.getWorkingDir();
        String cp = System.getProperty("it.worker.cp") != null && System.getProperty("it.worker.cp").compareTo("") != 0 ? System.getProperty("it.worker.cp") : "\"\"";
        String installDir = node.getInstallDir();
        String workerDebug = Boolean.toString(Logger.getLogger("integratedtoolkit.Worker").isDebugEnabled());
        String[] cmd = new String[16];
        cmd[0] = installDir + (installDir.endsWith(File.separator) ? "" : File.separator) + "adaptors/nio/persistent_worker.sh";
        cmd[1] = libPath.isEmpty() ? "null" : libPath;
        cmd[2] = appDir.isEmpty() ? "null" : appDir;
        cmd[3] = cp.isEmpty() ? "null" : cp;
        cmd[4] = workerDebug;
        cmd[5] = workingDir;
        cmd[6] = node.getLimitOfTasks() != 0 ? String.valueOf(node.getLimitOfTasks()) : String.valueOf(16);
        cmd[7] = String.valueOf(5);
        cmd[8] = String.valueOf(5);
        cmd[9] = node.getName();
        cmd[10] = String.valueOf(workerPort);
        cmd[11] = String.valueOf(NIOAdaptor.MASTER_PORT);
        cmd[12] = String.valueOf(tracing_level);
        if (tracing) {
            Integer hostId = NIOTracer.registerHost(node.getName(), 16);
            cmd[13] = String.valueOf(hostId.toString());
        } else {
            cmd[13] = "NoTracinghostID";
        }
        cmd[14] = node.getInstallDir();
        cmd[15] = DEPLOYMENT_ID;
        return cmd;
    }

    private static String[] getStopCommand(int pid) {
        String[] cmd = new String[]{"kill", "-9", String.valueOf(pid)};
        return cmd;
    }

    private static String[] getCleanCommand(String wDir) {
        wDir = (wDir = wDir.substring(0, wDir.indexOf(DEPLOYMENT_ID) + DEPLOYMENT_ID.length())).endsWith(File.separator) ? wDir : wDir + File.separator;
        String[] cmd = new String[]{"rm", "-rf", wDir};
        return cmd;
    }

    protected static ProcessOut executeCommand(String user, String resource, String[] command) {
        ProcessOut processOut = new ProcessOut();
        String[] cmd = new String[5 + command.length];
        cmd[0] = "ssh";
        cmd[1] = "-o StrictHostKeyChecking=no";
        cmd[2] = "-o BatchMode=yes";
        cmd[3] = "-o ChallengeResponseAuthentication=no";
        cmd[4] = (user == null ? "" : user + "@") + resource;
        System.arraycopy(command, 0, cmd, 5, command.length);
        StringBuilder sb = new StringBuilder("");
        for (String param : cmd) {
            sb.append(param).append(" ");
        }
        logger.debug("COMM CMD: " + sb.toString());
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.environment().remove("LD_PRELOAD");
            pb.command(cmd);
            Process process = pb.start();
            InputStream stderr = process.getErrorStream();
            InputStream stdout = process.getInputStream();
            process.getOutputStream().close();
            process.waitFor();
            processOut.setExitValue(process.exitValue());
            BufferedReader reader = new BufferedReader(new InputStreamReader(stdout));
            while ((line = reader.readLine()) != null) {
                processOut.appendOutput(line);
                logger.debug("COMM CMD OUT: " + line);
            }
            reader = new BufferedReader(new InputStreamReader(stderr));
            while ((line = reader.readLine()) != null) {
                processOut.appendError(line);
                logger.debug("COMM CMD ERR: " + line);
            }
        }
        catch (Exception e) {
            logger.error("Exception initializing worker ", e);
        }
        return processOut;
    }
}

