/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.key;

import cryptix.util.core.ArrayUtil;
import java.security.Key;

public class RawKey
implements Key {
    private static final String FORMAT = "RAW";
    private String algorithm;
    private byte[] data;

    public RawKey(String algorithm, byte[] data) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm == null");
        }
        this.algorithm = algorithm;
        this.data = (byte[])data.clone();
    }

    public RawKey(String algorithm, byte[] data, int offset, int length) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm == null");
        }
        this.algorithm = algorithm;
        this.data = new byte[length];
        System.arraycopy(data, offset, this.data, 0, length);
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        while (i < this.data.length) {
            h ^= this.data[i];
            i += 4;
        }
        h <<= 8;
        int i2 = 1;
        while (i2 < this.data.length) {
            h ^= this.data[i2];
            i2 += 4;
        }
        h <<= 8;
        int i3 = 2;
        while (i3 < this.data.length) {
            h ^= this.data[i3];
            i3 += 4;
        }
        h <<= 8;
        int i4 = 3;
        while (i4 < this.data.length) {
            h ^= this.data[i4];
            i4 += 4;
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof RawKey) {
            return ArrayUtil.areEqual(this.data, ((RawKey)obj).data);
        }
        return false;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return FORMAT;
    }

    public byte[] getEncoded() {
        return (byte[])this.data.clone();
    }
}

