/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.engine.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.gridlab.gat.CommandNotFoundException;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.engine.util.OutputForwarder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandRunner {
    protected static Logger logger = LoggerFactory.getLogger(CommandRunner.class);
    private int exitCode;
    private OutputForwarder out;
    private OutputForwarder err;
    private static final String[] path;

    public CommandRunner(String ... command) throws GATInvocationException {
        this.exitCode = this.runCommand(command, null);
    }

    public CommandRunner(List<String> command) throws GATInvocationException {
        this.exitCode = this.runCommand(command.toArray(new String[command.size()]), null);
    }

    public CommandRunner(List<String> command, String workingDir) throws GATInvocationException {
        this.exitCode = this.runCommand(command.toArray(new String[command.size()]), workingDir);
    }

    public String getStdout() {
        return this.out.getResult().toString();
    }

    public String getStderr() {
        return this.err.getResult().toString();
    }

    public int getExitCode() {
        return this.exitCode;
    }

    private String getExeFile(String exe) {
        if (path != null) {
            for (String s : path) {
                if (!"".equals(s)) {
                    String e = s + File.separator + exe;
                    File f = new File(e);
                    if (!f.exists()) continue;
                    return e;
                }
                File f = new File(exe);
                if (!f.exists()) continue;
                return exe;
            }
        }
        return exe;
    }

    private int runCommand(String[] command, String dir) throws GATInvocationException {
        if (command.length == 0) {
            throw new ArrayIndexOutOfBoundsException("runCommand: command array has length 0");
        }
        command[0] = this.getExeFile(command[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("CommandRunner running: " + Arrays.toString(command));
        }
        ProcessBuilder builder = new ProcessBuilder(command);
        if (dir != null) {
            builder.directory(new File(dir));
        }
        Process p = null;
        try {
            p = builder.start();
        }
        catch (IOException e) {
            throw new CommandNotFoundException("CommandRunner", (Throwable)e);
        }
        try {
            p.getOutputStream().close();
        }
        catch (Throwable e) {
            // empty catch block
        }
        this.out = new OutputForwarder(p.getInputStream(), true);
        this.err = new OutputForwarder(p.getErrorStream(), true);
        try {
            int exitValue = p.waitFor();
            this.out.waitUntilFinished();
            this.err.waitUntilFinished();
            if (logger.isDebugEnabled()) {
                logger.debug("CommandRunner out: " + this.out.getResult() + "\n" + "CommandRunner err: " + this.err.getResult());
            }
            return exitValue;
        }
        catch (InterruptedException e) {
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> outputAsLines() throws IOException {
        BufferedReader br = null;
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line;
            br = this.getExitCode() == 0 ? new BufferedReader(new StringReader(this.getStdout())) : new BufferedReader(new StringReader(this.getStderr()));
            while ((line = br.readLine()) != null) {
                result.add(line);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        if (logger.isDebugEnabled()) {
            for (String s : result) {
                logger.debug("Line: " + s);
            }
        }
        return result;
    }

    static {
        String PATH = System.getenv("PATH");
        if (PATH != null) {
            StringTokenizer s = new StringTokenizer(PATH, File.pathSeparator);
            int n = s.countTokens();
            path = new String[n];
            for (int i = 0; i < n; ++i) {
                CommandRunner.path[i] = s.nextToken();
            }
        } else {
            path = null;
        }
    }
}

