/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.api.IntegratedToolkit;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;

public final class ErrorManager {
    public static final String NEWLINE = "\r\n";
    private static final String REGEX_NEWLINE = "\r\n|\n|\r";
    private static final String PREFIX_ERRMGR = "[ERRMGR]  -  ";
    private static final String PREFIX_WARNING = "[ERRMGR]  -  WARNING: ";
    private static final String PREFIX_ERROR = "[ERRMGR]  -  ERROR:   ";
    private static final String PREFIX_FATAL = "[ERRMGR]  -  FATAL:   ";
    private static final String SUFFIX_SHUTTING_DOWN = "[ERRMGR]  -  Shutting down COMPSs...";
    private static final Integer REQUEST_ERROR = 1;
    private static final Integer REQUEST_FATAL = 2;
    private static Logger logger = null;
    private static IntegratedToolkit it = null;
    private static Integer errorRequest = -1;
    private static boolean stopping = false;
    private static Runnable errorRunnable = new Runnable(){

        @Override
        public void run() {
            if (errorRequest == REQUEST_ERROR || errorRequest == REQUEST_FATAL) {
                if (it != null) {
                    it.stopIT(true);
                }
                System.exit(1);
            }
        }
    };

    public static void init(IntegratedToolkit it) {
        ErrorManager.it = it;
        logger = Logger.getLogger("integratedtoolkit.Components.ErrorManager");
    }

    public static void warn(String msg, Exception e) {
        if (!stopping) {
            ErrorManager.prettyPrint(PREFIX_WARNING, msg, e, System.out);
        }
        if (logger != null) {
            for (String line : msg.split(REGEX_NEWLINE)) {
                logger.warn(line);
            }
        }
    }

    public static void warn(Exception e) {
        ErrorManager.warn("", e);
    }

    public static void warn(String msg) {
        ErrorManager.warn(msg, null);
    }

    public static synchronized void error(String msg, Exception e) {
        if (!stopping) {
            ErrorManager.prettyPrint(PREFIX_ERROR, msg, e, System.err);
            ErrorManager.prettyPrint("", SUFFIX_SHUTTING_DOWN, null, System.err);
            stopping = true;
            errorRequest = REQUEST_ERROR;
            new Thread(errorRunnable, "ErrorManager Error Thread").start();
        }
        if (logger != null) {
            for (String line : msg.split(REGEX_NEWLINE)) {
                logger.error(line);
            }
        }
    }

    public static void error(Exception e) {
        ErrorManager.error("", e);
    }

    public static void error(String msg) {
        ErrorManager.error(msg, null);
    }

    public static synchronized void fatal(String msg, Exception e) {
        if (!stopping) {
            ErrorManager.prettyPrint(PREFIX_FATAL, msg, e, System.err);
            ErrorManager.prettyPrint("", SUFFIX_SHUTTING_DOWN, null, System.err);
            stopping = true;
            errorRequest = REQUEST_FATAL;
            new Thread(errorRunnable, "ErrorManager Fatal Thread").start();
        }
        if (logger != null) {
            for (String line : msg.split(REGEX_NEWLINE)) {
                logger.fatal(line);
            }
        }
    }

    public static void fatal(Exception e) {
        ErrorManager.fatal("", e);
    }

    public static void fatal(String msg) {
        ErrorManager.fatal(msg, null);
    }

    private static void prettyPrint(String prefix, String _msg, Exception e, PrintStream ps) {
        String msg = _msg;
        if (e != null) {
            msg = msg + NEWLINE;
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            msg = msg + "Stack trace:\r\n" + sw.toString();
        }
        String[] lines = msg.split(REGEX_NEWLINE);
        for (int i = 0; i < lines.length; ++i) {
            String l = lines[i];
            l = i == 0 ? prefix + l : ErrorManager.indent(l, prefix.length());
            ps.println(l);
        }
    }

    private static String indent(String str, int indentation) {
        for (int j = 0; j < indentation; ++j) {
            str = " " + str;
        }
        return str;
    }

    private ErrorManager() {
    }
}

