/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.generic;

import java.util.ArrayList;
import java.util.List;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.cpi.LogicalFileCpi;

public class GenericLogicalFileAdaptor
extends LogicalFileCpi {
    public static String getDescription() {
        return "The Generic LogicalFile Adaptor implements the LogicalFile object in memory, and is advertisable";
    }

    public GenericLogicalFileAdaptor(GATContext gatContext, String name, Integer mode) throws Exception {
        super(gatContext, name, mode);
    }

    public URI getClosestURI(URI location) throws GATInvocationException {
        return this.getClosestURI(location, this.files);
    }

    private URI getClosestURI(URI location, List<URI> otherLocations) throws GATInvocationException {
        if (otherLocations == null || otherLocations.size() == 0) {
            throw new GATInvocationException("No files in logical file '" + this.name + "' to compare with");
        }
        for (URI file : otherLocations) {
            if (file.getHost() == null || !file.getHost().equalsIgnoreCase(location.getHost())) continue;
            return file;
        }
        String locationPart = location.getHost();
        if (locationPart != null) {
            while (locationPart.contains(".")) {
                int position = locationPart.indexOf(".");
                for (URI file : otherLocations) {
                    if (file.getHost() == null || !file.getHost().endsWith(locationPart.substring(position))) continue;
                    return file;
                }
                locationPart = locationPart.substring(position + 1);
            }
            int separatorPosition = location.getHost().indexOf(".");
            if (separatorPosition > 0) {
                for (URI file : otherLocations) {
                    if (file.getHost() == null || !file.getHost().endsWith(location.getHost().substring(separatorPosition))) continue;
                    return file;
                }
            }
        }
        return otherLocations.get(0);
    }

    public List<URI> getOrderedURIs(URI location) throws GATInvocationException {
        if (this.files == null || this.files.size() == 0) {
            throw new GATInvocationException("No files in logical file '" + this.name + "' to order");
        }
        ArrayList<URI> tmp = new ArrayList<URI>();
        for (URI uri : this.files) {
            tmp.add(uri);
        }
        ArrayList<URI> result = new ArrayList<URI>();
        for (int i = 0; i < this.files.size(); ++i) {
            URI closest = this.getClosestURI(location, tmp);
            tmp.remove(tmp.indexOf(closest));
            result.add(closest);
        }
        return result;
    }
}

