/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.nio;

import es.bsc.comm.CommException;
import es.bsc.comm.Connection;
import es.bsc.comm.EventManager;
import es.bsc.comm.InternalConnection;
import es.bsc.comm.Node;
import es.bsc.comm.nio.NIOEventManager;
import es.bsc.comm.nio.NIOException;
import es.bsc.comm.nio.NIOListener;
import es.bsc.comm.nio.NIONode;
import es.bsc.comm.nio.NIOProperties;
import es.bsc.comm.nio.event.NIOEvent;
import es.bsc.comm.nio.event.NewTransferEvent;
import es.bsc.comm.stage.Reception;
import es.bsc.comm.stage.Shutdown;
import es.bsc.comm.stage.Stage;
import es.bsc.comm.stage.Submission;
import es.bsc.comm.stage.Transfer;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class NIOConnection
implements Connection,
InternalConnection {
    protected static final Logger LOGGER = Logger.getLogger("Communication");
    private static final HashMap<SocketChannel, NIOConnection> OPEN_CHANNELS = new HashMap();
    private static final LinkedList<NIOConnection> pendingEstablishConnections = new LinkedList();
    private SocketChannel sc;
    private boolean established;
    private boolean paused;
    private boolean closedSocket;
    private boolean closedConnection;
    private int conRetries = 0;
    protected Stage currentStage;
    private final LinkedList<Stage> pendingStages;
    private final LinkedList<ByteBuffer> receiveBuffer;
    private final LinkedList<ByteBuffer> sendBuffer;
    private final NIONode node;
    protected EventManager em;

    public NIOConnection(NIOEventManager ntm, SocketChannel sc, NIONode n) {
        this.em = ntm;
        this.node = n;
        this.currentStage = null;
        this.pendingStages = new LinkedList();
        this.receiveBuffer = new LinkedList();
        this.sendBuffer = new LinkedList();
        this.established = false;
        this.closedSocket = false;
        this.closedConnection = false;
        if (sc != null) {
            this.registerChannel(sc);
        }
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void sendCommand(Object cmd) {
        Submission t = new Submission(Transfer.Type.COMMAND, cmd);
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void sendDataFile(String name) {
        Submission t = new Submission(name);
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void sendDataObject(Object o) {
        Submission t = new Submission(Transfer.Type.DATA, o);
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void sendDataArray(byte[] array) {
        Submission t = new Submission(Transfer.Type.DATA, array);
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void receive() {
        Reception t = new Reception();
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void receive(String name) {
        Reception t = new Reception();
        t.setReceptionDefaultFileName(name);
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void receiveDataObject() {
        Reception t = new Reception(Transfer.Destination.OBJECT);
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void receiveDataArray() {
        Reception t = new Reception(Transfer.Destination.ARRAY);
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void receiveDataFile(String name) {
        Reception t = new Reception(Transfer.Destination.FILE);
        t.setReceptionDefaultFileName(name);
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void finishConnection() {
        Shutdown t = new Shutdown();
        this.em.addEvent(new NewTransferEvent(this, t));
    }

    @Override
    public void requestStage(Stage t) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Requesting transfer " + t + " on connection " + this.hashCode());
        }
        this.pendingStages.add(t);
        if (this.currentStage == null) {
            this.handleNextTransfer();
        }
    }

    @Override
    public void established() {
        this.established = true;
        this.handleNextTransfer();
    }

    @Override
    public void receivedPacket(ByteBuffer buffer) {
        this.receiveBuffer.add(buffer);
        if (this.currentStage != null) {
            this.progressCurrentTransfer();
        }
    }

    @Override
    public void lowSendBuffer() {
        if (this.currentStage != null) {
            this.progressCurrentTransfer();
        }
    }

    @Override
    public void emptySendBuffer() {
        if (this.currentStage != null && this.currentStage.isComplete(this.receiveBuffer, this.sendBuffer)) {
            this.currentStage.notifyCompletion(this, this.em);
            this.handleNextTransfer();
        }
    }

    @Override
    public void closedChannel() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Channel on connection " + this.hashCode() + " has been closed");
        }
        this.closedSocket = true;
        if (this.currentStage != null && !this.paused) {
            this.currentStage.notifyError(this, this.em, new NIOException(NIOException.ErrorType.CLOSED_CONNECTION, new Exception("Channel was already closed for connection " + this.hashCode())));
            this.handleNextTransfer();
        }
        if (this.closedConnection) {
            this.unregisterChannel();
            this.em.connectionFinished(this);
        }
    }

    public void closeConnection() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Requesting connection " + this.hashCode() + " closure");
        }
        if (!this.closedSocket) {
            NIOListener.closeSocket(this.sc);
        } else if (!this.closedConnection) {
            this.unregisterChannel();
            this.em.connectionFinished(this);
        }
        this.closedConnection = true;
        this.handleNextTransfer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerChannel(SocketChannel socket) {
        HashMap<SocketChannel, NIOConnection> hashMap = OPEN_CHANNELS;
        synchronized (hashMap) {
            OPEN_CHANNELS.put(socket, this);
        }
        this.sc = socket;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Associating Socket: " + this.sc.hashCode() + " with connection: " + this.hashCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterChannel() {
        HashMap<SocketChannel, NIOConnection> hashMap = OPEN_CHANNELS;
        synchronized (hashMap) {
            OPEN_CHANNELS.remove(this.sc);
        }
        this.sc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceChannel(SocketChannel newSocket) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Re-Associating Socket: " + this.sc.hashCode() + " -> " + newSocket.hashCode() + " with connection: " + this.hashCode());
        }
        HashMap<SocketChannel, NIOConnection> hashMap = OPEN_CHANNELS;
        synchronized (hashMap) {
            OPEN_CHANNELS.remove(this.sc);
            OPEN_CHANNELS.put(newSocket, this);
        }
        this.sc = newSocket;
    }

    private void pause() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Transfer " + this.currentStage + " on connection " + this.hashCode() + " is paused.");
        }
        this.paused = true;
        this.currentStage.pause(this);
    }

    @Override
    public void resume() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resume transfer " + this.currentStage + " on connection " + this.hashCode());
        }
        this.paused = false;
        this.startCurrentTransfer();
    }

    private void handleNextTransfer() {
        if (this.paused || !this.established) {
            return;
        }
        if (!this.pendingStages.isEmpty()) {
            this.currentStage = this.pendingStages.removeFirst();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("NIOConnection " + this.hashCode() + " takes " + this.currentStage);
            }
            if (this.currentStage.isShutdown()) {
                this.closeConnection();
            } else {
                this.startCurrentTransfer();
            }
        } else {
            this.currentStage = null;
        }
    }

    protected void startCurrentTransfer() {
        if (this.paused) {
            return;
        }
        try {
            if (this.currentStage.checkViability(this.closedSocket, this.receiveBuffer, this.sendBuffer)) {
                try {
                    this.currentStage.start(this, this.receiveBuffer, this.sendBuffer);
                    this.progressCurrentTransfer();
                }
                catch (Exception e) {
                    this.currentStage.notifyError(this, this.em, new NIOException(NIOException.ErrorType.CLOSED_CONNECTION, e));
                    this.handleNextTransfer();
                }
            } else {
                this.pause();
            }
        }
        catch (CommException ne) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Connection closed before completing " + this.currentStage);
            }
            this.currentStage.notifyError(this, this.em, new NIOException(NIOException.ErrorType.CLOSED_CONNECTION, new Exception("Channel was already closed for connection " + this.hashCode())));
            this.handleNextTransfer();
        }
    }

    public void progressCurrentTransfer() {
        if (this.paused) {
            return;
        }
        try {
            this.currentStage.progress(this, this.receiveBuffer, this.sendBuffer);
            if (this.currentStage.isComplete(this.receiveBuffer, this.sendBuffer)) {
                this.currentStage.notifyCompletion(this, this.em);
                this.handleNextTransfer();
            } else if (this.closedSocket) {
                if (!this.currentStage.checkViability(this.closedSocket, this.receiveBuffer, this.sendBuffer)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Connection closed before completing " + this.currentStage);
                    }
                    this.currentStage.notifyError(this, this.em, new NIOException(NIOException.ErrorType.CLOSED_CONNECTION, new Exception("Channel was already closed for connection " + this.hashCode())));
                    this.handleNextTransfer();
                }
            } else if (!this.sendBuffer.isEmpty()) {
                NIOListener.changeInterest(this.sc, 4);
            }
        }
        catch (Exception e) {
            this.currentStage.notifyError(this, this.em, new NIOException(NIOException.ErrorType.CLOSED_CONNECTION, e));
            this.handleNextTransfer();
        }
    }

    @Override
    public void error(CommException exception) {
        LOGGER.debug("Processing error on connection " + this.hashCode());
        NIOException ne = (NIOException)exception;
        if (ne.getError() == NIOException.ErrorType.FINISHING_CONNECTION || ne.getError() == NIOException.ErrorType.STARTING_CONNECTION || ne.getError() == NIOException.ErrorType.RESTARTING_CONNECTION) {
            ++this.conRetries;
            if (this.conRetries < NIOProperties.MAX_RETRIES) {
                if (ne.getCause() instanceof SocketTimeoutException) {
                    this.reestablishConnection();
                } else {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Connection " + this.hashCode() + " will try to be reestablish in the future.");
                    }
                    pendingEstablishConnections.add(this);
                }
            } else {
                this.closedSocket = true;
                this.unregisterChannel();
                this.handleNextTransfer();
            }
        } else {
            this.currentStage.notifyError(this, this.em, exception);
            this.handleNextTransfer();
        }
    }

    public static void establishPendingConnections() {
        for (NIOConnection nc : pendingEstablishConnections) {
            nc.reestablishConnection();
        }
        pendingEstablishConnections.clear();
    }

    private void reestablishConnection() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Reestablishing connection " + this.hashCode());
        }
        NIOListener.restartConnection(this, this.node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NIOConnection getConnection(SocketChannel sc) {
        HashMap<SocketChannel, NIOConnection> hashMap = OPEN_CHANNELS;
        synchronized (hashMap) {
            return OPEN_CHANNELS.get(sc);
        }
    }

    public static Collection<SocketChannel> getAllSockets() {
        return OPEN_CHANNELS.keySet();
    }

    public static void abortPendingConnections() {
        for (NIOConnection nc : pendingEstablishConnections) {
            OPEN_CHANNELS.remove(nc.sc);
        }
        pendingEstablishConnections.clear();
    }

    public static boolean areAliveConnections() {
        return !OPEN_CHANNELS.isEmpty();
    }

    public LinkedList<ByteBuffer> getSendBuffer() {
        return this.sendBuffer;
    }

    public Stage getCurrentTransfer() {
        return this.currentStage;
    }

    public boolean isOwnerFor(NIOEvent event) {
        if (event.getConnection() != null) {
            return event.getConnection() == this;
        }
        return event.getSocket() == this.sc;
    }

    public SocketChannel getSocket() {
        return this.sc;
    }
}

