/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.nio.event;

import es.bsc.comm.CommException;
import es.bsc.comm.EventManager;
import es.bsc.comm.event.Event;
import es.bsc.comm.nio.NIOConnection;
import es.bsc.comm.nio.event.NIOEvent;
import java.nio.channels.SocketChannel;

public class ErrorEvent
extends NIOEvent {
    private final CommException exception;

    public ErrorEvent(NIOConnection nc, CommException e) {
        super(null, nc);
        this.exception = e;
    }

    public ErrorEvent(SocketChannel sc, CommException e) {
        super(sc, null);
        this.exception = e;
    }

    public ErrorEvent(CommException e) {
        super(null, null);
        this.exception = e;
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    public Event.EventType getEventType() {
        return Event.EventType.ERROR;
    }

    @Override
    public void processEventOnConnection(EventManager<?> nem) {
        if (this.connection != null) {
            this.connection.error(this.exception);
        } else if (this.sc != null) {
            this.connection = NIOConnection.getConnection(this.sc);
            this.connection.error(this.exception);
        } else {
            nem.notifyError(null, null, this.exception);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        sb.append("Error event");
        if (this.sc != null) {
            sb.append(" on socket@").append(this.sc.hashCode());
        }
        if (this.connection != null) {
            sb.append(" on connection@").append(this.connection.hashCode());
        }
        sb.append(" caused by ").append(this.exception);
        return sb.toString();
    }
}

