/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio.master;

import integratedtoolkit.api.ITExecution;
import integratedtoolkit.nio.NIOParam;
import integratedtoolkit.nio.NIOTask;
import integratedtoolkit.nio.commands.Data;
import integratedtoolkit.nio.master.NIOAdaptor;
import integratedtoolkit.nio.master.NIOWorkerNode;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.MethodImplementation;
import integratedtoolkit.types.TaskParams;
import integratedtoolkit.types.data.DataAccessId;
import integratedtoolkit.types.job.Job;
import integratedtoolkit.types.parameter.BasicTypeParameter;
import integratedtoolkit.types.parameter.DependencyParameter;
import integratedtoolkit.types.parameter.Parameter;
import integratedtoolkit.types.resources.Resource;
import java.util.LinkedList;

public class NIOJob
extends Job<NIOWorkerNode> {
    private static final String workerClasspath = System.getProperty("it.worker.cp") != null && System.getProperty("it.worker.cp").compareTo("") != 0 ? System.getProperty("it.worker.cp") : "\"\"";

    public NIOJob(int taskId, TaskParams taskParams, Implementation<?> impl, Resource res, Job.JobListener listener) {
        super(taskId, taskParams, impl, res, listener);
    }

    @Override
    public String getHostName() {
        return this.worker.getName();
    }

    @Override
    public String toString() {
        MethodImplementation method = (MethodImplementation)this.impl;
        String className = method.getDeclaringClass();
        String methodName = this.taskParams.getName();
        return "NIOJob JobId" + this.jobId + " for method " + methodName + " at class " + className;
    }

    @Override
    public void submit() throws Exception {
        logger.info("Submit NIOJob with ID " + this.jobId);
        NIOAdaptor.submitTask(this);
    }

    public NIOTask prepareJob() {
        MethodImplementation method = (MethodImplementation)this.impl;
        String className = method.getDeclaringClass();
        String methodName = this.taskParams.getName();
        boolean hasTarget = this.taskParams.hasTargetObject();
        LinkedList<NIOParam> params = this.addParams();
        int numParams = params.size();
        if (this.taskParams.hasReturnValue()) {
            --numParams;
        }
        NIOTask nt = new NIOTask(lang, ((NIOWorkerNode)this.getResourceNode()).getInstallDir(), ((NIOWorkerNode)this.getResourceNode()).getLibPath(), ((NIOWorkerNode)this.getResourceNode()).getAppDir(), workerClasspath, workerDebug, className, methodName, hasTarget, params, numParams, this.taskId, this.taskParams.getId(), this.jobId, this.history, this.transferId);
        return nt;
    }

    private LinkedList<NIOParam> addParams() {
        LinkedList<NIOParam> params = new LinkedList<NIOParam>();
        for (Parameter param : this.taskParams.getParameters()) {
            NIOParam np;
            ITExecution.ParamType type = param.getType();
            if (type == ITExecution.ParamType.FILE_T || type == ITExecution.ParamType.OBJECT_T) {
                DependencyParameter dPar = (DependencyParameter)param;
                DataAccessId dAccId = dPar.getDataAccessId();
                String value = dPar.getDataTarget();
                boolean preserveSourceData = true;
                preserveSourceData = dAccId instanceof DataAccessId.RAccessId ? ((DataAccessId.RAccessId)dAccId).isPreserveSourceData() : (dAccId instanceof DataAccessId.RWAccessId ? ((DataAccessId.RWAccessId)dAccId).isPreserveSourceData() : false);
                boolean writeFinalValue = !(dAccId instanceof DataAccessId.RAccessId);
                np = new NIOParam(type, preserveSourceData, writeFinalValue, value, (Data)dPar.getDataSource());
            } else {
                BasicTypeParameter btParB = (BasicTypeParameter)param;
                Object value = btParB.getValue();
                boolean preserveSourceData = false;
                boolean writeFinalValue = false;
                np = new NIOParam(type, preserveSourceData, writeFinalValue, value, null);
            }
            params.add(np);
        }
        return params;
    }

    @Override
    public Job.JobKind getKind() {
        return Job.JobKind.METHOD;
    }

    public void taskFinished(boolean successful) {
        if (successful) {
            this.listener.jobCompleted(this);
        } else {
            this.listener.jobFailed(this, Job.JobListener.JobEndStatus.EXECUTION_FAILED);
        }
    }

    @Override
    public void stop() throws Exception {
    }
}

