/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio.master;

import es.bsc.comm.Connection;
import es.bsc.comm.nio.NIONode;
import integratedtoolkit.api.ITExecution;
import integratedtoolkit.comm.Comm;
import integratedtoolkit.nio.NIOAgent;
import integratedtoolkit.nio.NIOTracer;
import integratedtoolkit.nio.NIOURI;
import integratedtoolkit.nio.commands.CommandShutdown;
import integratedtoolkit.nio.commands.Data;
import integratedtoolkit.nio.commands.tracing.CommandGeneratePackage;
import integratedtoolkit.nio.commands.workerFiles.CommandGenerateWorkerDebugFiles;
import integratedtoolkit.nio.master.NIOAdaptor;
import integratedtoolkit.nio.master.NIOJob;
import integratedtoolkit.types.COMPSsWorker;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.TaskParams;
import integratedtoolkit.types.data.LogicalData;
import integratedtoolkit.types.data.Transferable;
import integratedtoolkit.types.data.location.DataLocation;
import integratedtoolkit.types.data.location.URI;
import integratedtoolkit.types.data.operation.Copy;
import integratedtoolkit.types.data.operation.DataOperation;
import integratedtoolkit.types.job.Job;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.types.resources.ShutdownListener;
import java.io.File;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class NIOWorkerNode
extends COMPSsWorker {
    protected static final Logger logger = Logger.getLogger("integratedtoolkit.Communication");
    private static final int MAX_RETRIES = 5;
    private String user;
    private String host;
    private String installDir;
    private String baseWorkingDir;
    private String workingDir;
    private String appDir;
    private String libPath;
    private String queue;
    private int limitOfTasks;
    private NIONode node;
    private NIOAdaptor commManager;

    @Override
    public String getName() {
        return this.host;
    }

    public NIOWorkerNode(String name, HashMap<String, String> properties, NIOAdaptor adaptor) {
        super(name, properties);
        String value;
        this.user = properties.get("User");
        this.host = name;
        this.installDir = properties.get("InstallDir");
        if (this.installDir == null) {
            this.installDir = "";
        } else if (!this.installDir.endsWith(File.separator)) {
            this.installDir = this.installDir + File.separator;
        }
        this.baseWorkingDir = properties.get("WorkingDir");
        if (this.baseWorkingDir == null) {
            this.baseWorkingDir = File.separator + "tmp" + File.separator;
        } else if (!this.baseWorkingDir.endsWith(File.separator)) {
            this.baseWorkingDir = this.baseWorkingDir + File.separator;
        }
        this.workingDir = this.baseWorkingDir + NIOAdaptor.DEPLOYMENT_ID + File.separator + this.host + File.separator;
        this.appDir = properties.get("AppDir");
        if (this.appDir == null) {
            this.appDir = "";
        }
        this.libPath = properties.get("LibraryPath");
        if (this.libPath == null) {
            this.libPath = "";
        }
        this.queue = properties.get("queue");
        if (this.queue == null) {
            this.queue = "";
        }
        if ((value = properties.get("LimitOfTasks")) != null) {
            this.limitOfTasks = Integer.parseInt(value);
        }
        this.commManager = adaptor;
        if (tracing) {
            logger.debug("Initializing NIO tracer " + this.getName());
            NIOTracer.startTracing(this.getName(), this.getUser(), this.getHost(), this.getLimitOfTasks());
        }
    }

    @Override
    public String getUser() {
        return this.user;
    }

    public String getHost() {
        return this.host;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public String getBaseWorkingDir() {
        return this.baseWorkingDir;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String getAppDir() {
        return this.appDir;
    }

    public String getLibPath() {
        return this.libPath;
    }

    public String getQueue() {
        return this.queue;
    }

    public int getLimitOfTasks() {
        return this.limitOfTasks;
    }

    public void setNode(NIONode node) {
        this.node = node;
    }

    public NIONode getNode() {
        return this.node;
    }

    @Override
    public void setInternalURI(URI uri) {
        NIOURI nio = new NIOURI(this.node, uri.getPath());
        uri.setInternalURI(NIOAdaptor.ID, nio);
    }

    @Override
    public Job<?> newJob(int taskId, TaskParams taskParams, Implementation<?> impl, Resource res, Job.JobListener listener) {
        return new NIOJob(taskId, taskParams, impl, res, listener);
    }

    @Override
    public void stop(ShutdownListener sl) {
        logger.info("Shutting down " + this.node);
        for (int retries = 0; retries < 5; ++retries) {
            if (this.tryShutdown(sl)) {
                return;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        sl.notifyFailure(new Exception());
        logger.error("Shutdown has failed");
    }

    private boolean tryShutdown(ShutdownListener sl) {
        Connection c = NIOAgent.tm.startConnection(this.node);
        this.commManager.shuttingDown(this, c, sl);
        CommandShutdown cmd = new CommandShutdown(null, null);
        c.sendCommand(cmd);
        c.receive();
        c.finishConnection();
        return true;
    }

    @Override
    public void sendData(LogicalData ld, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, DataOperation.EventListener listener) {
        if (target.getHosts().contains(Comm.appHost)) {
            URI u;
            if (debug) {
                logger.debug("Sending to master");
            }
            if (tgtData != null && (u = ld.alreadyAvailable(Comm.appHost)) != null) {
                if (debug) {
                    logger.debug(" Setting target data " + u.getPath());
                }
                reason.setDataTarget(u.getPath());
                listener.notifyEnd(null);
                return;
            }
            Copy.DeferredCopy c = new Copy.DeferredCopy(ld, null, target, tgtData, reason, listener);
            Data d = new Data(ld);
            if (source != null) {
                for (URI uri : source.getURIs()) {
                    NIOURI nURI = (NIOURI)uri.getInternalURI(NIOAdaptor.ID);
                    if (nURI == null) continue;
                    d.getSources().add(nURI);
                }
            }
            String path = target.getURIInHost(Comm.appHost).getPath();
            ld.startCopy(c, c.getTargetLoc());
            if (debug) {
                logger.debug("Requesting data to target in master " + path);
            }
            NIOAgent.DataRequest.MasterDataRequest dr = new NIOAgent.DataRequest.MasterDataRequest(c, reason.getType(), d, path);
            this.commManager.addTransferRequest(dr);
            this.commManager.requestTransfers();
        } else {
            this.orderCopy(new Copy.DeferredCopy(ld, source, target, tgtData, reason, listener));
        }
    }

    @Override
    public void obtainData(LogicalData ld, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, DataOperation.EventListener listener) {
        this.orderCopy(new Copy.DeferredCopy(ld, source, target, tgtData, reason, listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void orderCopy(Copy.DeferredCopy c) {
        String path;
        LogicalData ld;
        Resource tgtRes = c.getTargetLoc().getHosts().getFirst();
        LogicalData logicalData = ld = c.getSourceData();
        synchronized (logicalData) {
            URI u;
            if (c.getTargetData() != null && (u = ld.alreadyAvailable(tgtRes)) != null) {
                if (debug) {
                    logger.debug(" Setting path from uri " + u.getPath());
                }
                path = u.getPath();
            } else {
                path = c.getTargetLoc().getURIInHost(tgtRes).getPath();
                if (debug) {
                    logger.debug(" Setting path from target location " + path);
                }
            }
            ld.startCopy(c, c.getTargetLoc());
            this.commManager.registerCopy(c);
        }
        c.setProposedSource(new Data(ld));
        c.setFinalTarget(path);
        c.end(DataOperation.OpEndState.OP_OK);
    }

    @Override
    public void updateTaskCount(int processorCoreCount) {
    }

    @Override
    public void announceDestruction() {
    }

    @Override
    public void announceCreation() {
    }

    @Override
    public String getCompletePath(ITExecution.ParamType type, String name) {
        switch (type) {
            case FILE_T: {
                return this.workingDir + name;
            }
            case OBJECT_T: {
                return name;
            }
        }
        return null;
    }

    @Override
    public void deleteTemporary() {
    }

    @Override
    public void generatePackage() {
        logger.debug("Sending command to generated tracing package for " + this.getHost());
        for (int retries = 0; retries < 5; ++retries) {
            if (this.tryGeneratePackage()) {
                this.commManager.waitUntilTracingPackageGenerated();
                logger.debug("Tracing Package generated");
                return;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        logger.error("Package generation has failed.");
    }

    private boolean tryGeneratePackage() {
        Connection c = NIOAgent.tm.startConnection(this.node);
        CommandGeneratePackage cmd = new CommandGeneratePackage(this.getHost(), this.getInstallDir(), this.getWorkingDir(), this.getName());
        c.sendCommand(cmd);
        c.receive();
        c.finishConnection();
        return true;
    }

    @Override
    public void generateWorkersDebugInfo() {
        logger.debug("Sending command to generate worker debug files for " + this.getHost());
        for (int retries = 0; retries < 5; ++retries) {
            if (this.tryGenerateDebugFiles()) {
                this.commManager.waitUntilWorkersDebugInfoGenerated();
                logger.debug("Worker debug files generated");
                return;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        logger.error("Worker debug files generation has failed.");
    }

    private boolean tryGenerateDebugFiles() {
        Connection c = NIOAgent.tm.startConnection(this.node);
        CommandGenerateWorkerDebugFiles cmd = new CommandGenerateWorkerDebugFiles(this.getHost(), this.getInstallDir(), this.getWorkingDir(), this.getName());
        c.sendCommand(cmd);
        c.receive();
        c.finishConnection();
        return true;
    }
}

