/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.connectors.amazon;

import integratedtoolkit.connectors.VM;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;

public class AmazonVM
extends VM {
    private int placement;
    private VMType type;
    private static final int PLACEMENT_US_EAST = 0;
    private static final int PLACEMENT_US_CAL = 1;
    private static final int PLACEMENT_US_OREGON = 2;
    private static final int PLACEMENT_EUROPE = 3;
    private static final int PLACEMENT_PACIFIC_SINGAPUR = 4;
    private static final int PLACEMENT_PACIFIC_TOKIO = 5;
    private static final int PLACEMENT_SAOPAULO = 6;
    private static final VMType micro = new Micro();
    private static final VMType small = new Small();
    private static final VMType medium = new Medium();
    private static final VMType large = new Large();
    private static final VMType xlarge = new XLarge();

    public AmazonVM(String envId, CloudMethodResourceDescription rd, String type, int placement) {
        super((Object)envId, rd);
        this.placement = placement;
        if (type.equals(micro.getCode())) {
            this.type = micro;
        } else if (type.equals(small.getCode())) {
            this.type = small;
        } else if (type.equals(medium.getCode())) {
            this.type = medium;
        } else if (type.equals(large.getCode())) {
            this.type = large;
        } else if (type.equals(xlarge.getCode())) {
            this.type = xlarge;
        }
    }

    public int getPlacement() {
        return this.placement;
    }

    public VMType getType() {
        return this.type;
    }

    public float getPrice() {
        return this.type.getPrice(this.placement);
    }

    public boolean isCompatible(String code, String arch) {
        String thisCode = this.type.getCode();
        if (arch != null && arch.equals("i386")) {
            if (code.equals("t1.micro")) {
                return thisCode.equals("m1.micro") || thisCode.equals("m1.small") || thisCode.equals("m1.medium");
            }
            if (code.equals("m1.small")) {
                return thisCode.equals("m1.small") || thisCode.equals("m1.medium");
            }
            if (code.equals("m1.medium")) {
                return thisCode.equals("m1.medium");
            }
        } else {
            if (code.equals("t1.micro")) {
                return thisCode.equals("m1.micro") || thisCode.equals("m1.small") || thisCode.equals("m1.medium") || thisCode.equals("m1.large") || thisCode.equals("m1.xlarge");
            }
            if (code.equals("m1.small")) {
                return thisCode.equals("m1.small") || thisCode.equals("m1.medium") || thisCode.equals("m1.large") || thisCode.equals("m1.xlarge");
            }
            if (code.equals("m1.medium")) {
                return thisCode.equals("m1.medium") || thisCode.equals("m1.large") || thisCode.equals("m1.xlarge");
            }
            if (code.equals("m1.large")) {
                return thisCode.equals("m1.large") || thisCode.equals("m1.xlarge");
            }
            if (code.equals("m1.xlarge")) {
                return thisCode.equals("m1.xlarge");
            }
        }
        return false;
    }

    public static float getPrice(String type, int placement) {
        if (type.equals(micro.getCode())) {
            return micro.getPrice(placement);
        }
        if (type.equals(small.getCode())) {
            return small.getPrice(placement);
        }
        if (type.equals(medium.getCode())) {
            return medium.getPrice(placement);
        }
        if (type.equals(large.getCode())) {
            return large.getPrice(placement);
        }
        if (type.equals(xlarge.getCode())) {
            return xlarge.getPrice(placement);
        }
        return 0.0f;
    }

    public static int translatePlacement(String placeCode) {
        if (placeCode.substring(0, 2).compareTo("ap") == 0) {
            if (placeCode.substring(3, 12).compareTo("northeast") == 0) {
                return 5;
            }
            return 4;
        }
        if (placeCode.substring(0, 2).compareTo("eu") == 0) {
            return 3;
        }
        if (placeCode.substring(0, 2).compareTo("sa") == 0) {
            return 6;
        }
        if (placeCode.substring(3, 7).compareTo("east") == 0) {
            return 0;
        }
        if (placeCode.substring(8, 8).compareTo("1") == 0) {
            return 1;
        }
        return 2;
    }

    public static String classifyMachine(int cpu, float memory, float disk, String imageArchitecture) {
        if (imageArchitecture == null || imageArchitecture == "[unassigned]" || imageArchitecture.compareTo("x64") == 0) {
            if (AmazonVM.checkVM(cpu, memory, disk, micro)) {
                return micro.getCode();
            }
            if (AmazonVM.checkVM(cpu, memory, disk, small)) {
                return small.getCode();
            }
            if (AmazonVM.checkVM(cpu, memory, disk, medium)) {
                return medium.getCode();
            }
            if (AmazonVM.checkVM(cpu, memory, disk, large)) {
                return large.getCode();
            }
            if (AmazonVM.checkVM(cpu, memory, disk, xlarge)) {
                return xlarge.getCode();
            }
        } else {
            if (AmazonVM.checkVM(cpu, memory, disk, micro)) {
                return micro.getCode();
            }
            if (AmazonVM.checkVM(cpu, memory, disk, small)) {
                return small.getCode();
            }
            if (AmazonVM.checkVM(cpu, memory, disk, medium)) {
                return medium.getCode();
            }
        }
        return null;
    }

    private static boolean checkVM(int cpu, float memory, float disk, VMType vm) {
        return cpu <= vm.getCpucount() && memory <= vm.getMemory() && disk <= vm.getDisk();
    }

    public int compareTo(AmazonVM vm) throws NullPointerException {
        if (vm == null) {
            throw new NullPointerException();
        }
        if (vm.getName().equals(this.getName())) {
            return 0;
        }
        long now = System.currentTimeMillis();
        int mod1 = (int)(now - this.getStartTime()) % 3600000;
        int mod2 = (int)(now - vm.getStartTime()) % 3600000;
        return mod2 - mod1;
    }

    public String toString() {
        return "VM  (type = " + this.type + ", placement = " + this.placement + super.toString();
    }

    private static class XLarge
    extends VMType {
        public XLarge() {
            this.code = "m1.xlarge";
            this.memory = 15360.0f;
            this.cpuCount = 4;
            this.disk = 1730560.0f;
            this.price = new float[]{0.64f, 0.64f, 0.72f, 0.68f, 0.68f, 0.736f, 0.92f};
        }
    }

    private static class Large
    extends VMType {
        public Large() {
            this.code = "m1.large";
            this.memory = 7680.0f;
            this.cpuCount = 2;
            this.disk = 870400.0f;
            this.price = new float[]{0.32f, 0.32f, 0.36f, 0.34f, 0.34f, 0.368f, 0.46f};
        }
    }

    private static class Medium
    extends VMType {
        public Medium() {
            this.code = "m1.medium";
            this.memory = 3840.0f;
            this.cpuCount = 1;
            this.disk = 419840.0f;
            this.price = new float[]{0.16f, 0.16f, 0.18f, 0.17f, 0.17f, 0.184f, 0.23f};
        }
    }

    private static class Small
    extends VMType {
        public Small() {
            this.code = "m1.small";
            this.memory = 1740.8f;
            this.cpuCount = 1;
            this.disk = 163840.0f;
            this.price = new float[]{0.08f, 0.08f, 0.09f, 0.085f, 0.085f, 0.092f, 0.115f};
        }
    }

    private static class Micro
    extends VMType {
        public Micro() {
            this.code = "t1.micro";
            this.memory = 613.0f;
            this.cpuCount = 1;
            this.disk = 40000.0f;
            this.price = new float[]{0.02f, 0.02f, 0.025f, 0.02f, 0.02f, 0.027f, 0.027f};
        }
    }

    public static abstract class VMType {
        protected String code;
        protected float memory;
        protected int cpuCount;
        protected float disk;
        protected float[] price;

        public String getCode() {
            return this.code;
        }

        public float getMemory() {
            return this.memory;
        }

        public int getCpucount() {
            return this.cpuCount;
        }

        public float getDisk() {
            return this.disk;
        }

        public float getPrice(int placement) {
            return this.price[placement];
        }

        public String toString() {
            return this.code;
        }
    }
}

