/*
 * Decompiled with CFR 0.152.
 */
package examples20;

import java.net.URISyntaxException;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.JavaSoftwareDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.resources.SoftwareDescription;

public class ResourceBrokerJavaJobExample {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("\tUsage: bin/run_gat_app examples20.ResourceBrokerJavaJobExample <brokerURI> (where location is a valid JavaGAT URI)\n");
            System.exit(1);
        }
        new ResourceBrokerJavaJobExample().start(args[0]);
        GAT.end();
    }

    public void start(String brokerURI) {
        ResourceBroker broker = null;
        try {
            broker = GAT.createResourceBroker((URI)new URI(brokerURI));
        }
        catch (GATObjectCreationException e) {
            System.err.println("Failed to create resource broker at location '" + brokerURI + "': " + (Object)((Object)e));
            return;
        }
        catch (URISyntaxException e) {
            System.err.println("Wrong uri '" + brokerURI + "': " + e);
            return;
        }
        JavaSoftwareDescription sd = new JavaSoftwareDescription();
        sd.setExecutable("/usr/bin/java");
        sd.setJavaMain("my.package.HelloWorld");
        sd.setJavaArguments(new String[]{"hello", "world"});
        sd.setJavaClassPath("myJar1:myDir");
        sd.setJavaOptions(new String[]{"-version"});
        sd.addJavaSystemProperty("key", "value");
        try {
            sd.setStdout(GAT.createFile((String)"javajob.txt"));
        }
        catch (GATObjectCreationException e) {
            System.err.println("Failed to create the stdout file 'javajob.txt': " + (Object)((Object)e));
            return;
        }
        JobDescription jd = new JobDescription((SoftwareDescription)sd);
        Job job = null;
        try {
            job = broker.submitJob((AbstractJobDescription)jd);
        }
        catch (GATInvocationException e) {
            System.err.println("Failed to submit the job: " + (Object)((Object)e));
            return;
        }
        while (job.getState() != Job.JobState.STOPPED) {
            System.out.println("job is in state: " + job.getState());
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {}
        }
    }
}

