/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi;

import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Vector;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.advert.Advertisable;
import org.gridlab.gat.engine.GATEngine;
import org.gridlab.gat.engine.util.NoInfoLogging;
import org.gridlab.gat.io.File;
import org.gridlab.gat.io.FileInterface;
import org.gridlab.gat.io.attributes.FileAttributeView;
import org.gridlab.gat.io.cpi.SerializedFile;
import org.gridlab.gat.monitoring.cpi.MonitorableCpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileCpi
extends MonitorableCpi
implements FileInterface,
Serializable {
    protected static Logger logger = LoggerFactory.getLogger(FileCpi.class);
    protected GATContext gatContext;
    protected URI location;
    protected boolean ignoreHiddenFiles = false;

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map<String, Boolean> capabilities = MonitorableCpi.getSupportedCapabilities();
        capabilities.put("getGATContext", true);
        capabilities.put("equals", true);
        capabilities.put("toURI", true);
        capabilities.put("toURL", true);
        capabilities.put("toString", true);
        capabilities.put("recursivelyDeleteDirectory", true);
        capabilities.put("compareTo", true);
        capabilities.put("deleteOneExit", true);
        capabilities.put("getAbsolutePath", false);
        capabilities.put("getCanonicalPath", false);
        capabilities.put("getPath", true);
        capabilities.put("hashcode", true);
        capabilities.put("copy", false);
        capabilities.put("canRead", false);
        capabilities.put("canWrite", false);
        capabilities.put("createNewFile", false);
        capabilities.put("delete", false);
        capabilities.put("exists", false);
        capabilities.put("getAbsoluteFile", false);
        capabilities.put("getCanonicalFile", false);
        capabilities.put("getFileAttributeView", false);
        capabilities.put("getName", true);
        capabilities.put("getParent", true);
        capabilities.put("getParentFile", true);
        capabilities.put("isDirectory", false);
        capabilities.put("isAbsolute", true);
        capabilities.put("isFile", false);
        capabilities.put("isHidden", false);
        capabilities.put("lastModified", false);
        capabilities.put("length", false);
        capabilities.put("list", false);
        capabilities.put("listFiles", true);
        capabilities.put("mkdir", false);
        capabilities.put("mkdirs", true);
        capabilities.put("move", true);
        capabilities.put("renameTo", false);
        capabilities.put("setLastModified", false);
        capabilities.put("setReadOnly", false);
        return capabilities;
    }

    public static Preferences getSupportedPreferences() {
        Preferences preferences = MonitorableCpi.getSupportedPreferences();
        preferences.put("file.adaptor.name", (Object)"<no default>");
        preferences.put("adaptors.local", (Object)"false");
        preferences.put("file.create", (Object)"false");
        preferences.put("file.hiddenfiles.ignore", (Object)"false");
        preferences.put("file.directory.copy", (Object)"<no default>");
        return preferences;
    }

    protected FileCpi(GATContext gatContext, URI location) {
        this.gatContext = gatContext;
        this.location = location;
        String res = (String)gatContext.getPreferences().get("file.hiddenfiles.ignore");
        if (res != null && res.equalsIgnoreCase("true")) {
            if (logger.isDebugEnabled()) {
                logger.debug("ignoring hidden files");
            }
            this.ignoreHiddenFiles = true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("FileCpi: created file with URI " + location);
        }
    }

    @NoInfoLogging
    public final GATContext getGATContext() {
        return this.gatContext;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof File)) {
            return false;
        }
        File file = (File)object;
        return this.location.equals((Object)file.toGATURI());
    }

    @NoInfoLogging
    public final URI toURI() {
        return this.location;
    }

    public void move(URI destination) throws GATInvocationException {
        this.copy(destination);
        try {
            FileInterface f = GAT.createFile((GATContext)this.gatContext, (URI)this.location).getFileInterface();
            f.delete();
        }
        catch (Exception e) {
            throw new GATInvocationException("delete failed", (Throwable)e);
        }
    }

    public void recursivelyDeleteDirectory() throws GATInvocationException {
        FileCpi.recursiveDeleteDirectory(this.gatContext, this.location);
    }

    public void copy(URI loc) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean canRead() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean canWrite() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int compareTo(File other) {
        return this.location.compareTo((Object)other.toGATURI());
    }

    public int compareTo(Object other) {
        if (other instanceof FileCpi) {
            return this.location.compareTo((Object)((FileCpi)other).location);
        }
        throw new Error("illegal compareTo operation");
    }

    public boolean createNewFile() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean delete() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void deleteOnExit() {
        Runtime.getRuntime().addShutdownHook(new DeleteHook(this));
    }

    public boolean exists() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public File getAbsoluteFile() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getAbsolutePath() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public File getCanonicalFile() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getCanonicalPath() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type, boolean followSymbLinks) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NoInfoLogging
    public final String getName() {
        String path = this.getPath();
        return new java.io.File(path).getName();
    }

    public String getParent() throws GATInvocationException {
        String path = this.getPath();
        int pos = path.lastIndexOf("/");
        if (pos == -1) {
            return null;
        }
        String res = path.substring(0, pos);
        if (logger.isDebugEnabled()) {
            logger.debug("GET PARENT: orig = " + path + " parent = " + res);
        }
        return res;
    }

    public File getParentFile() throws GATInvocationException {
        String parent = this.getParent();
        if (parent == null) {
            return null;
        }
        try {
            URI dest = this.location.setPath(parent);
            if (logger.isDebugEnabled()) {
                logger.debug("GET PARENTFILE: orig = " + this.location + " new* = " + dest);
            }
            return GAT.createFile((GATContext)this.gatContext, (URI)dest);
        }
        catch (Exception e) {
            throw new GATInvocationException("file cpi", (Throwable)e);
        }
    }

    @NoInfoLogging
    public final String getPath() {
        String res = this.location.getPath();
        if (res == null) {
            throw new Error("path not specified correctly in URI: " + this.location);
        }
        return res;
    }

    public final int hashCode() {
        return this.location.hashCode();
    }

    public final boolean isAbsolute() {
        return new java.io.File(this.location.getPath()).isAbsolute();
    }

    public static final boolean isAbsolute(URI location) {
        return new java.io.File(location.getPath()).isAbsolute();
    }

    public boolean isDirectory() throws GATInvocationException {
        if (this.location.getPath().endsWith(File.separator)) {
            return true;
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isFile() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isHidden() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long lastModified() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long length() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String[] list() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public File[] listFiles() throws GATInvocationException {
        try {
            String[] f = this.list();
            File[] res = new File[f.length];
            for (int i = 0; i < f.length; ++i) {
                String uri = this.location.toString();
                if (!uri.endsWith("/")) {
                    uri = uri + "/";
                }
                uri = uri + f[i];
                res[i] = GAT.createFile((GATContext)this.gatContext, (URI)new URI(uri));
            }
            return res;
        }
        catch (Exception e) {
            throw new GATInvocationException("file cpi", (Throwable)e);
        }
    }

    public String[] list(FilenameFilter filter) throws GATInvocationException {
        if (!this.isDirectory()) {
            return null;
        }
        try {
            String[] l = this.list();
            if (filter == null) {
                return l;
            }
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < l.length; ++i) {
                if (!filter.accept((java.io.File)GAT.createFile((GATContext)this.gatContext, (URI)new URI(this.location.getPath())), l[i])) continue;
                v.add(l[i]);
            }
            String[] res = new String[v.size()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = (String)v.get(i);
            }
            return res;
        }
        catch (Throwable t) {
            throw new GATInvocationException("file cpi", t);
        }
    }

    public File[] listFiles(FileFilter filter) throws GATInvocationException {
        if (!this.isDirectory()) {
            return null;
        }
        try {
            File[] l = this.listFiles();
            if (filter == null) {
                return l;
            }
            Vector<File> v = new Vector<File>();
            for (int i = 0; i < l.length; ++i) {
                if (!filter.accept((java.io.File)GAT.createFile((GATContext)this.gatContext, (URI)new URI(l[i].getPath())))) continue;
                v.add(l[i]);
            }
            File[] res = new File[v.size()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = (File)v.get(i);
            }
            return res;
        }
        catch (Throwable t) {
            throw new GATInvocationException("file cpi", t);
        }
    }

    public File[] listFiles(FilenameFilter filter) throws GATInvocationException {
        if (!this.isDirectory()) {
            return null;
        }
        try {
            File[] l = this.listFiles();
            if (filter == null) {
                return l;
            }
            Vector<File> v = new Vector<File>();
            for (int i = 0; i < l.length; ++i) {
                if (!filter.accept((java.io.File)GAT.createFile((GATContext)this.gatContext, (URI)new URI(this.location.getPath())), l[i].getPath())) continue;
                v.add(l[i]);
            }
            File[] res = new File[v.size()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = (File)v.get(i);
            }
            return res;
        }
        catch (Throwable t) {
            throw new GATInvocationException("file cpi", t);
        }
    }

    public boolean mkdir() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean mkdirs() throws GATInvocationException {
        if (this.exists()) {
            return false;
        }
        if (this.mkdir()) {
            return true;
        }
        FileInterface parent = this.getParentFile().getFileInterface();
        return parent != null && (parent.mkdirs() || parent.exists()) && this.mkdir();
    }

    public boolean renameTo(File arg0) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean setLastModified(long arg0) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean setReadOnly() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NoInfoLogging
    public final String toString() {
        return "GAT file: " + this.toURI().toString();
    }

    @NoInfoLogging
    public final URL toURL() throws MalformedURLException {
        return this.location.toURL();
    }

    protected static URI fixURI(URI in, String destScheme) {
        URI fixedURI;
        String uriString;
        block5: {
            uriString = in.toString();
            if (destScheme != null) {
                uriString = in.getScheme() != null ? uriString.replaceFirst(in.getScheme(), destScheme) : (in.getAuthority() == null ? destScheme + ":///" + uriString : destScheme + "://" + uriString);
            }
            if (in.getAuthority() == null && !FileCpi.isAbsolute(in)) {
                if (destScheme == null && in.getScheme() == null) {
                    uriString = "file:" + uriString;
                }
                uriString = uriString.replace(in.getPath(), new java.io.File(System.getProperty("user.dir")).toURI().getPath() + in.getPath());
            }
            fixedURI = null;
            try {
                fixedURI = new URI(uriString);
            }
            catch (URISyntaxException e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("internal UnsupportedOperationException: " + e);
            }
        }
        logger.debug("FIXURI \"" + in + "\" -> \"" + uriString + "\"");
        return fixedURI;
    }

    protected void copyDir(URI destination) throws Exception {
        FileCpi.copyDirectory(this.gatContext, null, this.location, destination);
    }

    protected void copyDirContents(URI destination) throws GATInvocationException {
        if (logger.isDebugEnabled()) {
            logger.debug("copyDirectory contents '" + this.location + "' to '" + destination + "'");
        }
        File source = null;
        try {
            source = GAT.createFile((GATContext)this.gatContext, (URI)this.location);
        }
        catch (GATObjectCreationException e1) {
            // empty catch block
        }
        File[] files = null;
        if (source != null) {
            files = (File[])source.listFiles();
        }
        if (files == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("copyDirectory: no files in src directory: " + this.location);
            }
            return;
        }
        for (File file : files) {
            FileInterface f = file.getFileInterface();
            if (logger.isDebugEnabled()) {
                logger.debug("copyDirectory: file to copy = " + f);
            }
            try {
                f.copy(new URI(destination + "/" + f.getName()));
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
    }

    protected static void copyDirectory(GATContext gatContext, Preferences additionalPreferences, URI dirURI, URI dest) throws GATInvocationException {
        FileCpi.copyDirectory(gatContext, additionalPreferences, false, dirURI, dest);
    }

    private static void copyDirectory(GATContext gatContext, Preferences additionalPreferences, boolean nested, URI dirURI, URI dest) throws GATInvocationException {
        boolean existingDir;
        boolean existingFile;
        FileInterface destFile;
        block30: {
            if (logger.isDebugEnabled()) {
                logger.debug("copyDirectory '" + dirURI + "' to '" + dest + "'");
            }
            destFile = null;
            existingFile = false;
            existingDir = false;
            try {
                destFile = GAT.createFile((GATContext)gatContext, (Preferences)additionalPreferences, (URI)dest).getFileInterface();
                if (destFile.exists()) {
                    if (!destFile.isDirectory()) {
                        existingFile = true;
                    } else {
                        existingDir = true;
                    }
                }
            }
            catch (GATObjectCreationException e) {
                throw new GATInvocationException("file cpi", (Throwable)e);
            }
            catch (GATInvocationException e) {
                if (!logger.isDebugEnabled()) break block30;
                logger.debug("copyDirectory not able to check if '" + dest.toString() + "' is existing file");
            }
        }
        if (existingFile) {
            throw new GATInvocationException("cannot overwrite non-directory '" + dest.toString() + "' with directory '" + dirURI.toString() + "'!");
        }
        if (existingDir && (nested || !gatContext.getPreferences().containsKey("file.directory.copy") || !((String)gatContext.getPreferences().get("file.directory.copy")).equalsIgnoreCase("contents"))) {
            String sourcePath = dirURI.getPath();
            if (sourcePath.endsWith("/")) {
                sourcePath = sourcePath.substring(0, sourcePath.length() - 1);
            }
            if (sourcePath.length() > 0) {
                int start = sourcePath.lastIndexOf("/") + 1;
                String separator = "";
                if (!dest.toString().endsWith("/")) {
                    separator = "/";
                }
                try {
                    dest = new URI(dest.toString() + separator + sourcePath.substring(start));
                    destFile = GAT.createFile((GATContext)gatContext, (Preferences)additionalPreferences, (URI)dest).getFileInterface();
                }
                catch (URISyntaxException e) {
                }
                catch (GATObjectCreationException e) {
                    throw new GATInvocationException("file cpi", (Throwable)e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("dest=" + dest);
        }
        boolean targetDirCreated = false;
        targetDirCreated = gatContext.getPreferences().containsKey("file.create") && ((String)gatContext.getPreferences().get("file.create")).equalsIgnoreCase("true") ? destFile.mkdirs() : destFile.mkdir();
        FileInterface dir = null;
        try {
            dir = GAT.createFile((GATContext)gatContext, (Preferences)additionalPreferences, (URI)dirURI).getFileInterface();
        }
        catch (GATObjectCreationException e) {
            throw new GATInvocationException("file cpi", (Throwable)e);
        }
        File[] files = dir.listFiles();
        if (files == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("copyDirectory: no files in src directory: " + dirURI.toString());
            }
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            FileInterface f = files[i].getFileInterface();
            if (logger.isDebugEnabled()) {
                logger.debug("copyDirectory: file to copy = " + f);
            }
            URI newDest = null;
            try {
                String newDestString = dest.toString();
                newDestString = newDestString + "/" + f.getName();
                newDest = new URI(newDestString);
            }
            catch (URISyntaxException e) {
                throw new GATInvocationException("file cpi", (Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("new dest: " + newDest.toString());
                logger.debug("src is file: " + f.isFile());
                logger.debug("src is dir: " + f.isDirectory());
            }
            if (f.isFile()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("copyDirectory: copying " + f);
                }
                if (targetDirCreated) {
                    f.safeCopy(newDest);
                    continue;
                }
                f.copy(newDest);
                continue;
            }
            if (f.isDirectory()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("copyDirectory: copying dir " + f);
                }
                FileCpi.copyDirectory(gatContext, additionalPreferences, true, f.toURI(), dest);
                continue;
            }
            throw new GATInvocationException("file cpi, don't know how to handle file: " + f + " (links are not supported).");
        }
    }

    public void safeCopy(URI dest) throws GATInvocationException {
        this.copy(dest);
    }

    public static void recursiveDeleteDirectory(GATContext gatContext, URI dirUri) throws GATInvocationException {
        FileInterface dir;
        try {
            dir = GAT.createFile((GATContext)gatContext, (URI)dirUri).getFileInterface();
        }
        catch (GATObjectCreationException e) {
            throw new GATInvocationException("generic file cpi", (Throwable)e);
        }
        FileCpi.recursiveDeleteDirectory(gatContext, dir);
    }

    public static void recursiveDeleteDirectory(GATContext gatContext, FileInterface dir) throws GATInvocationException {
        if (logger.isInfoEnabled()) {
            logger.info("recursive delete dir: " + dir);
        }
        try {
            if (dir.delete()) {
                return;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        GATInvocationException exception = new GATInvocationException();
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    if (files[i].getFileInterface().isDirectory()) {
                        FileCpi.recursiveDeleteDirectory(gatContext, files[i].toGATURI());
                        continue;
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info("delete: " + files[i]);
                    }
                    files[i].getFileInterface().delete();
                    continue;
                }
                catch (GATInvocationException e) {
                    exception.add("file cpi", (Throwable)e);
                }
            }
        }
        try {
            dir.delete();
        }
        catch (Exception e) {
            exception.add("file cpi", (Throwable)e);
        }
        if (exception.getNrChildren() != 0) {
            throw exception;
        }
    }

    public String marshal() {
        SerializedFile f = new SerializedFile();
        f.setLocation(this.location.toString());
        return GATEngine.defaultMarshal(f);
    }

    public static Advertisable unmarshal(GATContext context, String s) {
        SerializedFile f = (SerializedFile)GATEngine.defaultUnmarshal(SerializedFile.class, s);
        try {
            return GAT.createFile((GATContext)context, (URI)new URI(f.getLocation()));
        }
        catch (Exception e) {
            throw new Error("could not create new GAT object");
        }
    }

    protected static boolean recognizedScheme(String scheme, String[] recognized) {
        if ("any".equals(scheme)) {
            return true;
        }
        for (String r : recognized) {
            if (!r.equals(scheme)) continue;
            return true;
        }
        return false;
    }

    protected boolean determineIsDirectory() throws GATInvocationException {
        if ((this.toURI().isCompatible("file") || this.toURI().isCompatible("local")) && this.toURI().refersToLocalHost()) {
            try {
                java.io.File f = new java.io.File(this.getPath());
                return f.isDirectory();
            }
            catch (Exception e) {
                throw new GATInvocationException("fileCPI", (Throwable)e);
            }
        }
        try {
            return this.isDirectory();
        }
        catch (Exception e) {
            try {
                File f = GAT.createFile((GATContext)this.gatContext, (URI)this.toURI());
                return f.getFileInterface().isDirectory();
            }
            catch (Exception e2) {
                throw new GATInvocationException("fileCPI", (Throwable)e2);
            }
        }
    }

    private static class DeleteHook
    extends Thread {
        FileCpi f;

        DeleteHook(FileCpi f) {
            this.f = f;
        }

        @Override
        public void run() {
            try {
                File file = GAT.createFile((GATContext)this.f.gatContext, (URI)this.f.toURI());
                file.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

