/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.components.impl;

import integratedtoolkit.components.ResourceUser;
import integratedtoolkit.components.impl.JobManager;
import integratedtoolkit.components.scheduler.SchedulerPolicies;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.Task;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.util.CoreManager;
import integratedtoolkit.util.ErrorManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class TaskScheduler {
    protected JobManager JM;
    protected SchedulerPolicies schedulerPolicies;
    protected static final Logger logger = Logger.getLogger("integratedtoolkit.Components.TaskDispatcher.TaskScheduler");
    protected static final boolean debug = logger.isDebugEnabled();
    protected static final boolean presched = System.getProperty("it.presched") != null && System.getProperty("it.presched").equals("true");
    private HashMap<Worker<?>, List<Task>> nodeToRunningTasks;
    private int[] runningCount;
    private long[] accumulatedInit;
    private static final long referenceTime = System.currentTimeMillis();
    private static final int MAX_RETRIES = 3;
    protected ExecutionProfile[][] profile;

    public TaskScheduler() {
        if (this.nodeToRunningTasks == null) {
            this.nodeToRunningTasks = new HashMap();
        } else {
            this.nodeToRunningTasks.clear();
        }
        int coreCount = CoreManager.getCoreCount();
        this.runningCount = new int[coreCount];
        this.accumulatedInit = new long[coreCount];
        this.profile = new ExecutionProfile[coreCount][];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            this.runningCount[coreId] = 0;
            this.accumulatedInit[coreId] = 0L;
            int implCount = CoreManager.getCoreImplementations(coreId).length;
            this.profile[coreId] = new ExecutionProfile[implCount];
            for (int implId = 0; implId < implCount; ++implId) {
                this.profile[coreId][implId] = new ExecutionProfile();
            }
        }
    }

    public void setCoWorkers(JobManager JM) {
        this.JM = JM;
        this.schedulerPolicies.JM = JM;
    }

    public void resizeDataStructures() {
        int implId;
        int implCount;
        int coreId;
        int coreCount = CoreManager.getCoreCount();
        ExecutionProfile[][] profileTmp = new ExecutionProfile[coreCount][];
        for (coreId = 0; coreId < this.profile.length; ++coreId) {
            implCount = CoreManager.getCoreImplementations(coreId).length;
            profileTmp[coreId] = new ExecutionProfile[implCount];
            System.arraycopy(this.profile[coreId], 0, profileTmp[coreId], 0, this.profile[coreId].length);
            for (implId = this.profile[coreId].length; implId < implCount; ++implId) {
                profileTmp[coreId][implId] = new ExecutionProfile();
            }
        }
        for (coreId = this.profile.length; coreId < coreCount; ++coreId) {
            implCount = CoreManager.getCoreImplementations(coreId).length;
            profileTmp[coreId] = new ExecutionProfile[implCount];
            for (implId = this.profile[coreId].length; implId < implCount; ++implId) {
                profileTmp[coreId][implId] = new ExecutionProfile();
            }
        }
        this.profile = profileTmp;
    }

    public abstract boolean isPendingWork(Integer var1);

    public void resourcesCreated(Worker<?> res) {
        this.nodeToRunningTasks.put(res, new LinkedList());
    }

    public abstract void reduceResource(Worker<?> var1);

    public void removeNode(Worker<?> resource) {
        this.nodeToRunningTasks.remove(resource);
    }

    public abstract void scheduleTask(Task var1);

    public abstract boolean rescheduleTask(Task var1, Worker<?> var2);

    public abstract boolean scheduleToResource(Worker<?> var1);

    public void getWorkloadState(ResourceUser.WorkloadStatus state) {
        int coreCount = state.getCoreCount();
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            long[] stats = this.getCoreStats(coreId, 100L);
            state.registerTimes(coreId, stats[1], stats[2], stats[3]);
            long currentMeanRunningTime = System.currentTimeMillis() - referenceTime;
            if (this.runningCount[coreId] > 0) {
                currentMeanRunningTime -= this.accumulatedInit[coreId] / (long)this.runningCount[coreId];
            }
            state.registerRunningTask(coreId, this.runningCount[coreId], currentMeanRunningTime);
        }
    }

    private long[] getCoreStats(int coreId, long defaultValue) {
        long[] result = new long[4];
        int counter = 0;
        long maxTime = Long.MIN_VALUE;
        long minTime = Long.MAX_VALUE;
        long avgTime = 0L;
        for (int implId = 0; implId < CoreManager.getCoreImplementations(coreId).length; ++implId) {
            if (this.profile[coreId][implId].executionCount <= 0) continue;
            counter += this.profile[coreId][implId].executionCount;
            avgTime += (long)this.profile[coreId][implId].executionCount * this.profile[coreId][implId].avgExecutionTime;
            if (this.profile[coreId][implId].maxExecutionTime > maxTime) {
                maxTime = this.profile[coreId][implId].maxExecutionTime;
            }
            if (this.profile[coreId][implId].minExecutionTime >= minTime) continue;
            minTime = this.profile[coreId][implId].minExecutionTime;
        }
        if (counter > 0) {
            result[0] = counter;
            result[1] = minTime;
            result[2] = avgTime / (long)counter;
            result[3] = maxTime;
        } else {
            Task earlier = null;
            for (int implId = 0; implId < CoreManager.getCoreImplementations(coreId).length; ++implId) {
                if (this.profile[coreId][implId].firstExecution == null) continue;
                if (earlier == null) {
                    earlier = this.profile[coreId][implId].firstExecution;
                    continue;
                }
                if (earlier.getInitialTimeStamp() <= this.profile[coreId][implId].firstExecution.getInitialTimeStamp()) continue;
                earlier = this.profile[coreId][implId].firstExecution;
            }
            if (earlier == null) {
                result[0] = 0L;
                result[1] = defaultValue;
                result[2] = defaultValue;
                result[3] = defaultValue;
            } else {
                long difference;
                result[0] = 0L;
                result[1] = difference = System.currentTimeMillis() - earlier.getInitialTimeStamp();
                result[2] = difference;
                result[3] = difference;
            }
        }
        return result;
    }

    public String getCoresMonitoringData(String prefix) {
        StringBuilder sb = new StringBuilder(prefix + "<CoresInfo>" + "\n");
        for (Map.Entry<String, Integer> entry : CoreManager.SIGNATURE_TO_ID.entrySet()) {
            int core = entry.getValue();
            String signature = entry.getKey();
            sb.append(prefix + "\t").append("<Core id=\"").append(core).append("\" signature=\"" + signature + "\">").append("\n");
            long[] stats = this.getCoreStats(core, 0L);
            sb.append(prefix + "\t\t").append("<MeanExecutionTime>").append(stats[2]).append("</MeanExecutionTime>\n");
            sb.append(prefix + "\t\t").append("<MinExecutionTime>").append(stats[1]).append("</MinExecutionTime>\n");
            sb.append(prefix + "\t\t").append("<MaxExecutionTime>").append(stats[3]).append("</MaxExecutionTime>\n");
            sb.append(prefix + "\t\t").append("<ExecutedCount>").append(stats[0]).append("</ExecutedCount>\n");
            sb.append(prefix + "\t").append("</Core>").append("\n");
        }
        sb.append("\t</CoresInfo>\n");
        return sb.toString();
    }

    public String getRunningTasksMonitorData(Worker<?> worker) {
        List<Task> tasks = this.nodeToRunningTasks.get(worker);
        if (tasks != null) {
            StringBuilder sb = new StringBuilder("");
            for (Task t : tasks) {
                sb.append(t.getId()).append(" ");
            }
            return sb.toString();
        }
        return null;
    }

    protected boolean sendJob(Task task, Worker resource, Implementation<?> impl) {
        if (resource.runTask(impl.getRequirements())) {
            try {
                this.startsExecution(task, resource, impl.getImplementationId());
            }
            catch (Exception e) {
                logger.error("Exception starting execution", e);
                return false;
            }
            this.JM.newJob(task, impl, resource);
            return true;
        }
        return false;
    }

    protected boolean sendJobRescheduled(Task task, Worker resource, Implementation impl) {
        if (resource.runTask(impl.getRequirements())) {
            try {
                this.startsExecution(task, resource, impl.getImplementationId());
            }
            catch (Exception e) {
                logger.error("Exception starting execution", e);
                return false;
            }
            this.JM.jobRescheduled(task, impl, resource);
            return true;
        }
        return false;
    }

    public void taskEnd(Task task, Worker<?> resource, int implementationId) {
        switch (task.getStatus()) {
            case FINISHED: {
                this.endsExecution(task, resource, true, implementationId);
                break;
            }
            case TO_RESCHEDULE: {
                this.endsExecution(task, resource, false, implementationId);
                break;
            }
            case FAILED: {
                this.endsExecution(task, resource, false, implementationId);
                break;
            }
            default: {
                ErrorManager.fatal("INVALID KIND OF TASK ENDED: " + (Object)((Object)task.getStatus()));
            }
        }
    }

    private void startsExecution(Task t, Worker<?> resource, int implId) throws Exception {
        int retries = 0;
        boolean added = false;
        List<Task> tasks = null;
        this.nodeToRunningTasks.get(resource);
        while (retries < 3) {
            tasks = this.nodeToRunningTasks.get(resource);
            if (tasks != null) {
                tasks.add(t);
                retries = 3;
                continue;
            }
            if (retries >= 3) {
                throw new Exception("Resource " + resource.getName() + " still not created.");
            }
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++retries;
        }
        int coreId = t.getTaskParams().getId();
        long startTime = System.currentTimeMillis();
        int n = coreId;
        this.runningCount[n] = this.runningCount[n] + 1;
        int n2 = coreId;
        this.accumulatedInit[n2] = this.accumulatedInit[n2] + (startTime - referenceTime);
        t.setInitialTimeStamp(startTime);
        if (this.profile[coreId][implId].firstExecution == null) {
            this.profile[coreId][implId].firstExecution = t;
        }
    }

    private void endsExecution(Task task, Worker<?> resource, boolean success, int implId) {
        int core;
        this.nodeToRunningTasks.get(resource).remove(task);
        int n = core = task.getTaskParams().getId().intValue();
        this.runningCount[n] = this.runningCount[n] - 1;
        int n2 = core;
        this.accumulatedInit[n2] = this.accumulatedInit[n2] - (task.getInitialTimeStamp() - referenceTime);
        if (success) {
            this.profile[core][implId].executionEnded(task);
        } else if (this.profile[core][implId].firstExecution == task) {
            long firstTime = Long.MAX_VALUE;
            Task firstTask = null;
            for (List<Task> tasks : this.nodeToRunningTasks.values()) {
                for (Task running : tasks) {
                    if (running.getTaskParams().getId() != core || firstTime <= running.getInitialTimeStamp()) continue;
                    firstTask = running;
                }
            }
            this.profile[core][implId].firstExecution = firstTask;
        }
    }

    public class ExecutionProfile {
        private Task firstExecution = null;
        private int executionCount = 0;
        private long avgExecutionTime = 0L;
        private long maxExecutionTime = 0L;
        private long minExecutionTime = Long.MAX_VALUE;

        public void executionEnded(Task task) {
            long initialTime = task.getInitialTimeStamp();
            long duration = System.currentTimeMillis() - initialTime;
            Long mean = this.avgExecutionTime;
            if (mean == null) {
                mean = 0L;
            }
            if (this.maxExecutionTime < duration) {
                this.maxExecutionTime = duration;
            }
            if (this.minExecutionTime > duration) {
                this.minExecutionTime = duration;
            }
            this.avgExecutionTime = (mean * (long)this.executionCount + duration) / (long)(this.executionCount + 1);
            ++this.executionCount;
        }

        public int getExecutionCount() {
            return this.executionCount;
        }

        public Long getMinExecutionTime(Long defaultValue) {
            if (this.executionCount > 0) {
                return this.minExecutionTime;
            }
            if (this.firstExecution == null) {
                return defaultValue;
            }
            return System.currentTimeMillis() - this.firstExecution.getInitialTimeStamp();
        }

        public Long getMaxExecutionTime(Long defaultValue) {
            if (this.executionCount > 0) {
                return this.maxExecutionTime;
            }
            if (this.firstExecution == null) {
                return defaultValue;
            }
            return System.currentTimeMillis() - this.firstExecution.getInitialTimeStamp();
        }

        public Long getAverageExecutionTime(Long defaultValue) {
            if (this.executionCount > 0) {
                return this.avgExecutionTime;
            }
            if (this.firstExecution == null) {
                return defaultValue;
            }
            return System.currentTimeMillis() - this.firstExecution.getInitialTimeStamp();
        }
    }
}

