/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.loader.total;

import integratedtoolkit.loader.LoaderUtils;
import integratedtoolkit.loader.total.ITAppEditor;
import integratedtoolkit.util.ErrorManager;
import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.apache.log4j.Logger;

public class ITAppModifier {
    private static final ClassPool cp = ClassPool.getDefault();
    private static final boolean writeToFile = System.getProperty("it.to.file") != null && System.getProperty("it.to.file").equals("true");
    private static final boolean isWSClass = System.getProperty("it.is.ws") != null && System.getProperty("it.is.ws").equals("true");
    private static final boolean isMainClass = System.getProperty("it.is.mainclass") == null || !System.getProperty("it.is.mainclass").equals("false");
    private static final Logger logger = Logger.getLogger("integratedtoolkit.Loader");
    private static final boolean debug = logger.isDebugEnabled();

    public Class<?> modify(String appName) throws NotFoundException, CannotCompileException, ClassNotFoundException {
        Class<?> annotItf = Class.forName(appName + "Itf");
        Method[] remoteMethods = annotItf.getMethods();
        cp.importPackage("integratedtoolkit");
        cp.importPackage("integratedtoolkit.api");
        cp.importPackage("integratedtoolkit.api.impl");
        cp.importPackage("integratedtoolkit.loader");
        cp.importPackage("integratedtoolkit.loader.total");
        CtClass appClass = cp.get(appName);
        CtClass itApiClass = cp.get("integratedtoolkit.api.IntegratedToolkit");
        CtClass itExecClass = cp.get("integratedtoolkit.api.ITExecution");
        CtClass itSRClass = cp.get("integratedtoolkit.loader.total.StreamRegistry");
        CtClass itORClass = cp.get("integratedtoolkit.loader.total.ObjectRegistry");
        CtClass appIdClass = cp.get("java.lang.Long");
        String varName = LoaderUtils.randomName(5, "it");
        String itApiVar = varName + "Api";
        String itExeVar = varName + "Exe";
        String itSRVar = varName + "SR";
        String itORVar = varName + "OR";
        String itAppIdVar = varName + "AppId";
        CtField itApiField = new CtField(itApiClass, itApiVar, appClass);
        CtField itExeField = new CtField(itExecClass, itExeVar, appClass);
        CtField itSRField = new CtField(itSRClass, itSRVar, appClass);
        CtField itORField = new CtField(itORClass, itORVar, appClass);
        CtField appIdField = new CtField(appIdClass, itAppIdVar, appClass);
        itApiField.setModifiers(10);
        itExeField.setModifiers(10);
        itSRField.setModifiers(10);
        itORField.setModifiers(10);
        appIdField.setModifiers(10);
        appClass.addField(itApiField);
        appClass.addField(itExeField);
        appClass.addField(itSRField);
        appClass.addField(itORField);
        appClass.addField(appIdField);
        this.manageStartAndStop(appClass, itApiVar, itExeVar, itSRVar, itORVar);
        CtMethod[] instrCandidates = appClass.getDeclaredMethods();
        ITAppEditor itAppEditor = new ITAppEditor(remoteMethods, instrCandidates, itApiVar, itExeVar, itSRVar, itORVar, itAppIdVar, appClass);
        CodeConverter converter = new CodeConverter();
        CtClass arrayWatcher = cp.get("integratedtoolkit.loader.total.ArrayAccessWatcher");
        CodeConverter.DefaultArrayAccessReplacementMethodNames names = new CodeConverter.DefaultArrayAccessReplacementMethodNames();
        converter.replaceArrayAccess(arrayWatcher, names);
        if (debug) {
            logger.debug("Flags: ToFile: " + writeToFile + " isWS: " + isWSClass + " isMainClass: " + isMainClass);
        }
        for (CtMethod ctMethod : instrCandidates) {
            if (LoaderUtils.checkRemote(ctMethod, remoteMethods) != null) continue;
            if (debug) {
                logger.debug("Instrumenting method " + ctMethod.getName());
            }
            StringBuilder toInsertBefore = new StringBuilder();
            StringBuilder toInsertAfter = new StringBuilder();
            ctMethod.addLocalVariable(itAppIdVar, appIdClass);
            toInsertBefore.append(itAppIdVar).append(" = new Long(Thread.currentThread().getId());");
            boolean isMainProgram = LoaderUtils.isMainMethod(ctMethod);
            boolean isOrchestration = LoaderUtils.isOrchestration(ctMethod);
            if (isMainProgram && isMainClass) {
                logger.debug("Inserting calls at the beginning and at the end of main");
                if (isWSClass) {
                    logger.debug("Inserting calls noMoreTasks at the end of main");
                    toInsertAfter.insert(0, itExeVar + ".noMoreTasks(" + itAppIdVar + ", true);");
                    ctMethod.insertBefore(toInsertBefore.toString());
                    ctMethod.insertAfter(toInsertAfter.toString());
                } else {
                    logger.debug("Inserting calls noMoreTasks and stopIT at the end of main");
                    toInsertBefore.append(appName).append('.').append(itAppIdVar).append(" = new Long(Thread.currentThread().getId());");
                    toInsertAfter.insert(0, itApiVar + ".stopIT(true);");
                    toInsertAfter.insert(0, itExeVar + ".noMoreTasks(" + appName + '.' + itAppIdVar + ", true);");
                    ctMethod.insertBefore(toInsertBefore.toString());
                    ctMethod.insertAfter(toInsertAfter.toString(), true);
                }
                ctMethod.instrument(converter);
                ctMethod.instrument(itAppEditor);
                continue;
            }
            if (isOrchestration) {
                if (isWSClass) {
                    logger.debug("Inserting calls noMoreTasks and stopIT at the end of orchestration");
                    toInsertAfter.insert(0, itExeVar + ".noMoreTasks(" + itAppIdVar + ", true);");
                    ctMethod.insertBefore(toInsertBefore.toString());
                    ctMethod.insertAfter(toInsertAfter.toString());
                } else {
                    logger.debug("Inserting only before at the beginning of an orchestration");
                    ctMethod.insertBefore(toInsertBefore.toString());
                }
                ctMethod.instrument(converter);
                ctMethod.instrument(itAppEditor);
                continue;
            }
            logger.debug("Inserting only before");
            ctMethod.insertBefore(toInsertBefore.toString());
            if (isWSClass) {
                if (!Modifier.isPrivate(ctMethod.getModifiers())) continue;
                ctMethod.instrument(converter);
                ctMethod.instrument(itAppEditor);
                continue;
            }
            ctMethod.instrument(converter);
            ctMethod.instrument(itAppEditor);
        }
        for (CtBehavior ctBehavior : appClass.getDeclaredConstructors()) {
            if (debug) {
                logger.debug("Instrumenting constructor " + ((CtConstructor)ctBehavior).getLongName());
            }
            ctBehavior.instrument(converter);
            ctBehavior.instrument(itAppEditor);
        }
        if (writeToFile) {
            try {
                appClass.writeFile();
            }
            catch (Exception e) {
                ErrorManager.fatal("Error writing the instrumented class file");
            }
            return null;
        }
        return appClass.toClass();
    }

    private void manageStartAndStop(CtClass appClass, String itApiVar, String itExeVar, String itSRVar, String itORVar) throws CannotCompileException, NotFoundException {
        if (debug) {
            logger.debug("Previous class initializer is " + appClass.getClassInitializer());
        }
        CtConstructor initializer = appClass.makeClassInitializer();
        StringBuilder toInsertBefore = new StringBuilder();
        if (isMainClass || isWSClass) {
            toInsertBefore.append("System.setProperty(ITConstants.IT_APP_NAME, \"" + appClass.getName() + "\");");
        }
        toInsertBefore.append(itApiVar + " = new IntegratedToolkitImpl();").append(itExeVar + " = (ITExecution)" + itApiVar + ";").append(itSRVar + " = new StreamRegistry((LoaderAPI) " + itApiVar + " );").append(itORVar + " = new ObjectRegistry((LoaderAPI) " + itApiVar + " );").append(itApiVar + ".startIT();");
        initializer.insertBefore(toInsertBefore.toString());
    }
}

