/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.loader.total;

import integratedtoolkit.loader.LoaderAPI;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ObjectRegistry {
    private LoaderAPI itApi;
    private String serialDir;
    private TreeMap<Integer, Object> appTaskObjects;
    private TreeMap<Integer, Object> internalObjects;
    private static final Logger logger = Logger.getLogger("integratedtoolkit.Loader");
    private static final boolean debug = logger.isDebugEnabled();

    public ObjectRegistry(LoaderAPI api) {
        this.itApi = api;
        this.serialDir = api.getTempDir();
        this.appTaskObjects = new TreeMap();
        this.internalObjects = new TreeMap();
        this.itApi.setObjectRegistry(this);
    }

    public int newObjectParameter(Object o) {
        if (o == null) {
            return Integer.MAX_VALUE;
        }
        int hashCode = o.hashCode();
        Object oStored = this.appTaskObjects.get(hashCode);
        while (oStored != o) {
            if (oStored == null) {
                this.appTaskObjects.put(hashCode, o);
                this.internalObjects.put(hashCode, o);
                if (!debug) break;
                logger.debug("Object " + o + " with hash code " + hashCode + " registered");
                break;
            }
            oStored = this.appTaskObjects.get(++hashCode);
        }
        return hashCode;
    }

    public void newObjectAccess(Object o) {
        this.newObjectAccess(o, true);
    }

    public void newObjectAccess(Object o, boolean isWriter) {
        Object oUpdated;
        if (o == null) {
            return;
        }
        int hashCode = o.hashCode();
        Object oStored = this.appTaskObjects.get(hashCode);
        while (oStored != o) {
            if (oStored == null) {
                return;
            }
            oStored = this.appTaskObjects.get(++hashCode);
        }
        if (debug) {
            logger.debug("New access to object with hash code " + hashCode + ", for writing: " + isWriter);
        }
        if ((oUpdated = this.itApi.getObject(o, hashCode, this.serialDir)) != null) {
            this.internalObjects.put(hashCode, oUpdated);
        }
    }

    public void serializeLocally(Object o) {
        if (o == null) {
            return;
        }
        int hashCode = o.hashCode();
        Object oStored = this.appTaskObjects.get(hashCode);
        while (oStored != o) {
            if (oStored == null) {
                return;
            }
            oStored = this.appTaskObjects.get(++hashCode);
        }
        if (debug) {
            logger.debug("About to serialize locally object with hash code " + hashCode);
        }
        this.itApi.serializeObject(this.internalObjects.get(hashCode), hashCode, this.serialDir);
    }

    public Object getInternalObject(Object o) {
        if (o == null) {
            return null;
        }
        int hashCode = o.hashCode();
        Object oStored = this.appTaskObjects.get(hashCode);
        while (oStored != o) {
            if (oStored == null) {
                return null;
            }
            oStored = this.appTaskObjects.get(++hashCode);
        }
        if (debug) {
            logger.debug("Returning internal object " + hashCode);
        }
        return this.internalObjects.get(hashCode);
    }
}

