/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.request.td;

import integratedtoolkit.components.impl.JobManager;
import integratedtoolkit.components.impl.TaskScheduler;
import integratedtoolkit.types.request.td.TDRequest;
import integratedtoolkit.util.CEIParser;
import integratedtoolkit.util.ResourceManager;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;

public class UpdateLocalCEIRequest
extends TDRequest {
    private Class<?> ceiClass;
    private Semaphore sem;

    public UpdateLocalCEIRequest(Class<?> ceiClass, Semaphore sem) {
        this.ceiClass = ceiClass;
        this.sem = sem;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    public void setSemaphore(Semaphore sem) {
        this.sem = sem;
    }

    public void setCeiClass(Class<?> ceiClass) {
        this.ceiClass = ceiClass;
    }

    public Class<?> getCeiClass() {
        return this.ceiClass;
    }

    @Override
    public void process(TaskScheduler ts, JobManager jm) {
        logger.debug("Treating request to update core elements");
        LinkedList<Integer> newCores = CEIParser.loadJava(this.ceiClass);
        if (debug) {
            logger.debug("New methods: " + newCores);
        }
        ResourceManager.coreElementUpdates(newCores);
        ts.resizeDataStructures();
        logger.debug("Data structures resized and CE-resources links updated");
        this.sem.release();
    }

    @Override
    public TDRequest.TDRequestType getRequestType() {
        return TDRequest.TDRequestType.UPDATE_LOCAL_CEI;
    }
}

