/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.components.ResourceUser;
import integratedtoolkit.types.Task;
import integratedtoolkit.util.CoreManager;
import java.util.LinkedList;

public class TaskSets {
    private LinkedList<Task>[] noResourceTasks;
    private LinkedList<Task>[] tasksToReschedule;
    private LinkedList<Task>[] priorityTasks;
    private LinkedList<Task>[] regularTasks;
    private int noResourceCount;
    private int toRescheduleCount;
    private int priorityCount;
    private int regularCount;

    public TaskSets() {
        int i;
        int coreCount = CoreManager.getCoreCount();
        if (this.noResourceTasks == null) {
            this.noResourceCount = 0;
            this.noResourceTasks = new LinkedList[coreCount];
            for (i = 0; i < coreCount; ++i) {
                this.noResourceTasks[i] = new LinkedList();
            }
        } else {
            for (i = 0; i < coreCount; ++i) {
                this.noResourceTasks[i].clear();
            }
        }
        if (this.tasksToReschedule == null) {
            this.toRescheduleCount = 0;
            this.tasksToReschedule = new LinkedList[coreCount];
            for (i = 0; i < coreCount; ++i) {
                this.tasksToReschedule[i] = new LinkedList();
            }
        } else {
            for (i = 0; i < coreCount; ++i) {
                this.tasksToReschedule[i].clear();
            }
        }
        if (this.priorityTasks == null) {
            this.priorityCount = 0;
            this.priorityTasks = new LinkedList[coreCount];
            for (i = 0; i < coreCount; ++i) {
                this.priorityTasks[i] = new LinkedList();
            }
        } else {
            for (i = 0; i < coreCount; ++i) {
                this.priorityTasks[i].clear();
            }
        }
        if (this.regularTasks == null) {
            this.regularCount = 0;
            this.regularTasks = new LinkedList[coreCount];
            for (i = 0; i < coreCount; ++i) {
                this.regularTasks[i] = new LinkedList();
            }
        } else {
            for (i = 0; i < coreCount; ++i) {
                this.regularTasks[i].clear();
            }
        }
    }

    public void waitWithoutNode(Task t) {
        ++this.noResourceCount;
        this.noResourceTasks[t.getTaskParams().getId()].add(t);
    }

    public void resourceFound(int coreId) {
        this.noResourceCount -= this.noResourceTasks[coreId].size();
        for (Task t : this.noResourceTasks[coreId]) {
            if (t.getTaskParams().hasPriority()) {
                this.priorityTasks[coreId].add(t);
                ++this.priorityCount;
                continue;
            }
            this.regularTasks[coreId].add(t);
            ++this.regularCount;
        }
        this.noResourceTasks[coreId].clear();
    }

    public int getNoResourceCount(int coreId) {
        return this.noResourceTasks[coreId].size();
    }

    public int getNoResourceCount() {
        return this.noResourceCount;
    }

    public LinkedList<Task>[] getPendingTasksWithoutNode() {
        return this.noResourceTasks;
    }

    public void newTaskToReschedule(Task t) {
        ++this.toRescheduleCount;
        this.tasksToReschedule[t.getTaskParams().getId()].add(t);
    }

    public void rescheduledTask(Task t) {
        --this.toRescheduleCount;
        this.tasksToReschedule[t.getTaskParams().getId()].remove(t);
    }

    public boolean areTasksToReschedule() {
        return this.toRescheduleCount != 0;
    }

    public int getToRescheduleCount(int coreId) {
        return this.tasksToReschedule[coreId].size();
    }

    public LinkedList<Task>[] getTasksToReschedule() {
        return this.tasksToReschedule;
    }

    public void newPriorityTask(Task t) {
        this.priorityTasks[t.getTaskParams().getId()].add(t);
        ++this.priorityCount;
    }

    public void priorityTaskScheduled(Task t) {
        --this.priorityCount;
        this.priorityTasks[t.getTaskParams().getId()].remove(t);
    }

    public boolean arePriorityTasks() {
        return this.priorityCount != 0;
    }

    public int getPriorityCount(int coreId) {
        return this.priorityTasks[coreId].size();
    }

    public LinkedList<Task>[] getPriorityTasks() {
        return this.priorityTasks;
    }

    public void newRegularTask(Task t) {
        this.regularTasks[t.getTaskParams().getId()].add(t);
        ++this.regularCount;
    }

    public void regularTaskScheduled(Task t) {
        --this.regularCount;
        this.regularTasks[t.getTaskParams().getId()].remove(t);
    }

    public boolean areRegularTasks() {
        return this.regularCount != 0;
    }

    public int getRegularCount(int coreId) {
        return this.regularTasks[coreId].size();
    }

    public LinkedList<Task>[] getRegularTasks() {
        return this.regularTasks;
    }

    public String describeCurrentState() {
        String pending = "";
        for (int i = 0; i < CoreManager.getCoreCount(); ++i) {
            for (Task t : this.tasksToReschedule[i]) {
                pending = pending + " " + t.getId() + "r";
            }
            for (Task t : this.priorityTasks[i]) {
                pending = pending + " " + t.getId() + "p";
            }
            for (Task t : this.noResourceTasks[i]) {
                pending = pending + " " + t.getId() + "b";
            }
            for (Task t : this.regularTasks[i]) {
                pending = pending + " " + t.getId();
            }
        }
        return pending;
    }

    public String getMonitoringInfo() {
        StringBuilder sb = new StringBuilder("");
        return sb.toString();
    }

    public void resizeDataStructures() {
        int i;
        int coreCount = CoreManager.getCoreCount();
        LinkedList[] tmp = new LinkedList[coreCount];
        System.arraycopy(this.noResourceTasks, 0, tmp, 0, this.noResourceTasks.length);
        for (i = this.noResourceTasks.length; i < coreCount; ++i) {
            tmp[i] = new LinkedList();
        }
        this.noResourceTasks = tmp;
        tmp = new LinkedList[coreCount];
        System.arraycopy(this.tasksToReschedule, 0, tmp, 0, this.tasksToReschedule.length);
        for (i = this.tasksToReschedule.length; i < coreCount; ++i) {
            tmp[i] = new LinkedList();
        }
        this.tasksToReschedule = tmp;
        tmp = new LinkedList[coreCount];
        System.arraycopy(this.priorityTasks, 0, tmp, 0, this.priorityTasks.length);
        for (i = this.priorityTasks.length; i < coreCount; ++i) {
            tmp[i] = new LinkedList();
        }
        this.priorityTasks = tmp;
        tmp = new LinkedList[coreCount];
        System.arraycopy(this.regularTasks, 0, tmp, 0, this.regularTasks.length);
        for (i = this.regularTasks.length; i < coreCount; ++i) {
            tmp[i] = new LinkedList();
        }
        this.regularTasks = tmp;
    }

    public void getWorkloadState(ResourceUser.WorkloadStatus ss) {
        for (int coreId = 0; coreId < ss.getCoreCount(); ++coreId) {
            ss.registerReadyTaskCounts(coreId, this.noResourceTasks[coreId].size(), this.priorityTasks[coreId].size() + this.regularTasks[coreId].size(), this.tasksToReschedule[coreId].size());
        }
    }
}

