/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.sftpTrilead;

import com.trilead.ssh2.SFTPv3FileAttributes;
import com.trilead.ssh2.SFTPv3FileHandle;
import java.io.IOException;
import java.util.Map;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.cpi.FileInputStreamCpi;
import org.gridlab.gat.io.cpi.sftpTrilead.SftpTrileadConnection;
import org.gridlab.gat.io.cpi.sftpTrilead.SftpTrileadFileAdaptor;
import org.gridlab.gat.io.cpi.sftpTrilead.SftpTrileadHostVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpTrileadFileInputStreamAdaptor
extends FileInputStreamCpi {
    protected static Logger logger = LoggerFactory.getLogger(SftpTrileadFileInputStreamAdaptor.class);
    private final SftpTrileadConnection connection;
    private final SFTPv3FileHandle handle;
    private long filesize;
    private long available;
    private long currpos = 0L;
    private boolean closed = false;

    public static String getDescription() {
        return "The SftpTrilead FileInputStream Adaptor implements the FileInputStream object using the SFTP support of the trilead ssh library. Trilead ssh is an open source full java ssh library. On the server side, the 'scp' program must be in the PATH. Connections with a remote ssh server can be made by using the username + password, username + keyfile, or with only a username, depending on the client and server settings.";
    }

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = FileInputStreamCpi.getSupportedCapabilities();
        capabilities.put("available", true);
        capabilities.put("close", true);
        capabilities.put("mark", true);
        capabilities.put("markSupported", true);
        capabilities.put("read", true);
        capabilities.put("reset", true);
        capabilities.put("skip", true);
        return capabilities;
    }

    public static Preferences getSupportedPreferences() {
        Preferences preferences = FileInputStreamCpi.getSupportedPreferences();
        preferences.put("sftptrilead.strictHostKeyChecking", (Object)"false");
        preferences.put("sftptrilead.noHostKeyChecking", (Object)"true");
        preferences.put("sftptrilead.cipher.client2server", (Object)"<sftp default>");
        preferences.put("sftptrilead.cipher.server2client", (Object)"<sftp default>");
        preferences.put("sftptrilead.tcp.nodelay", (Object)"true");
        preferences.put("sftptrilead.connect.timeout", (Object)"5000");
        preferences.put("sftptrilead.kex.timeout", (Object)"5000");
        return preferences;
    }

    public static String[] getSupportedSchemes() {
        return new String[]{"sftptrilead", "sftp", "file"};
    }

    public SftpTrileadFileInputStreamAdaptor(GATContext gatContext, URI location) throws GATObjectCreationException {
        super(gatContext, location);
        if (location.isCompatible("file") && location.refersToLocalHost()) {
            throw new GATObjectCreationException("this adaptor cannot read local files");
        }
        Preferences p = gatContext.getPreferences();
        boolean noHostKeyChecking = ((String)p.get("sftptrilead.noHostKeyChecking", (Object)"true")).equalsIgnoreCase("true");
        boolean strictHostKeyChecking = ((String)p.get("sftptrilead.strictHostKeyChecking", (Object)"false")).equalsIgnoreCase("true");
        String client2serverCipherString = (String)p.get("sftptrilead.cipher.client2server");
        String[] client2serverCiphers = client2serverCipherString == null ? null : client2serverCipherString.split(",");
        String server2clientCipherString = (String)p.get("sftptrilead.cipher.server2client");
        String[] server2clientCiphers = server2clientCipherString == null ? null : server2clientCipherString.split(",");
        boolean tcpNoDelay = ((String)p.get("sftptrilead.tcp.nodelay", (Object)"true")).equalsIgnoreCase("true");
        SftpTrileadHostVerifier verifier = new SftpTrileadHostVerifier(false, strictHostKeyChecking, noHostKeyChecking);
        try {
            this.connection = SftpTrileadFileAdaptor.getConnection(gatContext, location, verifier, client2serverCiphers, server2clientCiphers, tcpNoDelay);
        }
        catch (GATInvocationException e) {
            logger.debug("Could not create connection", (Throwable)e);
            throw new GATObjectCreationException("Could not create connection", (Throwable)e);
        }
        try {
            this.handle = this.connection.sftpClient.openFileRO(location.getPath());
        }
        catch (IOException e) {
            logger.debug("Could not open file", (Throwable)e);
            try {
                SftpTrileadFileAdaptor.closeConnection(this.connection, gatContext.getPreferences());
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw new GATObjectCreationException("Could not open file", (Throwable)e);
        }
        SFTPv3FileAttributes attributes = null;
        try {
            attributes = this.connection.sftpClient.fstat(this.handle);
        }
        catch (Throwable e) {
            logger.debug("Could not get file attributes", e);
            try {
                this.connection.sftpClient.closeFile(this.handle);
            }
            catch (Throwable e1) {
                // empty catch block
            }
            try {
                SftpTrileadFileAdaptor.closeConnection(this.connection, gatContext.getPreferences());
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw new GATObjectCreationException("Could not get file attributes", e);
        }
        this.available = this.filesize = attributes.size.longValue();
    }

    public int available() throws GATInvocationException {
        return (int)this.available;
    }

    public void close() throws GATInvocationException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.connection.sftpClient.closeFile(this.handle);
            }
            catch (Throwable e1) {
                logger.debug("sftpClient.closeFile: ", e1);
            }
            try {
                SftpTrileadFileAdaptor.closeConnection(this.connection, this.gatContext.getPreferences());
            }
            catch (Throwable e) {
                logger.debug("SftpTrileadFileAdaptor.closeConnection: ", e);
            }
        }
    }

    public int read() throws GATInvocationException {
        byte[] b = new byte[1];
        int count = this.read(b, 0, 1);
        if (count < 0) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    public int read(byte[] b, int offset, int len) throws GATInvocationException {
        if (this.closed) {
            throw new GATInvocationException("SftpTrileadFileInputStreamAdaptor: file already closed");
        }
        int cnt = 0;
        while (len > 0) {
            int sz = len > 32768 ? 32768 : len;
            try {
                sz = this.connection.sftpClient.read(this.handle, this.currpos, b, offset, sz);
                if (logger.isDebugEnabled()) {
                    logger.debug("sftpTrileadFileInputStream: read returns " + sz);
                }
            }
            catch (Throwable e) {
                logger.debug("SftpTrileadFileInputStreamAdaptor.read", e);
                throw new GATInvocationException("SftpTrileadFileInputStreamAdaptor", e);
            }
            if (sz < 0) {
                if (cnt == 0) {
                    return -1;
                }
                return cnt;
            }
            this.currpos += (long)sz;
            offset += sz;
            this.available -= (long)sz;
            len -= sz;
            cnt += sz;
        }
        return cnt;
    }

    public int read(byte[] b) throws GATInvocationException {
        return this.read(b, 0, b.length);
    }

    public boolean markSupported() {
        return false;
    }

    public long skip(long arg0) throws GATInvocationException {
        if (this.closed) {
            throw new GATInvocationException("SftpTrileadFileInputStreamAdaptor: file already closed");
        }
        if (arg0 >= 0L && this.currpos < this.filesize) {
            long max = this.filesize - this.currpos;
            if (arg0 > max) {
                arg0 = max;
            }
            this.currpos += arg0;
            this.available -= arg0;
            return arg0;
        }
        return 0L;
    }
}

