/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.gat.master;

import integratedtoolkit.api.ITExecution;
import integratedtoolkit.gat.master.GATWorkerNode;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.MethodImplementation;
import integratedtoolkit.types.TaskParams;
import integratedtoolkit.types.data.DataAccessId;
import integratedtoolkit.types.job.Job;
import integratedtoolkit.types.parameter.BasicTypeParameter;
import integratedtoolkit.types.parameter.DependencyParameter;
import integratedtoolkit.types.parameter.Parameter;
import integratedtoolkit.types.resources.MethodResourceDescription;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.util.ErrorManager;
import integratedtoolkit.util.Tracer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.File;
import org.gridlab.gat.monitoring.Metric;
import org.gridlab.gat.monitoring.MetricDefinition;
import org.gridlab.gat.monitoring.MetricEvent;
import org.gridlab.gat.monitoring.MetricListener;
import org.gridlab.gat.resources.HardwareResourceDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.resources.SoftwareDescription;

public class GATJob
extends integratedtoolkit.types.job.Job<GATWorkerNode>
implements MetricListener {
    private static final String JOBS_DIR = System.getProperty("it.appLogDir") + "jobs" + java.io.File.separator;
    private static final String CALLBACK_PROCESSING_ERR = "Error processing callback for job";
    private static final String ANY_PROT = "any://";
    private static final String JOB_STATUS = "job.status";
    private static final String RES_ATTR = "machine.node";
    private static final String TERM_ERR = "Error terminating";
    private Job GATjob;
    private GATContext context;
    private boolean usingGlobus;
    private boolean userNeeded;
    private Map<String, ResourceBroker> brokers = new TreeMap<String, ResourceBroker>();
    private static final String workerClasspath = System.getProperty("it.worker.cp") != null && System.getProperty("it.worker.cp").compareTo("") != 0 ? System.getProperty("it.worker.cp") : "\"\"";
    private static final String WORKER_SCRIPT = "adaptors/gat/worker.sh";
    public static LinkedList<GATJob> runningJobs = new LinkedList();

    public GATJob(int taskId, TaskParams taskParams, Implementation<?> impl, Resource res, Job.JobListener listener, GATContext context, boolean userNeeded, boolean usingGlobus) {
        super(taskId, taskParams, impl, res, listener);
        this.context = context;
        this.userNeeded = userNeeded;
        this.usingGlobus = usingGlobus;
    }

    @Override
    public Job.JobKind getKind() {
        return Job.JobKind.METHOD;
    }

    @Override
    public void submit() throws Exception {
        logger.info("Submit GTJob with ID " + this.jobId);
        JobDescription jobDescr = null;
        jobDescr = this.prepareJob();
        ResourceBroker broker = null;
        String dest = (String)jobDescr.getResourceDescription().getResourceAttribute(RES_ATTR);
        broker = this.brokers.get(dest);
        if (broker == null) {
            broker = GAT.createResourceBroker(this.context, new URI(dest));
            this.brokers.put(dest, broker);
        }
        Job job = null;
        try {
            job = broker.submitJob(jobDescr, this, JOB_STATUS);
            runningJobs.add(this);
        }
        catch (Exception e) {
            if (tracing) {
                Tracer.freeSlot(((GATWorkerNode)this.worker.getNode()).getHost(), (Integer)jobDescr.getSoftwareDescription().getAttributes().get("slot"));
            }
            throw e;
        }
        this.GATjob = job;
    }

    protected static void stopAll() {
        for (GATJob job : runningJobs) {
            try {
                job.stop();
            }
            catch (Exception e) {
                logger.error(TERM_ERR, e);
            }
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.GATjob != null) {
            MetricDefinition md = this.GATjob.getMetricDefinitionByName(JOB_STATUS);
            Metric m = md.createMetric();
            this.GATjob.removeMetricListener(this, m);
            this.GATjob.stop();
        }
    }

    @Override
    public void processMetricEvent(MetricEvent value) {
        block16: {
            Job job = (Job)value.getSource();
            Job.JobState newJobState = (Job.JobState)((Object)value.getValue());
            JobDescription jd = (JobDescription)job.getJobDescription();
            SoftwareDescription sd = jd.getSoftwareDescription();
            Integer jobId = (Integer)sd.getAttributes().get("jobId");
            logger.debug("Processing job ID = " + jobId);
            if (newJobState == Job.JobState.STOPPED) {
                if (tracing) {
                    Integer slot = (Integer)sd.getAttributes().get("slot");
                    Tracer.freeSlot(((GATWorkerNode)this.getResourceNode()).getHost(), slot);
                }
                try {
                    if (this.usingGlobus) {
                        File errFile = sd.getStderr();
                        File localFile = GAT.createFile(this.context, errFile.toGATURI());
                        if (localFile.length() > 0L) {
                            this.GATjob = null;
                            runningJobs.remove(this);
                            this.listener.jobFailed(this, Job.JobListener.JobEndStatus.EXECUTION_FAILED);
                        } else {
                            if (!debug) {
                                localFile.delete();
                            }
                            runningJobs.remove(this);
                            this.listener.jobCompleted(this);
                        }
                        break block16;
                    }
                    if (job.getExitStatus() == 0) {
                        runningJobs.remove(this);
                        this.listener.jobCompleted(this);
                        break block16;
                    }
                    this.GATjob = null;
                    runningJobs.remove(this);
                    this.listener.jobFailed(this, Job.JobListener.JobEndStatus.EXECUTION_FAILED);
                }
                catch (Exception e) {
                    ErrorManager.fatal("Error processing callback for job: " + this, e);
                }
            } else if (newJobState == Job.JobState.SUBMISSION_ERROR) {
                if (tracing) {
                    Integer slot = (Integer)sd.getAttributes().get("slot");
                    Tracer.freeSlot(((GATWorkerNode)this.getResourceNode()).getHost(), slot);
                }
                try {
                    if (this.usingGlobus && job.getInfo().get("resManError").equals("NO_ERROR")) {
                        runningJobs.remove(this);
                        this.listener.jobCompleted(this);
                    } else {
                        this.GATjob = null;
                        runningJobs.remove(this);
                        this.listener.jobFailed(this, Job.JobListener.JobEndStatus.SUBMISSION_FAILED);
                    }
                }
                catch (GATInvocationException e) {
                    ErrorManager.fatal("Error processing callback for job: " + this, e);
                }
            }
        }
    }

    private JobDescription prepareJob() throws Exception {
        MethodImplementation method = (MethodImplementation)this.impl;
        TaskParams taskParams = this.taskParams;
        String methodName = taskParams.getName();
        String targetPath = ((GATWorkerNode)this.getResourceNode()).getInstallDir();
        String targetHost = ((GATWorkerNode)this.getResourceNode()).getHost();
        String targetUser = ((GATWorkerNode)this.getResourceNode()).getUser();
        targetUser = this.userNeeded && !targetUser.isEmpty() ? targetUser + "@" : "";
        SoftwareDescription sd = new SoftwareDescription();
        sd.setExecutable(targetPath + File.separator + WORKER_SCRIPT);
        ArrayList<String> lArgs = new ArrayList<String>();
        lArgs.add(lang);
        lArgs.add(((GATWorkerNode)this.getResourceNode()).getWorkingDir());
        lArgs.add(((GATWorkerNode)this.getResourceNode()).getLibPath());
        LinkedList<String> obsoleteFiles = this.getResource().clearObsoletes();
        if (obsoleteFiles != null) {
            lArgs.add("" + obsoleteFiles.size());
            for (String renaming : obsoleteFiles) {
                lArgs.add(renaming);
            }
        } else {
            lArgs.add("0");
        }
        lArgs.add(Boolean.toString(tracing));
        lArgs.add(this.getHostName());
        if (debug) {
            logger.debug("hostName " + this.getHostName());
        }
        if (tracing) {
            lArgs.add(String.valueOf(Tracer.getTaskEventsType()));
            lArgs.add(String.valueOf(this.taskParams.getId() + 1));
            int slot = Tracer.getNextSlot(targetHost);
            lArgs.add(String.valueOf(slot));
            sd.addAttribute("slot", slot);
        }
        lArgs.add(((GATWorkerNode)this.getResourceNode()).getAppDir());
        lArgs.add(workerClasspath);
        lArgs.add(workerDebug.toString());
        lArgs.add(method.getDeclaringClass());
        lArgs.add(methodName);
        lArgs.add(Boolean.toString(taskParams.hasTargetObject()));
        int numParams = taskParams.getParameters().length;
        if (taskParams.hasReturnValue()) {
            --numParams;
        }
        lArgs.add(Integer.toString(numParams));
        for (Parameter param : taskParams.getParameters()) {
            ITExecution.ParamType type = param.getType();
            lArgs.add(Integer.toString(type.ordinal()));
            if (type == ITExecution.ParamType.FILE_T || type == ITExecution.ParamType.OBJECT_T) {
                DependencyParameter dPar = (DependencyParameter)param;
                DataAccessId dAccId = dPar.getDataAccessId();
                lArgs.add(dPar.getDataTarget());
                if (type != ITExecution.ParamType.OBJECT_T) continue;
                if (dAccId instanceof DataAccessId.RAccessId) {
                    lArgs.add("R");
                    continue;
                }
                lArgs.add("W");
                continue;
            }
            if (type == ITExecution.ParamType.STRING_T) {
                BasicTypeParameter btParS = (BasicTypeParameter)param;
                String value = btParS.getValue().toString();
                int numSubStrings = value.split(" ").length;
                lArgs.add(Integer.toString(numSubStrings));
                lArgs.add(value);
                continue;
            }
            BasicTypeParameter btParB = (BasicTypeParameter)param;
            lArgs.add(btParB.getValue().toString());
        }
        String[] arguments = new String[lArgs.size()];
        arguments = lArgs.toArray(arguments);
        try {
            sd.setArguments(arguments);
        }
        catch (NullPointerException e) {
            StringBuilder sb = new StringBuilder("Argument null a parametre del job " + this.jobId + "(" + methodName + "@" + method.getDeclaringClass() + ")\n");
            int i = 0;
            for (Parameter param : taskParams.getParameters()) {
                sb.append("Parametre ").append(i).append("\n");
                ITExecution.ParamType type = param.getType();
                sb.append("\t Type: ").append((Object)param.getType()).append("\n");
                if (type == ITExecution.ParamType.FILE_T || type == ITExecution.ParamType.OBJECT_T) {
                    DependencyParameter dPar = (DependencyParameter)param;
                    DataAccessId dAccId = dPar.getDataAccessId();
                    sb.append("\t Target: ").append(dPar.getDataTarget()).append("\n");
                    if (type == ITExecution.ParamType.OBJECT_T) {
                        if (dAccId instanceof DataAccessId.RAccessId) {
                            sb.append("\t Direction: R").append("\n");
                        } else {
                            sb.append("\t Direction: W").append("\n");
                        }
                    }
                } else if (type == ITExecution.ParamType.STRING_T) {
                    BasicTypeParameter btParS = (BasicTypeParameter)param;
                    String value = btParS.getValue().toString();
                    int numSubStrings = value.split(" ").length;
                    sb.append("\t Num Substrings: " + Integer.toString(numSubStrings)).append("\n");
                    sb.append("\t Value:" + value).append("\n");
                } else {
                    BasicTypeParameter btParB = (BasicTypeParameter)param;
                    sb.append("\t Value: " + btParB.getValue().toString()).append("\n");
                }
                ++i;
            }
            this.listener.jobFailed(this, Job.JobListener.JobEndStatus.SUBMISSION_FAILED);
        }
        sd.addAttribute("jobId", this.jobId);
        sd.addAttribute("walltime.max", ((MethodResourceDescription)method.getRequirements()).getWallClockLimit());
        if (((MethodResourceDescription)method.getRequirements()).getHostQueue().size() > 0) {
            sd.addAttribute("job.queue", ((MethodResourceDescription)method.getRequirements()).getHostQueue().get(0));
        }
        sd.addAttribute("coreCount", ((MethodResourceDescription)method.getRequirements()).getProcessorCoreCount());
        sd.addAttribute("memory.max", Float.valueOf(((MethodResourceDescription)method.getRequirements()).getMemoryPhysicalSize()));
        sd.addAttribute("sandbox.root", ((GATWorkerNode)this.getResourceNode()).getWorkingDir());
        sd.addAttribute("sandbox.useroot", "true");
        sd.addAttribute("sandbox.delete", "false");
        if (workerDebug.booleanValue()) {
            File outFile = GAT.createFile(this.context, "any:///" + JOBS_DIR + "job" + this.jobId + "_" + (Object)((Object)this.getHistory()) + ".out");
            sd.setStdout(outFile);
        }
        if (workerDebug.booleanValue() || this.usingGlobus) {
            File errFile = GAT.createFile(this.context, "any:///" + JOBS_DIR + "job" + this.jobId + "_" + (Object)((Object)this.getHistory()) + ".err");
            sd.setStderr(errFile);
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(RES_ATTR, ANY_PROT + targetUser + targetHost);
        attributes.put("Jobname", "compss_remote_job_" + this.jobId);
        HardwareResourceDescription rd = new HardwareResourceDescription(attributes);
        logger.debug("Ready to submit job " + this.jobId + ":");
        logger.debug("  * Host: " + targetHost);
        logger.debug("  * Executable: " + sd.getExecutable());
        StringBuilder sb = new StringBuilder("  - Arguments:");
        for (String arg : sd.getArguments()) {
            sb.append(" ").append(arg);
        }
        logger.debug(sb.toString());
        JobDescription jd = new JobDescription(sd, rd);
        return jd;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[[Job id: ").append(this.getJobId()).append("]");
        buffer.append(", ").append(this.taskParams.toString());
        buffer.append(", [Target host: ").append(((GATWorkerNode)this.getResourceNode()).getHost()).append("]");
        buffer.append(", [User: ").append(((GATWorkerNode)this.getResourceNode()).getUser()).append("]]");
        return buffer.toString();
    }

    @Override
    public String getHostName() {
        return ((GATWorkerNode)this.getResourceNode()).getName();
    }
}

