/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.nio;

import es.bsc.comm.Node;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class NIONode
implements Node,
Externalizable {
    public String ip;
    public int port;

    public NIONode() {
    }

    public NIONode(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    @Override
    public int compareTo(Node no) {
        if (no instanceof NIONode) {
            NIONode n = (NIONode)no;
            if (this.ip == null) {
                if (n.ip == null) {
                    return n.port - this.port;
                }
                return 1;
            }
            if (n.ip == null) {
                return -1;
            }
            int ipDiff = n.ip.compareTo(this.ip);
            if (ipDiff == 0) {
                return 0;
            }
            return n.port - this.port;
        }
        return no.getClass().getName().compareTo(this.getClass().getName());
    }

    public boolean equals(Object o) {
        if (o instanceof NIONode) {
            NIONode nn = (NIONode)o;
            if (this.ip == null) {
                return nn.ip == null && nn.port == this.port;
            }
            return nn.ip != null && nn.ip.compareTo(this.ip) == 0 && nn.port == this.port;
        }
        return false;
    }

    public int hashCode() {
        return (this.ip == null ? 0 : this.ip.hashCode()) + this.port;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.port);
        if (this.ip != null) {
            out.writeUTF(this.ip);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.port = in.readInt();
        if (in.available() > 0) {
            this.ip = in.readUTF();
        }
    }

    public String toString() {
        return this.ip + ":" + this.port;
    }
}

