/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.options;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.ec2.options.internal.BaseEC2RequestOptions;

public class RequestSpotInstancesOptions
extends BaseEC2RequestOptions {
    public static final RequestSpotInstancesOptions NONE = new RequestSpotInstancesOptions();
    private static final DateService service = new SimpleDateFormatDateService();

    public RequestSpotInstancesOptions validFrom(Date start) {
        this.formParameters.put("ValidFrom", service.iso8601SecondsDateFormat(Preconditions.checkNotNull(start, "start")));
        return this;
    }

    public RequestSpotInstancesOptions validUntil(Date end) {
        this.formParameters.put("ValidUntil", service.iso8601SecondsDateFormat(Preconditions.checkNotNull(end, "end")));
        return this;
    }

    public RequestSpotInstancesOptions type(SpotInstanceRequest.Type type) {
        this.formParameters.put("Type", Preconditions.checkNotNull(type, "type").toString());
        return this;
    }

    public RequestSpotInstancesOptions launchGroup(String launchGroup) {
        this.formParameters.put("LaunchGroup", Preconditions.checkNotNull(launchGroup, "launchGroup"));
        return this;
    }

    public RequestSpotInstancesOptions availabilityZoneGroup(String availabilityZoneGroup) {
        this.formParameters.put("AvailabilityZoneGroup", Preconditions.checkNotNull(availabilityZoneGroup, "availabilityZoneGroup"));
        return this;
    }

    public static class Builder {
        public static RequestSpotInstancesOptions validFrom(Date start) {
            RequestSpotInstancesOptions options = new RequestSpotInstancesOptions();
            return options.validFrom(start);
        }

        public static RequestSpotInstancesOptions validUntil(Date end) {
            RequestSpotInstancesOptions options = new RequestSpotInstancesOptions();
            return options.validUntil(end);
        }

        public static RequestSpotInstancesOptions type(SpotInstanceRequest.Type type) {
            RequestSpotInstancesOptions options = new RequestSpotInstancesOptions();
            return options.type(type);
        }

        public static RequestSpotInstancesOptions launchGroup(String launchGroup) {
            RequestSpotInstancesOptions options = new RequestSpotInstancesOptions();
            return options.launchGroup(launchGroup);
        }

        public static RequestSpotInstancesOptions availabilityZoneGroup(String availabilityZoneGroup) {
            RequestSpotInstancesOptions options = new RequestSpotInstancesOptions();
            return options.availabilityZoneGroup(availabilityZoneGroup);
        }
    }
}

