/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.compute.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped.DatacenterAndName;

public class AllNodesInGroupTerminated
implements Predicate<DatacenterAndName> {
    private final ComputeService computeService;

    @Inject
    public AllNodesInGroupTerminated(ComputeService computeService) {
        this.computeService = Preconditions.checkNotNull(computeService, "computeService");
    }

    @Override
    public boolean apply(DatacenterAndName input) {
        return Iterables.all(this.computeService.listNodesDetailsMatching(NodePredicates.locationId(input.getDatacenter())), Predicates.and(NodePredicates.inGroup(input.getName()), NodePredicates.TERMINATED));
    }
}

