/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.suppliers;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.joyent.cloudapi.v6_5.features.DatacenterApi;
import org.jclouds.location.predicates.fromconfig.AnyOrConfiguredZoneId;
import org.jclouds.location.suppliers.ZoneIdToURISupplier;
import org.jclouds.util.Suppliers2;

@Singleton
public class ZoneIdToURIFromDatacentersApi
implements ZoneIdToURISupplier {
    private final DatacenterApi api;
    private final AnyOrConfiguredZoneId filter;

    @Inject
    public ZoneIdToURIFromDatacentersApi(DatacenterApi api, AnyOrConfiguredZoneId filter) {
        this.api = api;
        this.filter = filter;
    }

    @Override
    public Map<String, Supplier<URI>> get() {
        return Maps.filterKeys(Maps.transformValues(this.api.getDatacenters(), Suppliers2.ofInstanceFunction()), this.filter);
    }

    public String toString() {
        return "getDatacenters()";
    }
}

