/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.rest.Binder;

@Singleton
public class NotesToJson
implements Binder {
    private final Json json;

    @Inject
    NotesToJson(Json json) {
        this.json = json;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(input instanceof String);
        String notes = (String)input;
        request.setPayload(this.buildJson(notes));
        return request;
    }

    private String buildJson(String notes) {
        return this.json.toJson(ImmutableMap.of("parameters", ImmutableList.of(ImmutableMap.of("notes", notes))));
    }
}

