/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.comm.Comm;
import integratedtoolkit.components.ResourceUser;
import integratedtoolkit.connectors.ConnectorException;
import integratedtoolkit.types.AdaptorDescription;
import integratedtoolkit.types.CloudImageDescription;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.ResourceCreationRequest;
import integratedtoolkit.types.ResourcesState;
import integratedtoolkit.types.resources.CloudMethodWorker;
import integratedtoolkit.types.resources.MethodResourceDescription;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.types.resources.ServiceResourceDescription;
import integratedtoolkit.types.resources.ServiceWorker;
import integratedtoolkit.types.resources.ShutdownListener;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import integratedtoolkit.util.CloudManager;
import integratedtoolkit.util.CoreManager;
import integratedtoolkit.util.ProjectManager;
import integratedtoolkit.util.ResourceOptimizer;
import integratedtoolkit.util.WorkerPool;
import integratedtoolkit.util.WorkerStarter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ResourceManager {
    protected static final String ERROR_UNKNOWN_HOST = "ERROR: Cannot determine the IP address of the local host";
    private static final String PROJ_LOAD_ERR = "Error loading project information";
    private static final String DEL_VM_ERR = "Error deleting VMs";
    private static Document resourcesDoc;
    private static WorkerPool pool;
    private static ResourceUser resourceUser;
    private static ResourceOptimizer ro;
    private static final Logger resourcesLogger;
    private static final Logger runtimeLogger;

    public static void load(ResourceUser resUser) throws Exception {
        pool = new WorkerPool(CoreManager.getCoreCount());
        if (!ProjectManager.isInit()) {
            try {
                ProjectManager.init();
            }
            catch (Exception e) {
                resourcesLogger.fatal((Object)PROJ_LOAD_ERR, (Throwable)e);
                runtimeLogger.fatal((Object)PROJ_LOAD_ERR, (Throwable)e);
                System.exit(1);
            }
        }
        CloudManager.initialize();
        resourceUser = resUser;
        String resourceFile = System.getProperty("it.resources.file");
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        resourcesDoc = docFactory.newDocumentBuilder().parse(resourceFile);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource schemaFile = new StreamSource(System.getProperty("it.resources.schema"));
        Schema schema = schemaFactory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        try {
            validator.validate(new DOMSource(resourcesDoc));
        }
        catch (SAXException e) {
            runtimeLogger.error((Object)"Error Validating resources.xml config file.\n", (Throwable)e);
            System.err.println("Error Validating resources.xml config file.\n" + e.getMessage());
        }
        catch (IOException e) {
            runtimeLogger.error((Object)"IOError while trying to validate resources.xml config file.\n", (Throwable)e);
            System.err.println("IOError while trying to validate resources.xml config file.\n" + e.getMessage());
        }
        validator.validate(new DOMSource(resourcesDoc));
        NodeList nl = resourcesDoc.getChildNodes().item(0).getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            int j;
            String name;
            Node n = nl.item(i);
            if (n.getNodeName().compareTo("Resource") == 0) {
                name = n.getAttributes().getNamedItem("Name").getTextContent();
                if (!ProjectManager.containsWorker(name)) continue;
                ResourceManager.loadMethodWorker(name, n);
                continue;
            }
            if (n.getNodeName().compareTo("Service") == 0) {
                name = n.getAttributes().getNamedItem("wsdl").getTextContent();
                if (!ProjectManager.containsWorker(name)) continue;
                try {
                    ResourceManager.loadService(name, n);
                }
                catch (Exception e) {
                    resourcesLogger.error((Object)("Could not load service " + name));
                }
                continue;
            }
            if (n.getNodeName().compareTo("CloudProvider") == 0) {
                String cloudProviderName = n.getAttributes().getNamedItem("name").getTextContent();
                if (!ProjectManager.existsCloudProvider(cloudProviderName)) {
                    runtimeLogger.debug((Object)("Provider " + cloudProviderName + " not in project.xml"));
                    continue;
                }
                ResourceManager.loadCloudProvider(cloudProviderName, n);
                continue;
            }
            if (n.getNodeName().compareTo("Disk") == 0) {
                String diskName = n.getAttributes().getNamedItem("Name").getTextContent();
                String mountPoint = "";
                for (j = 0; j < n.getChildNodes().getLength(); ++j) {
                    if (n.getChildNodes().item(j).getNodeName().compareTo("Name") == 0) {
                        diskName = n.getChildNodes().item(j).getTextContent();
                        continue;
                    }
                    if (n.getChildNodes().item(j).getNodeName().compareTo("MountPoint") != 0) continue;
                    mountPoint = n.getChildNodes().item(j).getTextContent();
                }
                Comm.addSharedDiskToMaster((String)diskName, (String)mountPoint);
                continue;
            }
            if (n.getNodeName().compareTo("DataNode") != 0) continue;
            String host = "";
            String path = "";
            for (j = 0; j < n.getChildNodes().getLength(); ++j) {
                if (n.getChildNodes().item(j).getNodeName().compareTo("Host") == 0) {
                    host = n.getChildNodes().item(j).getTextContent();
                    continue;
                }
                if (n.getChildNodes().item(j).getNodeName().compareTo("Path") != 0) continue;
                path = n.getChildNodes().item(j).getTextContent();
            }
            runtimeLogger.debug((Object)("DataNode: Host = " + host + " , Path = " + path));
        }
        ro = new ResourceOptimizer(resourceUser);
        ro.setName("Resource Optimizer");
        ro.start();
    }

    private static void loadMethodWorker(String name, Node n) throws Exception {
        MethodResourceDescription rd = new MethodResourceDescription(n);
        TreeMap<String, AdaptorDescription> resourceAdaptorsDesc = ResourceManager.parseAdaptors(n);
        TreeMap<String, AdaptorDescription> projectAdaptorsDesc = ProjectManager.parseAdaptors();
        TreeMap adaptorsDesc = AdaptorDescription.merge(projectAdaptorsDesc, resourceAdaptorsDesc);
        HashMap<String, String> properties = ProjectManager.getWorkerProperties(name);
        HashMap<String, String> sharedDisks = new HashMap<String, String>();
        for (int j = 0; j < n.getChildNodes().getLength(); ++j) {
            if (n.getChildNodes().item(j).getNodeName().compareTo("Disks") != 0) continue;
            Node disks = n.getChildNodes().item(j);
            for (int k = 0; k < disks.getChildNodes().getLength(); ++k) {
                if (disks.getChildNodes().item(k).getNodeName().compareTo("Disk") != 0) continue;
                Node disk = disks.getChildNodes().item(k);
                String diskName = disk.getAttributes().getNamedItem("Name").getTextContent();
                String diskMountpoint = "";
                for (int ki = 0; ki < disk.getChildNodes().getLength(); ++ki) {
                    if (disk.getChildNodes().item(ki).getNodeName().compareTo("MountPoint") != 0) continue;
                    diskMountpoint = disk.getChildNodes().item(ki).getTextContent();
                }
                sharedDisks.put(diskName, diskMountpoint);
            }
        }
        new Thread(new WorkerStarter(name, rd, properties, sharedDisks, adaptorsDesc)).start();
    }

    public static TreeMap<String, AdaptorDescription> parseAdaptors(Node n) {
        TreeMap<String, AdaptorDescription> adaptorsDesc = new TreeMap<String, AdaptorDescription>();
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            Node property = n.getChildNodes().item(i);
            if (!"Adaptors".equals(property.getNodeName())) continue;
            for (int j = 0; j < property.getChildNodes().getLength(); ++j) {
                Node adaptor = property.getChildNodes().item(j);
                if (!"Adaptor".equals(adaptor.getNodeName())) continue;
                int minPort = 0;
                int maxPort = -1;
                String brokerAdaptor = null;
                String adaptorName = adaptor.getAttributes().getNamedItem("name").getTextContent();
                block12: for (int k = 0; k < adaptor.getChildNodes().getLength(); ++k) {
                    switch (adaptor.getChildNodes().item(k).getNodeName()) {
                        case "MaxPort": {
                            maxPort = Integer.parseInt(adaptor.getChildNodes().item(k).getTextContent());
                            continue block12;
                        }
                        case "MinPort": {
                            minPort = Integer.parseInt(adaptor.getChildNodes().item(k).getTextContent());
                            continue block12;
                        }
                        case "BrokerAdaptor": {
                            brokerAdaptor = adaptor.getChildNodes().item(k).getTextContent();
                        }
                    }
                }
                runtimeLogger.debug((Object)("Adding adaptor description: " + adaptorName));
                adaptorsDesc.put(adaptorName, new AdaptorDescription(adaptorName, minPort, maxPort, brokerAdaptor));
            }
        }
        return adaptorsDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadService(String name, Node n) throws Exception {
        String serviceName = "";
        String namespace = "";
        String portName = "";
        for (int j = 0; j < n.getChildNodes().getLength(); ++j) {
            if (n.getChildNodes().item(j).getNodeName().compareTo("Name") == 0) {
                serviceName = n.getChildNodes().item(j).getTextContent();
            }
            if (n.getChildNodes().item(j).getNodeName().compareTo("Namespace") == 0) {
                namespace = n.getChildNodes().item(j).getTextContent();
            }
            if (n.getChildNodes().item(j).getNodeName().compareTo("Port") != 0) continue;
            portName = n.getChildNodes().item(j).getTextContent();
        }
        HashMap<String, String> properties = ProjectManager.getWorkerProperties(name);
        String taskCountStr = properties.get("LimitOfTasks");
        int taskCount = 0;
        if (taskCountStr != null) {
            taskCount = Integer.parseInt(taskCountStr);
        }
        if (taskCount > 0) {
            HashMap<String, String> wsProperties = new HashMap<String, String>();
            wsProperties.put("wsdl", name);
            wsProperties.put("name", serviceName);
            wsProperties.put("namespace", namespace);
            wsProperties.put("port", portName);
            ServiceResourceDescription description = new ServiceResourceDescription(serviceName, namespace, portName);
            ServiceWorker newResource = new ServiceWorker(name, description, wsProperties, (Integer)taskCount);
            newResource.updatedFeatures();
            WorkerPool workerPool = pool;
            synchronized (workerPool) {
                pool.addResourceLinks(newResource);
                pool.defineCriticalSet();
            }
            resourceUser.createdResources(newResource);
            resourcesLogger.info((Object)("TIMESTAMP = " + String.valueOf(System.currentTimeMillis())));
            resourcesLogger.info((Object)("INFO_MSG = [New service available. Name = " + newResource.getName() + "]"));
        }
    }

    private static void loadCloudProvider(String name, Node n) throws Exception {
        String connectorPath = "";
        runtimeLogger.info((Object)("Loading Provider " + name));
        HashMap<String, String> h = new HashMap<String, String>();
        h.put("estimated-creation-time", "60");
        HashMap<String, String> properties = ProjectManager.getCloudProviderProperties(name);
        for (Map.Entry<String, String> e : properties.entrySet()) {
            h.put(e.getKey(), e.getValue());
        }
        LinkedList<CloudImageDescription> images = new LinkedList<CloudImageDescription>();
        LinkedList<CloudMethodResourceDescription> instanceTypes = new LinkedList<CloudMethodResourceDescription>();
        for (int ki = 0; ki < n.getChildNodes().getLength(); ++ki) {
            int image;
            if (n.getChildNodes().item(ki).getNodeName().compareTo("#text") == 0) continue;
            if (n.getChildNodes().item(ki).getNodeName().compareTo("Connector") == 0) {
                connectorPath = n.getChildNodes().item(ki).getTextContent();
                continue;
            }
            if (n.getChildNodes().item(ki).getNodeName().compareTo("ImageList") == 0) {
                Node imageList = n.getChildNodes().item(ki);
                for (image = 0; image < imageList.getChildNodes().getLength(); ++image) {
                    Node resourcesImageNode = imageList.getChildNodes().item(image);
                    if (resourcesImageNode.getNodeName().compareTo("Image") != 0) continue;
                    String imageName = resourcesImageNode.getAttributes().getNamedItem("name").getTextContent();
                    Node projectImageNode = ProjectManager.existsImageOnProvider(name, imageName);
                    if (projectImageNode != null) {
                        CloudImageDescription cid = new CloudImageDescription(name, resourcesImageNode, projectImageNode, h);
                        resourcesLogger.info((Object)("CLOUD_IMAGE_DESCRIPTION = [\n" + cid.toString("\t") + "]"));
                        images.add(cid);
                        continue;
                    }
                    runtimeLogger.debug((Object)("Image " + name + " not found in project.xml"));
                }
                continue;
            }
            if (n.getChildNodes().item(ki).getNodeName().compareTo("InstanceTypes") == 0) {
                Node instanceTypesList = n.getChildNodes().item(ki);
                for (image = 0; image < instanceTypesList.getChildNodes().getLength(); ++image) {
                    Node resourcesInstanceTypeNode = instanceTypesList.getChildNodes().item(image);
                    if (resourcesInstanceTypeNode.getNodeName().compareTo("Resource") != 0) continue;
                    String instanceCode = resourcesInstanceTypeNode.getAttributes().getNamedItem("Name").getTextContent();
                    Node projectTypeNode = ProjectManager.existsInstanceTypeOnProvider(name, instanceCode);
                    if (projectTypeNode != null) {
                        CloudMethodResourceDescription rd = new CloudMethodResourceDescription(resourcesInstanceTypeNode);
                        instanceTypes.add(rd);
                        continue;
                    }
                    runtimeLogger.debug((Object)("InstanceType " + name + " not found in project.xml"));
                }
                continue;
            }
            if (n.getChildNodes().item(ki).getNodeName().compareTo("CreationTime") == 0) {
                h.remove("estimated-creation-time");
                continue;
            }
            h.put(n.getChildNodes().item(ki).getNodeName(), n.getChildNodes().item(ki).getTextContent());
        }
        runtimeLogger.debug((Object)("Adding Provider " + name));
        CloudManager.newCloudProvider(name, ProjectManager.getCloudProviderLimitOfVMs(name), connectorPath, h);
        try {
            for (CloudImageDescription cid : images) {
                CloudManager.addImageToProvider(name, cid);
            }
            for (CloudMethodResourceDescription instance : instanceTypes) {
                CloudManager.addInstanceTypeToProvider(name, instance);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        CloudManager.setUseCloud(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void coreElementUpdates(LinkedList<Integer> updatedCores) {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            pool.coreElementUpdates(updatedCores);
            CloudManager.newCoreElementsDetected(updatedCores);
        }
    }

    public static Worker<?> getWorker(String name) {
        return pool.getResource(name);
    }

    public static List<Worker<?>> getAllWorkers() {
        return pool.findAllResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStaticWorker(Worker<?> worker) {
        worker.updatedFeatures();
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            pool.addStaticResource(worker);
            pool.addResourceLinks(worker);
        }
        resourceUser.createdResources(worker);
        resourcesLogger.info((Object)("TIMESTAMP = " + String.valueOf(System.currentTimeMillis())));
        resourcesLogger.info((Object)("INFO_MSG = [New resource available in the pool. Name = " + worker.getName() + "]"));
        runtimeLogger.info((Object)("New resource available in the pool. Name = " + worker.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCloudWorker(ResourceCreationRequest origin, CloudMethodWorker worker) {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            pool.addDynamicResource(worker);
            CloudManager.confirmedRequest(origin, worker);
        }
        worker.updatedFeatures();
        workerPool = pool;
        synchronized (workerPool) {
            pool.addResourceLinks(worker);
            pool.defineCriticalSet();
        }
        resourceUser.createdResources(worker);
        resourcesLogger.info((Object)("TIMESTAMP = " + String.valueOf(System.currentTimeMillis())));
        resourcesLogger.info((Object)("INFO_MSG = [New resource available in the pool. Name = " + worker.getName() + "]"));
        runtimeLogger.info((Object)("New resource available in the pool. Name = " + worker.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void increasedCloudWorker(ResourceCreationRequest origin, CloudMethodWorker worker, CloudMethodResourceDescription extension) {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            pool.removeResourceLinks(worker);
            CloudManager.confirmedRequest(origin, worker);
            worker.increaseFeatures(extension);
            pool.addResourceLinks(worker);
            pool.defineCriticalSet();
        }
        resourceUser.createdResources(worker);
        resourcesLogger.info((Object)("TIMESTAMP = " + String.valueOf(System.currentTimeMillis())));
        resourcesLogger.info((Object)("INFO_MSG = [Resource modified. Name = " + worker.getName() + "]"));
        runtimeLogger.info((Object)("Resource modified. Name = " + worker.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Semaphore reduceCloudWorker(CloudMethodWorker worker, CloudMethodResourceDescription reduction) {
        Semaphore sem;
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            pool.removeResourceLinks(worker);
            sem = worker.reduceFeatures(reduction);
            pool.addResourceLinks(worker);
            pool.defineCriticalSet();
        }
        resourceUser.createdResources(worker);
        resourcesLogger.info((Object)("TIMESTAMP = " + String.valueOf(System.currentTimeMillis())));
        resourcesLogger.info((Object)("INFO_MSG = [Resource removed from the pool. Name = " + worker.getName() + "]"));
        runtimeLogger.info((Object)("Resource removed from the pool. Name = " + worker.getName()));
        return sem;
    }

    public static int[] getTotalSlots() {
        int[] counts = new int[CoreManager.getCoreCount()];
        int[] poolCounts = pool.getCoreMaxTaskCount();
        int[] starterCount = WorkerStarter.getExpectedCoreCount();
        int[] cloudCount = CloudManager.getPendingCoreCounts();
        for (int i = 0; i < counts.length; ++i) {
            counts[i] = poolCounts[i] + starterCount[i] + cloudCount[i];
        }
        return counts;
    }

    public static int[] getAvailableSlots() {
        return pool.getCoreMaxTaskCount();
    }

    public static Collection<Worker<?>> getStaticResources() {
        return pool.getStaticResources();
    }

    public static LinkedList<CloudMethodWorker> getDynamicResources() {
        return pool.getDynamicResources();
    }

    public static Collection<CloudMethodWorker> getCriticalDynamicResources() {
        return pool.getCriticalResources();
    }

    public static Collection<CloudMethodWorker> getNonCriticalDynamicResources() {
        return pool.getNonCriticalResources();
    }

    public static CloudMethodWorker getDynamicResource(String name) {
        return pool.getDynamicResource(name);
    }

    public static void refuseCloudRequest(ResourceCreationRequest rcr) {
        CloudManager.refusedRequest(rcr);
    }

    public static LinkedList<Worker<?>> findCompatibleWorkers(int coreId) {
        return pool.findCompatibleResources(coreId);
    }

    public static HashMap<Worker<?>, LinkedList<Implementation<?>>> findAvailableWorkers(LinkedList<Worker<?>> compatibleWorkers, int coreId) {
        HashMap available = new HashMap();
        for (Worker worker : compatibleWorkers) {
            LinkedList<Implementation> availableImpls = new LinkedList<Implementation>();
            LinkedList<Implementation<?>> compatibleImpls = worker.getExecutableImpls(coreId);
            for (Implementation implementation : compatibleImpls) {
                if (!worker.canRunNow(implementation.getRequirements())) continue;
                availableImpls.add(implementation);
            }
            if (availableImpls.isEmpty()) continue;
            available.put(worker, availableImpls);
        }
        return available;
    }

    public static ResourcesState getResourcesState() {
        ResourcesState state = new ResourcesState();
        for (Worker<?> resource : ResourceManager.getAllWorkers()) {
            if (resource.getType().equals((Object)Resource.Type.WORKER)) {
                int cores = ((MethodResourceDescription)resource.getDescription()).getProcessorCoreCount();
                float memory = ((MethodResourceDescription)resource.getDescription()).getMemoryPhysicalSize();
                state.addHost(resource.getName(), resource.getType().toString(), cores, memory, resource.getSimultaneousTasks(), true);
                continue;
            }
            state.addHost(resource.getName(), resource.getType().toString(), 0, 0.0f, resource.getSimultaneousTasks(), true);
        }
        state.setUseCloud(CloudManager.isUseCloud());
        if (state.getUseCloud()) {
            try {
                state.setCreationTime(CloudManager.getNextCreationTime());
            }
            catch (Exception ex) {
                state.setCreationTime(120000L);
            }
            state.setCurrentCloudVMCount(CloudManager.getCurrentVMCount());
            for (ResourceCreationRequest rcr : CloudManager.getPendingRequests()) {
                int[][] simTasks = rcr.requestedSimultaneousTaskCount();
                for (int coreId = 0; coreId < simTasks.length; ++coreId) {
                    int coreSlots = 0;
                    for (int implId = 0; implId < simTasks[coreId].length; ++implId) {
                        coreSlots += Math.max(coreSlots, simTasks[coreId][implId]);
                    }
                    state.updateHostInfo(rcr.getRequested().getName(), rcr.getRequested().getType(), rcr.getRequested().getProcessorCoreCount(), rcr.getRequested().getMemoryPhysicalSize(), coreId, coreSlots, false);
                }
            }
        }
        return state;
    }

    public static String getPendingRequestsMonitorData(String prefix) {
        StringBuilder sb = new StringBuilder();
        LinkedList<ResourceCreationRequest> rcr = CloudManager.getPendingRequests();
        for (ResourceCreationRequest r : rcr) {
            sb.append(prefix).append("<Resource id=\"" + r.getRequested().getName() + "\">").append("\n");
            sb.append(prefix + "\t").append("<CPU>").append(r.getRequested().getProcessorCPUCount()).append("</CPU>").append("\n");
            sb.append(prefix + "\t").append("<Core>").append(r.getRequested().getProcessorCoreCount()).append("</Core>").append("\n");
            sb.append(prefix + "\t").append("<Memory>").append(r.getRequested().getMemoryPhysicalSize()).append("</Memory>").append("\n");
            sb.append(prefix + "\t").append("<Disk>").append(r.getRequested().getStorageElemSize()).append("</Disk>").append("\n");
            sb.append(prefix + "\t").append("<Provider>").append(r.getProvider()).append("</Provider>").append("\n");
            sb.append(prefix + "\t").append("<Image>").append(r.getRequested().getImage()).append("</Image>").append("\n");
            sb.append(prefix + "\t").append("<Status>").append("Creating").append("</Status>").append("\n");
            sb.append(prefix + "\t").append("<Tasks>").append("</Tasks>").append("\n");
            sb.append(prefix).append("</Resource>").append("\n");
        }
        return sb.toString();
    }

    public static void printLoadInfo() {
        resourcesLogger.info((Object)resourceUser.getWorkload().toString());
    }

    public static void printResourcesState() {
        resourcesLogger.info((Object)("TIMESTAMP = " + String.valueOf(System.currentTimeMillis())));
        resourcesLogger.info((Object)ResourceManager.getResourcesState().toString());
    }

    public static Long getCreationTime() throws Exception {
        try {
            return CloudManager.getNextCreationTime();
        }
        catch (ConnectorException e) {
            throw new Exception(e);
        }
    }

    public static void stopNodes(ResourceUser.WorkloadStatus status) {
        resourcesLogger.info((Object)("TIMESTAMP = " + String.valueOf(System.currentTimeMillis())));
        resourcesLogger.info((Object)"INFO_MSG = [Stopping all workers]");
        runtimeLogger.info((Object)"Stopping all workers");
        if (ro != null) {
            ro.shutdown(status);
        } else {
            runtimeLogger.info((Object)"Resource Optimizer was not initialized");
        }
        if (CloudManager.isUseCloud()) {
            resourcesLogger.debug((Object)"DEBUG_MSG = [Terminating cloud instances...]");
            try {
                CloudManager.terminateALL();
                resourcesLogger.info((Object)("TOTAL_EXEC_COST = " + CloudManager.getTotalCost()));
            }
            catch (Exception e) {
                resourcesLogger.error((Object)"Task Scheduler: Error deleting VMs", (Throwable)e);
            }
            resourcesLogger.info((Object)"INFO_MSG = [Cloud instances terminated]");
        }
        if (pool != null && !pool.getStaticResources().isEmpty()) {
            Semaphore sem = new Semaphore(0);
            ShutdownListener sl = new ShutdownListener(sem);
            resourcesLogger.debug((Object)"DEBUG_MSG = [Resource Manager stopping workers...]");
            for (Worker<?> r : pool.getStaticResources()) {
                r.stop(false, sl);
            }
            resourcesLogger.debug((Object)"DEBUG_MSG = [Waiting for workers to shutdown...]");
            sl.enable();
            try {
                sem.acquire();
            }
            catch (Exception e) {
                resourcesLogger.error((Object)"ERROR_MSG= [ERROR: Exception raised on worker shutdown]");
            }
            resourcesLogger.info((Object)"INFO_MSG = [Workers stopped]");
        }
    }

    public static boolean useCloud() {
        return CloudManager.isUseCloud();
    }

    public static float getCurrentCostPerHour() {
        return CloudManager.currentCostPerHour();
    }

    public static float getTotalCost() {
        return CloudManager.getTotalCost();
    }

    public static String getCurrentState(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("TIMESTAMP = ").append(String.valueOf(System.currentTimeMillis())).append("\n");
        sb.append(pool.getCurrentState(prefix)).append("\n");
        sb.append(CloudManager.getCurrentState(prefix));
        return sb.toString();
    }

    static {
        resourcesLogger = Logger.getLogger((String)"integratedtoolkit.Resources");
        runtimeLogger = Logger.getLogger((String)"integratedtoolkit.Components.ResourceManager");
    }
}

