/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.connectors.vmm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

class VMTemplate {
    private static final String IMAGE_TAG = "IMAGE";
    private static final String CONTEXT_TAG = "CONTEXT";
    private static final String PUBKEY_TAG = "SSH_PUBLIC_KEY";
    private static final String TEMPLATE_TAG = "TEMPLATE";
    private static final String DISK_TAG = "DISK";
    private Document template;

    VMTemplate(String temp) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.template = db.parse(new ByteArrayInputStream(temp.getBytes()));
    }

    String getString() throws ClassCastException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        DOMImplementationRegistry reg = DOMImplementationRegistry.newInstance();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)reg.getDOMImplementation("LS"));
        LSSerializer serializer = impl.createLSSerializer();
        serializer.getDomConfig().setParameter("xml-declaration", false);
        return serializer.writeToString(this.template.getElementsByTagName(TEMPLATE_TAG).item(0));
    }

    void setImage(String name) {
        Element e = this.template.getDocumentElement();
        Node tempNode = e.getElementsByTagName(TEMPLATE_TAG).item(0);
        Node firstDisk = e.getElementsByTagName(DISK_TAG).item(0);
        Element disk = this.template.createElement(DISK_TAG);
        Element image = this.template.createElement(IMAGE_TAG);
        CDATASection cdata = this.template.createCDATASection(name);
        image.appendChild(cdata);
        disk.appendChild(image);
        tempNode.insertBefore(disk, firstDisk);
    }

    void setPublicKey(String key) {
        Element e = this.template.getDocumentElement();
        NodeList nl = e.getElementsByTagName(CONTEXT_TAG);
        Element pub = this.template.createElement(PUBKEY_TAG);
        CDATASection cdata = this.template.createCDATASection(key);
        pub.appendChild(cdata);
        if (e.getElementsByTagName(PUBKEY_TAG).getLength() > 0) {
            Node oldpub = e.getElementsByTagName(PUBKEY_TAG).item(0);
            nl.item(0).replaceChild(pub, oldpub);
        } else {
            nl.item(0).appendChild(pub);
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

