/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.local;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.Map;
import org.gridlab.gat.AdaptorNotApplicableException;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.cpi.RandomAccessFileCpi;

public class LocalRandomAccessFileAdaptor
extends RandomAccessFileCpi {
    RandomAccessFile rf;

    public static String getDescription() {
        return "The Local RandomAccessFile Adaptor is a simple wrapper around the java.io.RandomAccessFile object.";
    }

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = RandomAccessFileCpi.getSupportedCapabilities();
        capabilities.put("close", true);
        capabilities.put("getFilePointer", true);
        capabilities.put("length", true);
        capabilities.put("read", true);
        capabilities.put("seek", true);
        capabilities.put("setLength", true);
        capabilities.put("skipBytes", true);
        capabilities.put("write", true);
        return capabilities;
    }

    public static String[] getSupportedSchemes() {
        return new String[]{"local", "file", ""};
    }

    public LocalRandomAccessFileAdaptor(GATContext gatContext, URI location, String mode) throws GATObjectCreationException {
        super(gatContext, location, mode);
        if (!location.refersToLocalHost()) {
            throw new AdaptorNotApplicableException("Cannot use remote files with the local random access file adaptor");
        }
        try {
            this.rf = new RandomAccessFile(new File(location.getPath()), mode);
        }
        catch (FileNotFoundException e) {
            throw new GATObjectCreationException("LocalRandomAccessFile", (Throwable)e);
        }
    }

    public void close() throws GATInvocationException {
        try {
            this.rf.close();
        }
        catch (Exception e) {
            throw new GATInvocationException("LocalRandomAccessFile", (Throwable)e);
        }
    }

    public long getFilePointer() throws GATInvocationException {
        try {
            return this.rf.getFilePointer();
        }
        catch (Exception e) {
            throw new GATInvocationException("LocalRandomAccessFile", (Throwable)e);
        }
    }

    public long length() throws GATInvocationException {
        try {
            return this.rf.length();
        }
        catch (Exception e) {
            throw new GATInvocationException("LocalRandomAccessFile", (Throwable)e);
        }
    }

    public int read() throws GATInvocationException {
        try {
            return this.rf.read();
        }
        catch (Exception e) {
            throw new GATInvocationException("LocalRandomAccessFile", (Throwable)e);
        }
    }

    public int read(byte[] arg0, int arg1, int arg2) throws GATInvocationException {
        try {
            return this.rf.read(arg0, arg1, arg2);
        }
        catch (Exception e) {
            throw new GATInvocationException("LocalRandomAccessFile", (Throwable)e);
        }
    }

    public int read(byte[] arg0) throws GATInvocationException {
        try {
            return this.rf.read(arg0);
        }
        catch (Exception e) {
            throw new GATInvocationException("LocalRandomAccessFile", (Throwable)e);
        }
    }

    public void seek(long arg0) throws GATInvocationException {
        try {
            this.rf.seek(arg0);
        }
        catch (Exception e) {
            throw new GATInvocationException("LocalRandomAccessFile", (Throwable)e);
        }
    }

    public void setLength(long arg0) throws GATInvocationException {
        try {
            this.rf.setLength(arg0);
        }
        catch (Exception e) {
            throw new GATInvocationException("LocalRandomAccessFile", (Throwable)e);
        }
    }

    public int skipBytes(int arg0) throws GATInvocationException {
        try {
            return this.rf.skipBytes(arg0);
        }
        catch (Exception e) {
            throw new GATInvocationException("LocalRandomAccessFile", (Throwable)e);
        }
    }

    public void write(byte[] arg0, int arg1, int arg2) throws GATInvocationException {
        try {
            this.rf.write(arg0, arg1, arg2);
        }
        catch (Exception e) {
            throw new GATInvocationException("LocalRandomAccessFile", (Throwable)e);
        }
    }

    public void write(byte[] arg0) throws GATInvocationException {
        try {
            this.rf.write(arg0);
        }
        catch (Exception e) {
            throw new GATInvocationException("LocalRandomAccessFile", (Throwable)e);
        }
    }

    public void write(int arg0) throws GATInvocationException {
        try {
            this.rf.write(arg0);
        }
        catch (Exception e) {
            throw new GATInvocationException("LocalRandomAccessFile", (Throwable)e);
        }
    }
}

