import sys
import os.path
import atexit
from xml.dom.minidom import parse
import ctypes 
from ctypes import cdll

USRFUNC_EV = 60000100

Initialized = False
Traced_Functions = [] 
Number_of_Traced_Functions = 0

### Called when a profiling event triggers
def pyEx_trace_hook(frame, event, arg):
  if ((event == "call") or (event == "c_call") or (event == "return") or (event == "c_return")):
    function = frame.f_code.co_name
    if function and Traced_Functions and function in Traced_Functions:   
#      print "EV:", event, "; FUNC:", frame.f_code.co_name, "; LINE:", frame.f_lineno, "; FILE:", frame.f_code.co_filename #, "; ARG:", arg
#
#      caller = frame.f_back
#      if caller:
#        caller_line_no  = caller.f_lineno
#        caller_filename = caller.f_code.co_filename
#        print "-> called from "+caller_filename+" line "+str(caller_line_no);

       ### Get the function identifier
       function_id = Traced_Functions.index(function) + 1
       if ((event == "return") or (event == "c_return")):
         function_id = 0

       ### Emit an event into the trace
       Extrae.Extrae_eventandcounters( USRFUNC_EV, function_id )

### Called when the program terminates
def pyEx_fini():
  if Initialized:
    if (Number_of_Traced_Functions > 0):
      ### Emit the user functions information to the PCF file

      nvalues = len(Traced_Functions)+1
      description = "User functions"
      values = (ctypes.c_ulonglong * nvalues)()
      description_values = (ctypes.c_char_p * nvalues)()
      values[0] = 0
      description_values[0] = "End"
      for i in range(1, nvalues):
        values[i] = i
        description_values[i] = Traced_Functions[i-1]

      Extrae.Extrae_define_event_type( ctypes.pointer(ctypes.c_uint(USRFUNC_EV)),
                                       ctypes.c_char_p(description),
                                       ctypes.pointer(ctypes.c_uint(nvalues)),
                                       ctypes.pointer(values),
                                       ctypes.pointer(description_values) )
    ### Finalize the tracing library
    Extrae.Extrae_fini()

##########################
###        MAIN        ###
##########################

### Check the environment variables for the Extrae configuration

config_file = os.getenv('EXTRAE_CONFIG_FILE')

if not config_file:
  sys.stderr.write('pyextrae: WARNING! You have to provide a configuration file setting the EXTRAE_CONFIG_FILE environment variable\n');
else:
  if not os.path.isfile( config_file ):
    sys.stderr.write('pyextrae: ERROR! Can\'t find configuration file \''+config_file+'\'\n');
    sys.exit(1)

### Load the sequential tracing library
Extrae = cdll.LoadLibrary('/opt/COMPSs/Dependencies/extrae/lib/libseqtrace.so')
#Extrae.Extrae_init() ### Extrae_init() is called automatically in the sequential library when is preloaded
Initialized = True

### Register an exit handler to close the tracing library
atexit.register(pyEx_fini)

### Parse the configuration file to look for the user-functions configuration

if config_file:
  doc       = parse(config_file)
  xml_UF    = doc.getElementsByTagName('user-functions')
  enabled   = xml_UF[0].getAttributeNode('enabled')
  func_list = xml_UF[0].getAttributeNode('list')

  ### Check if the user-functions section is enabled and a list is provided
  if enabled and str.lower(str(enabled.nodeValue)) == "yes" and func_list and os.path.isfile( func_list.nodeValue ):
  
    ### Load the functions to trace from the list
    Traced_Functions = [line.strip() for line in open(func_list.nodeValue)]
    Number_of_Traced_Functions = len(Traced_Functions)

    if (Number_of_Traced_Functions > 0):
      ### Install the tracing hook if there's functions to trace
      sys.setprofile( pyEx_trace_hook )


#############################
###  EXTRAE API WRAPPERS  ###
#############################

def event(type, value):
  Extrae.Extrae_event(type, value)

def eventandcounters(type, value):
  Extrae.Extrae_eventandcounters(type, value)

