/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.clients.mesos.framework;

import es.bsc.conn.clients.mesos.framework.MesosOffer;
import es.bsc.conn.clients.mesos.framework.MesosTask;
import es.bsc.conn.clients.mesos.framework.exceptions.FrameworkException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.mesos.Protos;
import org.apache.mesos.Scheduler;
import org.apache.mesos.SchedulerDriver;

public class MesosFrameworkScheduler
implements Scheduler {
    private static final String EMPTY = "";
    private static final String UNDEFINED_IP = "-1.-1.-1.-1";
    private static final int MAX_LAUNCH_RETRIES = 3;
    private static final String CPUS_RESOURCE = "cpus";
    private static final String MEM_RESOURCE = "mem";
    private static final String DISK_RESOURCE = "disk";
    private static final String PORTS_RESOURCE = "ports";
    private static final String DOCKER_COMMAND = "/usr/sbin/sshd -D";
    private static final String WORKER_NAME = "Worker";
    private static final Logger LOGGER = LogManager.getLogger("integratedtoolkit.Connectors.Conn.Clients.Mesos.Scheduler");
    private static final String ERROR_TASK_ID = "ERROR: Task does not exist. TaskId = ";
    private final AtomicInteger taskIdGenerator = new AtomicInteger();
    private Protos.FrameworkID frameworkId;
    private Semaphore registerSem;
    private final List<String> runningTasks;
    private final List<String> pendingTasks;
    private final Map<String, MesosTask> tasks;
    private String dockerImage;
    private Protos.ContainerInfo.DockerInfo.Network dockerNetworkType = Protos.ContainerInfo.DockerInfo.Network.BRIDGE;
    private String dockerNetworkName = "";
    private boolean useCustomDockerNetwork = false;

    public MesosFrameworkScheduler() {
        LOGGER.debug("Initialize " + this.getClass().getName());
        this.runningTasks = Collections.synchronizedList(new LinkedList());
        this.pendingTasks = Collections.synchronizedList(new LinkedList());
        this.tasks = Collections.synchronizedMap(new HashMap());
    }

    public String getFrameworkId() {
        return this.frameworkId == null ? EMPTY : this.frameworkId.getValue();
    }

    public void useDockerNetwork(String networkName) {
        this.useCustomDockerNetwork = true;
        this.dockerNetworkType = Protos.ContainerInfo.DockerInfo.Network.USER;
        this.dockerNetworkName = networkName;
    }

    public synchronized String generateWorkerId(String appName) {
        return appName + "-" + WORKER_NAME + "-" + Integer.toString(this.taskIdGenerator.incrementAndGet()) + "-" + this.frameworkId.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String requestWorker(SchedulerDriver driver, String appName, String imageName, List<Protos.Resource> resources) {
        LOGGER.debug("Requested worker");
        String newWorkerId = this.generateWorkerId(appName);
        MesosFrameworkScheduler mesosFrameworkScheduler = this;
        synchronized (mesosFrameworkScheduler) {
            this.pendingTasks.add(newWorkerId);
            this.tasks.put(newWorkerId, new MesosTask(newWorkerId, imageName, Protos.TaskState.TASK_STAGING, resources));
            driver.reviveOffers();
        }
        return newWorkerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTask(String id, Protos.TaskState state, long timeout, TimeUnit unit) throws FrameworkException {
        Semaphore sem = new Semaphore(0);
        Map<String, MesosTask> map = this.tasks;
        synchronized (map) {
            if (!this.tasks.containsKey(id)) {
                throw new FrameworkException(ERROR_TASK_ID + id);
            }
            if (this.tasks.get(id).getState() == state) {
                return;
            }
            this.tasks.get(id).addWait(state, sem);
        }
        LOGGER.debug("Waiting task " + id + " " + timeout + " " + unit.toString() + " to change state to " + state.toString());
        boolean acquired = this.acquireSem(sem, timeout, unit);
        Map<String, MesosTask> map2 = this.tasks;
        synchronized (map2) {
            if (!this.tasks.containsKey(id)) {
                throw new FrameworkException(ERROR_TASK_ID + id);
            }
            if (this.tasks.get(id).getState() != state || !acquired) {
                this.pendingTasks.remove(id);
                this.runningTasks.remove(id);
                this.tasks.remove(id);
                throw new FrameworkException("Timeout waiting task " + id + " to change to " + state.toString());
            }
        }
    }

    public void waitRegistration() {
        LOGGER.debug("Wait for framework to register");
        if (this.frameworkId != null) {
            this.releaseRegisterSem();
        } else {
            this.registerSem = new Semaphore(0);
            this.acquireSem(this.registerSem);
        }
    }

    public void waitRegistration(long timeout, TimeUnit unit) throws FrameworkException {
        LOGGER.debug("Wait for framework to register " + timeout + " " + unit.toString());
        if (this.frameworkId != null) {
            this.releaseRegisterSem();
        } else {
            this.registerSem = new Semaphore(0);
            boolean acquired = this.acquireSem(this.registerSem, timeout, unit);
            if (this.frameworkId == null || !acquired) {
                throw new FrameworkException("Could not register framework. Check that Mesos master IP is correct.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(SchedulerDriver driver, String id, long timeout, TimeUnit unit) throws FrameworkException {
        MesosFrameworkScheduler mesosFrameworkScheduler = this;
        synchronized (mesosFrameworkScheduler) {
            if (this.pendingTasks.contains(id)) {
                this.pendingTasks.remove(id);
                return;
            }
            if (!this.tasks.containsKey(id)) {
                this.runningTasks.remove(id);
                throw new FrameworkException(ERROR_TASK_ID + id);
            }
        }
        driver.killTask(Protos.TaskID.newBuilder().setValue(id).build());
        this.waitTask(id, Protos.TaskState.TASK_KILLED, timeout, unit);
        this.tasks.remove(id);
    }

    @Override
    public synchronized void resourceOffers(SchedulerDriver driver, List<Protos.Offer> offers) {
        LOGGER.info(String.format("Received %d offers", offers.size()));
        List<Protos.OfferID> unusedOffers = this.getOfferIdList(offers);
        if (this.pendingTasks.isEmpty()) {
            LOGGER.info("Empty worker requests queue");
            this.declineOffers(driver, unusedOffers);
            driver.suppressOffers();
            return;
        }
        List<MesosOffer> processedOffers = this.processOffers(offers);
        for (int n = 0; n < this.pendingTasks.size(); ++n) {
            String id = this.pendingTasks.get(n);
            if (!this.tasks.containsKey(id)) {
                LOGGER.warn("No such id exists: " + id);
                continue;
            }
            MesosTask mesosTask = this.tasks.get(id);
            MesosOffer requirements = new MesosOffer(mesosTask.getRequirements());
            int index = this.bestFit(requirements, processedOffers);
            if (index == -1) {
                LOGGER.debug("Request does not fit: " + requirements.toString());
                continue;
            }
            MesosOffer offer = processedOffers.get(index);
            Protos.TaskInfo task = this.getTaskInfo(id, mesosTask.getImageName(), requirements, offer);
            Protos.OfferID offerId = offer.getOffer().getId();
            this.launchTask(driver, offer.getOffer(), task);
            LOGGER.info("Launching task " + id + " in offer " + offerId);
            unusedOffers.remove(offerId);
            offer.removeResourcesFrom(requirements);
            this.pendingTasks.remove(n);
        }
        this.declineOffers(driver, unusedOffers);
    }

    @Override
    public void offerRescinded(SchedulerDriver driver, Protos.OfferID offerId) {
        LOGGER.debug("Offer rescined: " + offerId.getValue());
    }

    public synchronized String getTaskIp(String id) {
        if (this.tasks.containsKey(id)) {
            LOGGER.info(String.format("IP %s assigned for task %s", this.tasks.get(id).getIp(), id));
            return this.tasks.get(id).getIp();
        }
        return UNDEFINED_IP;
    }

    @Override
    public synchronized void statusUpdate(SchedulerDriver driver, Protos.TaskStatus status) {
        String id = status.getTaskId().getValue();
        Protos.TaskState state = status.getState();
        LOGGER.debug(String.format("Status update: task %s is in state %s. Reason: %s Message: %s", id, state, status.getReason().getNumber(), status.getMessage()));
        if (!this.tasks.containsKey(id)) {
            LOGGER.warn("No such id exists: " + id);
            return;
        }
        MesosTask mt = this.tasks.get(id);
        this.getIpAddress(status);
        mt.setState(state);
        switch (state) {
            case TASK_LOST: 
            case TASK_ERROR: 
            case TASK_FAILED: {
                LOGGER.warn(id + " Task failed! adding to pending");
                mt.incrementRetries();
                if (mt.getRetries() < 3) {
                    this.runningTasks.remove(id);
                    this.pendingTasks.add(id);
                    driver.reviveOffers();
                    break;
                }
                LOGGER.warn("Reached max retries for launch task " + id);
                break;
            }
            case TASK_FINISHED: 
            case TASK_KILLED: {
                LOGGER.debug(id + " Task killed successfully.");
                this.runningTasks.remove(id);
                this.pendingTasks.remove(id);
                break;
            }
            case TASK_RUNNING: {
                this.pendingTasks.remove(id);
                this.runningTasks.add(id);
                break;
            }
        }
    }

    @Override
    public synchronized void registered(SchedulerDriver driver, Protos.FrameworkID frameworkId, Protos.MasterInfo masterInfo) {
        LOGGER.info("Framework registered with ID " + frameworkId.getValue());
        this.frameworkId = frameworkId;
        this.releaseRegisterSem();
    }

    @Override
    public synchronized void reregistered(SchedulerDriver driver, Protos.MasterInfo masterInfo) {
        LOGGER.info("Framework Reregistered");
        this.releaseRegisterSem();
    }

    @Override
    public void disconnected(SchedulerDriver driver) {
        LOGGER.warn("Framework Disconnected!");
    }

    @Override
    public void frameworkMessage(SchedulerDriver driver, Protos.ExecutorID executorId, Protos.SlaveID slaveId, byte[] data) {
        LOGGER.debug("Message received");
    }

    @Override
    public void slaveLost(SchedulerDriver driver, Protos.SlaveID slaveId) {
    }

    @Override
    public void executorLost(SchedulerDriver driver, Protos.ExecutorID executorId, Protos.SlaveID slaveId, int status) {
    }

    @Override
    public void error(SchedulerDriver driver, String message) {
        LOGGER.warn("Error: " + message);
    }

    private void releaseRegisterSem() {
        if (this.registerSem != null) {
            this.registerSem.release();
            this.registerSem = null;
            LOGGER.debug("Release framework register semaphore");
        }
    }

    private void acquireSem(Semaphore sem) {
        try {
            LOGGER.debug("Acquire semaphore " + sem.toString());
            sem.acquire();
        }
        catch (InterruptedException ex) {
            LOGGER.error("Error waiting for semaphore!", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
    }

    private boolean acquireSem(Semaphore sem, long timeout, TimeUnit unit) {
        try {
            LOGGER.debug("Acquire semaphore " + sem.toString());
            return sem.tryAcquire(timeout, unit);
        }
        catch (InterruptedException ex) {
            LOGGER.error("Error waiting for semaphore!", (Throwable)ex);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findIpAddress(Protos.NetworkInfo ni, Protos.TaskStatus ts) {
        Iterator<Protos.NetworkInfo.IPAddress> iterator = ni.getIpAddressesList().iterator();
        if (iterator.hasNext()) {
            Protos.NetworkInfo.IPAddress ip = iterator.next();
            LOGGER.debug("Found IP address in network: " + ip.getIpAddress());
            Map<String, MesosTask> map = this.tasks;
            synchronized (map) {
                this.tasks.get(ts.getTaskId().getValue()).setIp(ip.getIpAddress());
            }
            return true;
        }
        return false;
    }

    private void getIpAddress(Protos.TaskStatus status) {
        List<Protos.NetworkInfo> networks = status.getContainerStatus().getNetworkInfosList();
        for (Protos.NetworkInfo ni : networks) {
            if (!this.findIpAddress(ni, status)) continue;
            return;
        }
    }

    private List<MesosOffer> processOffers(List<Protos.Offer> offers) {
        LinkedList<MesosOffer> mesosOffers = new LinkedList<MesosOffer>();
        for (Protos.Offer offer : offers) {
            mesosOffers.add(new MesosOffer(offer));
        }
        return mesosOffers;
    }

    private int bestFit(MesosOffer requirements, List<MesosOffer> offers) {
        int index = -1;
        int openPorts = requirements.getNumPorts();
        double bestScore = Double.MAX_VALUE;
        for (int i = 0; i < offers.size(); ++i) {
            MesosOffer mo = offers.get(i);
            double score = requirements.distance(mo);
            if (!mo.hasEnoughPorts(openPorts) || !(score >= 0.0) || !(score < bestScore)) continue;
            index = i;
            bestScore = score;
        }
        return index;
    }

    private LinkedList<Integer> rangeToIntegers(List<Protos.Value.Range> ports) {
        LinkedList<Integer> portsList = new LinkedList<Integer>();
        for (int i = 0; i < ports.size(); ++i) {
            Protos.Value.Range range = ports.get(i);
            int n = (int)range.getBegin();
            while ((long)n <= range.getEnd()) {
                portsList.add(n);
                ++n;
            }
        }
        return portsList;
    }

    private Protos.ContainerInfo.DockerInfo.PortMapping buildPortMapping(int container, int host, String protocol) {
        return Protos.ContainerInfo.DockerInfo.PortMapping.newBuilder().setContainerPort(container).setHostPort(host).setProtocol(protocol).build();
    }

    private void addPortsToDocker(Protos.ContainerInfo.DockerInfo.Builder builder, List<Protos.Value.Range> containerPorts, List<Protos.Value.Range> hostPorts) {
        LinkedList<Integer> portsToAssign = this.rangeToIntegers(containerPorts);
        boolean assignedPorts = false;
        for (int i = 0; i < hostPorts.size() && !assignedPorts; ++i) {
            Protos.Value.Range r = hostPorts.get(i);
            int host = (int)r.getBegin();
            while ((long)host <= r.getEnd() && !assignedPorts) {
                Integer containerPort = portsToAssign.pollFirst();
                if (containerPort == null) {
                    assignedPorts = true;
                } else {
                    builder.addPortMappings(this.buildPortMapping(containerPort, host, "tcp"));
                }
                ++host;
            }
        }
    }

    private Protos.ContainerInfo.DockerInfo getDockerInfo(String imageName, List<Protos.Value.Range> containerPorts, List<Protos.Value.Range> hostPorts) {
        Protos.ContainerInfo.DockerInfo.Builder dockerInfoBuilder = Protos.ContainerInfo.DockerInfo.newBuilder().setImage(imageName).setNetwork(this.dockerNetworkType);
        this.addPortsToDocker(dockerInfoBuilder, containerPorts, hostPorts);
        return dockerInfoBuilder.build();
    }

    private void launchTask(SchedulerDriver driver, Protos.Offer offer, Protos.TaskInfo task) {
        ArrayList<Protos.TaskInfo> tasksToSubmit = new ArrayList<Protos.TaskInfo>();
        ArrayList<Protos.OfferID> offerIds = new ArrayList<Protos.OfferID>();
        tasksToSubmit.add(task);
        offerIds.add(offer.getId());
        driver.launchTasks(offerIds, tasksToSubmit);
    }

    private Protos.Value.Ranges buildRanges(List<Protos.Value.Range> ranges) {
        Protos.Value.Ranges.Builder rangesBuilder = Protos.Value.Ranges.newBuilder();
        for (Protos.Value.Range r : ranges) {
            rangesBuilder.addRange(r);
        }
        return rangesBuilder.build();
    }

    private Protos.Value.Scalar buildScalar(double value) {
        return Protos.Value.Scalar.newBuilder().setValue(value).build();
    }

    private Protos.Resource buildResource(String name, double value) {
        return Protos.Resource.newBuilder().setName(name).setType(Protos.Value.Type.SCALAR).setScalar(this.buildScalar(value)).build();
    }

    private Protos.Resource buildResource(String name, List<Protos.Value.Range> ranges) {
        return Protos.Resource.newBuilder().setName(name).setType(Protos.Value.Type.RANGES).setRanges(this.buildRanges(ranges)).build();
    }

    private Protos.TaskInfo getTaskInfo(String idTask, String imageName, MesosOffer reqs, MesosOffer offer) {
        int openPorts = reqs.getNumPorts();
        Protos.TaskID taskId = Protos.TaskID.newBuilder().setValue(idTask).build();
        List<Protos.Value.Range> pickedPorts = offer.getMinPorts(openPorts);
        Protos.CommandInfo commandInfoDocker = Protos.CommandInfo.newBuilder().setValue(DOCKER_COMMAND).build();
        Protos.ContainerInfo.Builder containerInfoBuilder = Protos.ContainerInfo.newBuilder();
        if (this.useCustomDockerNetwork) {
            containerInfoBuilder.addNetworkInfos(Protos.NetworkInfo.newBuilder().setName(this.dockerNetworkName).build());
        }
        containerInfoBuilder.setType(Protos.ContainerInfo.Type.DOCKER);
        containerInfoBuilder.setDocker(this.getDockerInfo(imageName, reqs.getPortsList(), pickedPorts));
        Protos.TaskInfo taskInfo = Protos.TaskInfo.newBuilder().setName("Task " + idTask).setTaskId(taskId).setSlaveId(offer.getOffer().getSlaveId()).addResources(this.buildResource(CPUS_RESOURCE, reqs.getCpus())).addResources(this.buildResource(MEM_RESOURCE, reqs.getMem())).addResources(this.buildResource(DISK_RESOURCE, reqs.getDisk())).addResources(this.buildResource(PORTS_RESOURCE, pickedPorts)).setContainer(containerInfoBuilder).setCommand(commandInfoDocker).build();
        LOGGER.debug("Launching task " + taskId.getValue());
        return taskInfo;
    }

    private void declineOffers(SchedulerDriver driver, List<Protos.OfferID> offerIds) {
        for (Protos.OfferID id : offerIds) {
            LOGGER.debug("Decline offer: " + id.getValue());
            driver.declineOffer(id);
        }
    }

    private List<Protos.OfferID> getOfferIdList(List<Protos.Offer> offers) {
        LinkedList<Protos.OfferID> ids = new LinkedList<Protos.OfferID>();
        for (Protos.Offer o : offers) {
            ids.add(o.getId());
        }
        return ids;
    }
}

