/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.scheduler.loadBalancingScheduler;

import integratedtoolkit.scheduler.readyScheduler.ReadyResourceScheduler;
import integratedtoolkit.scheduler.types.AllocatableAction;
import integratedtoolkit.scheduler.types.LoadBalancingScore;
import integratedtoolkit.scheduler.types.Profile;
import integratedtoolkit.scheduler.types.Score;
import integratedtoolkit.types.TaskDescription;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.types.resources.WorkerResourceDescription;

public class LoadBalancingResourceScheduler<P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>>
extends ReadyResourceScheduler<P, T, I> {
    public LoadBalancingResourceScheduler(Worker<T, I> w) {
        super(w);
    }

    public Score generateBlockedScore(AllocatableAction<P, T, I> action) {
        double actionPriority = action.getPriority();
        double resourceScore = 0.0;
        double waitingScore = 2.0;
        if (this.blocked.size() > 0) {
            waitingScore = 1.0 / (double)this.blocked.size();
        }
        double implementationScore = 0.0;
        return new LoadBalancingScore(actionPriority, resourceScore, waitingScore, implementationScore);
    }

    public Score generateResourceScore(AllocatableAction<P, T, I> action, TaskDescription params, Score actionScore) {
        double actionPriority = actionScore.getActionScore();
        double waitingScore = -action.getId();
        double resourceScore = actionScore.calculateResourceScore(params, this.myWorker);
        double implementationScore = -100.0;
        LoadBalancingScore score = new LoadBalancingScore(actionPriority, resourceScore, waitingScore, implementationScore);
        return score;
    }

    public Score generateImplementationScore(AllocatableAction<P, T, I> action, TaskDescription params, I impl, Score resourceScore) {
        if (this.myWorker.canRunNow(impl.getRequirements())) {
            double actionPriority = resourceScore.getActionScore();
            double resourcePriority = resourceScore.getResourceScore();
            double waitingScore = -action.getId();
            double implScore = -this.getProfile((Implementation)impl).getAverageExecutionTime();
            return new LoadBalancingScore(actionPriority, resourcePriority, waitingScore, implScore);
        }
        return null;
    }

    public String toString() {
        return "LoadBalancingResourceScheduler@" + this.getName();
    }
}

