/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.connectors;

import es.bsc.conn.Connector;
import es.bsc.conn.exceptions.ConnException;
import es.bsc.conn.types.HardwareDescription;
import es.bsc.conn.types.InstallationDescription;
import es.bsc.conn.types.Processor;
import es.bsc.conn.types.SoftwareDescription;
import es.bsc.conn.types.VirtualResource;
import integratedtoolkit.connectors.AbstractConnector;
import integratedtoolkit.connectors.ConnectorException;
import integratedtoolkit.types.CloudImageDescription;
import integratedtoolkit.types.resources.configuration.MethodConfiguration;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import integratedtoolkit.util.Classpath;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultNoSSHConnector
extends AbstractConnector {
    private static final String CONNECTORS_REL_PATH = File.separator + "Runtime" + File.separator + "cloud-conn" + File.separator;
    private static final Logger LOGGER = LogManager.getLogger((String)"integratedtoolkit.Connectors");
    private static final String WARN_NO_IT_HOME = "WARN: IT_HOME not defined, no default connectors loaded";
    private static final String ERROR_NO_CONN = "ERROR: Connector specific implementation is null";
    private static final String CPU_TYPE = "CPU";
    private static final float UNASSIGNED_FLOAT = -1.0f;
    private final Connector connector;

    public DefaultNoSSHConnector(String providerName, String connectorJarPath, String connectorMainClass, HashMap<String, String> connectorProperties) throws ConnectorException {
        super(providerName, connectorProperties);
        LOGGER.info("Creating DefaultNoSSHConnector");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Detected " + connectorProperties.size() + " Connector properties");
            for (Map.Entry<String, String> prop : connectorProperties.entrySet()) {
                LOGGER.debug("   > ConnectorProperty: " + prop.getKey() + " - " + prop.getValue());
            }
        }
        Connector conn = null;
        LOGGER.debug(" - Loading " + connectorJarPath);
        try {
            String jarPath = connectorJarPath;
            if (!connectorJarPath.startsWith(File.separator)) {
                String itHome = System.getenv("IT_HOME");
                if (itHome == null || itHome.isEmpty()) {
                    LOGGER.warn(WARN_NO_IT_HOME);
                    return;
                }
                jarPath = itHome + CONNECTORS_REL_PATH + connectorJarPath;
            }
            LOGGER.debug(" - Loading from : " + jarPath);
            Classpath.loadPath((String)jarPath, (Logger)LOGGER);
            LOGGER.debug(" - Using connector " + connectorMainClass);
            Class<?> conClass = Class.forName(connectorMainClass);
            Constructor<?> constructor = conClass.getDeclaredConstructors()[0];
            conn = (Connector)constructor.newInstance(connectorProperties);
        }
        catch (FileNotFoundException fnfe) {
            throw new ConnectorException("Specific Connector jar file (" + connectorJarPath + ") not found", (Exception)fnfe);
        }
        catch (Exception e) {
            throw new ConnectorException(e);
        }
        finally {
            this.connector = conn;
        }
        if (this.connector == null) {
            throw new ConnectorException(ERROR_NO_CONN);
        }
    }

    private Processor getProcessor(integratedtoolkit.types.resources.components.Processor p) {
        return new Processor(p.getName(), p.getComputingUnits(), p.getSpeed(), p.getArchitecture(), p.getPropName(), p.getPropValue());
    }

    private integratedtoolkit.types.resources.components.Processor getProcessor(Processor p) {
        return new integratedtoolkit.types.resources.components.Processor(p.getName(), p.getComputingUnits(), p.getSpeed(), p.getArchitecture(), CPU_TYPE, -1.0f, p.getPropName(), p.getPropValue());
    }

    private List<Processor> getConnectorProcessors(List<integratedtoolkit.types.resources.components.Processor> processorList) {
        LinkedList<Processor> processors = new LinkedList<Processor>();
        for (integratedtoolkit.types.resources.components.Processor p : processorList) {
            processors.add(this.getProcessor(p));
        }
        return processors;
    }

    private List<integratedtoolkit.types.resources.components.Processor> getCompssProcessors(List<Processor> processorList) {
        LinkedList<integratedtoolkit.types.resources.components.Processor> processors = new LinkedList<integratedtoolkit.types.resources.components.Processor>();
        for (Processor p : processorList) {
            processors.add(this.getProcessor(p));
        }
        return processors;
    }

    private HardwareDescription getHardwareDescription(CloudMethodResourceDescription cmrd) {
        return new HardwareDescription(this.getConnectorProcessors(cmrd.getProcessors()), cmrd.getTotalCPUComputingUnits(), cmrd.getMemorySize(), cmrd.getMemoryType(), cmrd.getStorageSize(), cmrd.getStorageType(), cmrd.getPriceTimeUnit(), cmrd.getPricePerUnit(), cmrd.getImage().getImageName(), cmrd.getType(), (Map)cmrd.getImage().getProperties());
    }

    private SoftwareDescription getSoftwareDescription(CloudMethodResourceDescription cmrd) {
        return new SoftwareDescription(cmrd.getOperatingSystemType(), cmrd.getOperatingSystemDistribution(), cmrd.getOperatingSystemVersion(), cmrd.getAppSoftware(), this.getInstallationDescription(cmrd.getImage().getConfig()));
    }

    private InstallationDescription getInstallationDescription(MethodConfiguration config) {
        return new InstallationDescription(config.getInstallDir(), config.getAppDir(), config.getClasspath(), config.getPythonpath(), config.getLibraryPath(), config.getWorkingDir(), config.getLimitOfTasks());
    }

    private VirtualResource getVirtualResource(Object id, CloudMethodResourceDescription cmrd) {
        return new VirtualResource((Object)((String)id), this.getHardwareDescription(cmrd), this.getSoftwareDescription(cmrd), (Map)cmrd.getImage().getProperties());
    }

    private CloudImageDescription getCloudImageDescription(HardwareDescription hd, SoftwareDescription sd, String provider) {
        LOGGER.debug("Generating Image - Provider: " + provider + " image: " + hd.getImageName());
        CloudImageDescription cid = new CloudImageDescription(provider, hd.getImageName(), hd.getImageProperties());
        cid.setOperatingSystemType(sd.getOperatingSystemType());
        cid.setOperatingSystemDistribution(sd.getOperatingSystemDistribution());
        cid.setOperatingSystemVersion(sd.getOperatingSystemVersion());
        cid.setAppSoftware(sd.getAppSoftware());
        cid.setPricePerUnit(hd.getPricePerUnit());
        cid.setPriceTimeUnit(hd.getPriceTimeUnit());
        return cid;
    }

    private void setCloudImageDescription(CloudImageDescription to, CloudImageDescription from) {
        to.setConfig(from.getConfig());
        to.setQueues(from.getQueues());
        to.setSharedDisks(from.getSharedDisks());
        to.setPackages(from.getPackages());
    }

    private void setHardwareInResourceDescription(CloudMethodResourceDescription cmrd, HardwareDescription hd) {
        cmrd.setProcessors(this.getCompssProcessors(hd.getProcessors()));
        cmrd.setMemorySize(hd.getMemorySize());
        cmrd.setMemoryType(hd.getMemoryType());
        cmrd.setStorageSize(hd.getStorageSize());
        cmrd.setStorageType(hd.getStorageType());
        cmrd.setPricePerUnit(hd.getPricePerUnit());
        cmrd.setPriceTimeUnit(hd.getPriceTimeUnit());
        cmrd.setType(hd.getImageType());
    }

    private void setSoftwareInResourceDescription(CloudMethodResourceDescription cmrd, SoftwareDescription sd) {
        cmrd.setOperatingSystemType(sd.getOperatingSystemType());
        cmrd.setOperatingSystemDistribution(sd.getOperatingSystemDistribution());
        cmrd.setOperatingSystemVersion(sd.getOperatingSystemVersion());
        cmrd.setAppSoftware(sd.getAppSoftware());
    }

    private CloudMethodResourceDescription toCloudMethodResourceDescription(VirtualResource vr, CloudMethodResourceDescription requested) {
        String provider = requested.getProviderName();
        CloudMethodResourceDescription cmrd = new CloudMethodResourceDescription(provider, vr.getIp(), vr.getHd().getImageName());
        this.setHardwareInResourceDescription(cmrd, vr.getHd());
        this.setSoftwareInResourceDescription(cmrd, vr.getSd());
        cmrd.setImage(this.getCloudImageDescription(vr.getHd(), vr.getSd(), provider));
        this.setCloudImageDescription(cmrd.getImage(), requested.getImage());
        return cmrd;
    }

    public void destroy(Object id) throws ConnectorException {
        LOGGER.debug("Destroy connection with id " + id);
        if (this.connector == null) {
            throw new ConnectorException(ERROR_NO_CONN);
        }
        this.connector.destroy(id);
        LOGGER.debug("Connection with id " + id + " destroyed.");
    }

    public Object create(String name, CloudMethodResourceDescription cmrd) throws ConnectorException {
        Object created;
        LOGGER.debug("Create VM " + name + " with image: " + cmrd.getImage().getImageName());
        if (this.connector == null) {
            throw new ConnectorException(ERROR_NO_CONN);
        }
        try {
            created = this.connector.create(this.getHardwareDescription(cmrd), this.getSoftwareDescription(cmrd), (Map)cmrd.getImage().getProperties());
        }
        catch (ConnException ce) {
            throw new ConnectorException((Exception)((Object)ce));
        }
        return created;
    }

    public CloudMethodResourceDescription waitUntilCreation(Object id, CloudMethodResourceDescription requested) throws ConnectorException {
        VirtualResource vr;
        LOGGER.debug("Waiting for " + (String)id);
        if (this.connector == null) {
            throw new ConnectorException(ERROR_NO_CONN);
        }
        try {
            vr = this.connector.waitUntilCreation(id);
        }
        catch (ConnException ce) {
            throw new ConnectorException((Exception)((Object)ce));
        }
        CloudMethodResourceDescription cmrd = this.toCloudMethodResourceDescription(vr, requested);
        LOGGER.debug("Return cloud method resource description " + cmrd.toString());
        return cmrd;
    }

    public float getMachineCostPerTimeSlot(CloudMethodResourceDescription cmrd) {
        if (this.connector == null) {
            return -1.0f;
        }
        return this.connector.getPriceSlot(this.getVirtualResource("-1", cmrd));
    }

    public long getTimeSlot() {
        if (this.connector == null) {
            return 30000L;
        }
        return this.connector.getTimeSlot();
    }

    protected void close() {
        LOGGER.debug("Close connector");
        this.connector.close();
    }

    public void configureAccess(String IP, String user, String password) throws ConnectorException {
    }

    public void prepareMachine(String IP, CloudImageDescription cid) throws ConnectorException {
    }
}

