/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.scheduler.readyScheduler;

import integratedtoolkit.components.impl.ResourceScheduler;
import integratedtoolkit.components.impl.TaskScheduler;
import integratedtoolkit.scheduler.exceptions.BlockedActionException;
import integratedtoolkit.scheduler.exceptions.UnassignedActionException;
import integratedtoolkit.scheduler.types.AllocatableAction;
import integratedtoolkit.scheduler.types.ObjectValue;
import integratedtoolkit.scheduler.types.Profile;
import integratedtoolkit.scheduler.types.Score;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.WorkerResourceDescription;
import integratedtoolkit.util.ActionSet;
import java.util.LinkedList;
import java.util.PriorityQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ReadyScheduler<P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>>
extends TaskScheduler<P, T, I> {
    protected static final Logger LOGGER = LogManager.getLogger((String)"integratedtoolkit.Components.TaskDispatcher.TaskScheduler");
    protected final ActionSet<P, T, I> dependingActions = new ActionSet();
    protected final ActionSet<P, T, I> unassignedReadyActions = new ActionSet();

    public void workerLoadUpdate(ResourceScheduler<P, T, I> resource) {
    }

    public abstract Score generateActionScore(AllocatableAction<P, T, I> var1);

    protected void scheduleAction(AllocatableAction<P, T, I> action, Score actionScore) throws BlockedActionException {
        if (!action.hasDataPredecessors()) {
            try {
                action.schedule(actionScore);
            }
            catch (UnassignedActionException ex) {
                this.unassignedReadyActions.addAction(action);
            }
        }
    }

    protected void scheduleAction(AllocatableAction<P, T, I> action, ResourceScheduler<P, T, I> targetWorker, Score actionScore) throws BlockedActionException, UnassignedActionException {
        if (!action.hasDataPredecessors()) {
            action.schedule(targetWorker, actionScore);
        }
    }

    protected abstract void purgeFreeActions(LinkedList<AllocatableAction<P, T, I>> var1, LinkedList<AllocatableAction<P, T, I>> var2, LinkedList<AllocatableAction<P, T, I>> var3, ResourceScheduler<P, T, I> var4);

    public void handleDependencyFreeActions(LinkedList<AllocatableAction<P, T, I>> dataFreeActions, LinkedList<AllocatableAction<P, T, I>> resourceFreeActions, LinkedList<AllocatableAction<P, T, I>> blockedCandidates, ResourceScheduler<P, T, I> resource) {
        this.purgeFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, resource);
        this.tryToLaunchFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, resource);
    }

    public LinkedList<AllocatableAction<P, T, I>> getUnassignedActions() {
        return this.unassignedReadyActions.getAllActions();
    }

    protected void tryToLaunchFreeActions(LinkedList<AllocatableAction<P, T, I>> dataFreeActions, LinkedList<AllocatableAction<P, T, I>> resourceFreeActions, LinkedList<AllocatableAction<P, T, I>> blockedCandidates, ResourceScheduler<P, T, I> resource) {
        ObjectValue obj;
        Score fullScore;
        Score actionScore;
        PriorityQueue<ObjectValue> executableActions = new PriorityQueue<ObjectValue>();
        for (AllocatableAction allocatableAction : dataFreeActions) {
            actionScore = this.generateActionScore(allocatableAction);
            fullScore = allocatableAction.schedulingScore(resource, actionScore);
            obj = new ObjectValue((Object)allocatableAction, fullScore);
            executableActions.add(obj);
        }
        for (AllocatableAction allocatableAction : resourceFreeActions) {
            obj = new ObjectValue((Object)allocatableAction, fullScore = allocatableAction.schedulingScore(resource, actionScore = this.generateActionScore(allocatableAction)));
            if (executableActions.contains(obj)) continue;
            executableActions.add(obj);
        }
        while (!executableActions.isEmpty()) {
            ObjectValue obj2 = (ObjectValue)executableActions.poll();
            AllocatableAction allocatableAction = (AllocatableAction)obj2.getObject();
            try {
                this.scheduleAction(allocatableAction, obj2.getScore());
                this.tryToLaunch(allocatableAction);
            }
            catch (BlockedActionException e) {
                this.removeFromReady(allocatableAction);
                this.addToBlocked(allocatableAction);
            }
        }
    }
}

