/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.scheduler.fifoScheduler;

import integratedtoolkit.scheduler.readyScheduler.ReadyResourceScheduler;
import integratedtoolkit.scheduler.types.AllocatableAction;
import integratedtoolkit.scheduler.types.FIFOScore;
import integratedtoolkit.scheduler.types.Profile;
import integratedtoolkit.scheduler.types.Score;
import integratedtoolkit.types.TaskDescription;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.types.resources.WorkerResourceDescription;

public class FIFOResourceScheduler<P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>>
extends ReadyResourceScheduler<P, T, I> {
    public FIFOResourceScheduler(Worker<T, I> w) {
        super(w);
    }

    public Score generateBlockedScore(AllocatableAction<P, T, I> action) {
        double actionPriority = action.getPriority();
        double resourceScore = -((double)action.getId());
        double waitingScore = 0.0;
        double implementationScore = 0.0;
        return new FIFOScore(actionPriority, resourceScore, waitingScore, implementationScore);
    }

    public Score generateResourceScore(AllocatableAction<P, T, I> action, TaskDescription params, Score actionScore) {
        double actionPriority = actionScore.getActionScore();
        double resourceScore = -((double)action.getId());
        double waitingScore = 0.0;
        double implementationScore = 0.0;
        return new FIFOScore(actionPriority, resourceScore, waitingScore, implementationScore);
    }

    public Score generateImplementationScore(AllocatableAction<P, T, I> action, TaskDescription params, I impl, Score resourceScore) {
        if (this.myWorker.canRunNow(impl.getRequirements())) {
            double actionPriority = resourceScore.getActionScore();
            double resourcePriority = -((double)action.getId());
            double waitingScore = 0.0;
            double implScore = 0.0;
            return new FIFOScore(actionPriority, resourcePriority, waitingScore, implScore);
        }
        return null;
    }

    public String toString() {
        return "FIFOResourceScheduler@" + this.getName();
    }
}

