/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.scheduler.dataScheduler;

import integratedtoolkit.scheduler.readyScheduler.ReadyResourceScheduler;
import integratedtoolkit.scheduler.types.AllocatableAction;
import integratedtoolkit.scheduler.types.DataScore;
import integratedtoolkit.scheduler.types.Profile;
import integratedtoolkit.scheduler.types.Score;
import integratedtoolkit.types.TaskDescription;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.types.resources.WorkerResourceDescription;

public class DataResourceScheduler<P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>>
extends ReadyResourceScheduler<P, T, I> {
    public DataResourceScheduler(Worker<T, I> w) {
        super(w);
    }

    public Score generateBlockedScore(AllocatableAction<P, T, I> action) {
        double actionPriority = action.getPriority();
        double waitingScore = 2.0;
        if (this.blocked.size() > 0) {
            waitingScore = 1.0 / (double)this.blocked.size();
        }
        double resourceScore = 0.0;
        double implementationScore = 0.0;
        return new DataScore(actionPriority, resourceScore, waitingScore, implementationScore);
    }

    public Score generateResourceScore(AllocatableAction<P, T, I> action, TaskDescription params, Score actionScore) {
        double actionPriority = actionScore.getActionScore();
        double waitingScore = 2.0;
        if (this.blocked.size() > 0) {
            waitingScore = 1.0 / (double)this.blocked.size();
        }
        double resourceScore = actionScore.calculateResourceScore(params, this.myWorker);
        return new DataScore(actionPriority, resourceScore, waitingScore, 0.0);
    }

    public Score generateImplementationScore(AllocatableAction<P, T, I> action, TaskDescription params, I impl, Score resourceScore) {
        if (this.myWorker.canRunNow(impl.getRequirements())) {
            double actionPriority = resourceScore.getActionScore();
            double waitingScore = resourceScore.getWaitingScore();
            double resourcePriority = resourceScore.getResourceScore();
            double implScore = 1.0 / (double)this.getProfile((Implementation)impl).getAverageExecutionTime();
            return new DataScore(actionPriority, resourcePriority, waitingScore, implScore);
        }
        return null;
    }

    public String toString() {
        return "DataResourceScheduler@" + this.getName();
    }
}

