/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.scheduler.types;

import integratedtoolkit.comm.Comm;
import integratedtoolkit.scheduler.types.ReadyScore;
import integratedtoolkit.types.TaskDescription;
import integratedtoolkit.types.annotations.parameter.Direction;
import integratedtoolkit.types.data.DataAccessId;
import integratedtoolkit.types.data.DataInstanceId;
import integratedtoolkit.types.data.LogicalData;
import integratedtoolkit.types.parameter.DependencyParameter;
import integratedtoolkit.types.parameter.Parameter;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.types.resources.Worker;
import java.util.Set;

public class DataScore
extends ReadyScore {
    public DataScore(double actionScore, double res, double waiting, double impl) {
        super(actionScore, res, waiting, impl);
    }

    public DataScore(DataScore clone) {
        super((ReadyScore)clone);
    }

    public double calculateResourceScore(TaskDescription params, Worker<?, ?> w) {
        long resourceScore = 0L;
        if (params != null) {
            Parameter[] parameters;
            for (Parameter p : parameters = params.getParameters()) {
                LogicalData dataLD;
                if (!(p instanceof DependencyParameter) || p.getDirection() == Direction.OUT) continue;
                DependencyParameter dp = (DependencyParameter)p;
                DataInstanceId dId = null;
                switch (dp.getDirection()) {
                    case IN: {
                        DataAccessId.RAccessId raId = (DataAccessId.RAccessId)dp.getDataAccessId();
                        dId = raId.getReadDataInstance();
                        break;
                    }
                    case INOUT: {
                        DataAccessId.RWAccessId rwaId = (DataAccessId.RWAccessId)dp.getDataAccessId();
                        dId = rwaId.getReadDataInstance();
                        break;
                    }
                }
                if (dId == null || (dataLD = Comm.getData((String)dId.getRenaming())) == null) continue;
                Set hosts = dataLD.getAllHosts();
                for (Resource host : hosts) {
                    if (host != w) continue;
                    ++resourceScore;
                }
            }
        }
        return resourceScore;
    }

    public String toString() {
        return "[DataScore = [action:" + this.actionScore + ", resource:" + this.resourceScore + ", load:" + this.waitingScore + ", implementation:" + this.implementationScore + "]" + "]";
    }
}

