/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.components;

import integratedtoolkit.types.resources.Resource;

public interface ResourceUser {
    public void updatedResource(Resource var1);

    public WorkloadStatus getWorkload();

    public static class WorkloadStatus {
        private int coreCount;
        private long[] coreMinTime;
        private long[] coreMeanTime;
        private long[] coreMaxTime;
        private int noResourceCount;
        private int[] noResourceCounts;
        private int readyCount;
        private int[] readyCounts;
        private int[] runningCounts;
        private int runningCount;
        private long[] runningCoreMeanTime;

        public WorkloadStatus(int coreCount) {
            this.coreCount = coreCount;
            this.coreMinTime = new long[coreCount];
            this.coreMeanTime = new long[coreCount];
            this.coreMaxTime = new long[coreCount];
            this.noResourceCounts = new int[coreCount];
            this.readyCounts = new int[coreCount];
            this.runningCounts = new int[coreCount];
            this.runningCoreMeanTime = new long[coreCount];
        }

        public int getCoreCount() {
            return this.coreCount;
        }

        public void registerTimes(int coreId, long minTime, long avgTime, long maxTime) {
            if (coreId < this.coreCount) {
                this.coreMinTime[coreId] = minTime;
                this.coreMeanTime[coreId] = avgTime;
                this.coreMaxTime[coreId] = maxTime;
            }
        }

        public long getCoreMeanTime(int coreId) {
            return this.coreMeanTime[coreId];
        }

        public long getCoreMaxTime(int coreId) {
            return this.coreMaxTime[coreId];
        }

        public long getCoreMinTime(int coreId) {
            return this.coreMinTime[coreId];
        }

        public int getNoResourceCount() {
            return this.noResourceCount;
        }

        public int[] getNoResourceCounts() {
            return this.noResourceCounts;
        }

        public int getReadyCount() {
            return this.readyCount;
        }

        public int[] getReadyCounts() {
            return this.readyCounts;
        }

        public void registerNoResources(int coreId, int count) {
            this.noResourceCount -= this.noResourceCounts[coreId];
            this.noResourceCounts[coreId] = count;
            this.noResourceCount += this.noResourceCounts[coreId];
        }

        public void registerReady(int coreId, int count) {
            this.readyCount -= this.readyCounts[coreId];
            this.readyCounts[coreId] = count;
            this.readyCount += this.readyCounts[coreId];
        }

        public long getRunningCoreMeanTime(int coreId) {
            return this.runningCoreMeanTime[coreId];
        }

        public int[] getRunningTaskCounts() {
            return this.runningCounts;
        }

        public int getRunningTaskCount() {
            return this.runningCount;
        }

        public void registerRunning(int coreId, long executedTime) {
            this.runningCoreMeanTime[coreId] = (this.runningCoreMeanTime[coreId] + executedTime) / (long)(this.runningCounts[coreId] + 1);
            int n = coreId;
            this.runningCounts[n] = this.runningCounts[n] + 1;
            ++this.runningCount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("TIMESTAMP = ").append(String.valueOf(System.currentTimeMillis())).append("\n");
            sb.append("LOAD_INFO = [").append("\n");
            for (int coreId = 0; coreId < this.coreCount; ++coreId) {
                sb.append("\t").append("CORE_INFO = [").append("\n");
                sb.append("\t").append("\t").append("COREID = ").append(coreId).append("\n");
                sb.append("\t").append("\t").append("NO_RESOURCE = ").append(this.noResourceCounts[coreId]).append("\n");
                sb.append("\t").append("\t").append("READY = ").append(this.readyCounts[coreId]).append("\n");
                sb.append("\t").append("\t").append("RUNNING = ").append(this.runningCounts[coreId]).append("\n");
                sb.append("\t").append("\t").append("MIN = ").append(this.coreMinTime[coreId]).append("\n");
                sb.append("\t").append("\t").append("MEAN = ").append(this.coreMeanTime[coreId]).append("\n");
                sb.append("\t").append("\t").append("MAX = ").append(this.coreMaxTime[coreId]).append("\n");
                sb.append("\t").append("\t").append("RUNNING_MEAN = ").append(this.runningCoreMeanTime[coreId]).append("\n");
                sb.append("\t").append("]").append("\n");
            }
            sb.append("]").append("\n");
            return sb.toString();
        }
    }
}

