/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.connectors;

import integratedtoolkit.types.COMPSsWorker;
import integratedtoolkit.types.resources.CloudMethodWorker;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;

public class VM
implements Comparable<VM> {
    private final Object envId;
    private final CloudMethodResourceDescription rd;
    private COMPSsWorker node;
    private CloudMethodWorker worker;
    private long requestTime;
    private long startTime;
    private long creationTime;
    private boolean toDelete;

    public VM(Object envId, CloudMethodResourceDescription description) {
        this.envId = envId;
        this.rd = description;
        this.requestTime = System.currentTimeMillis();
        this.startTime = 0L;
        this.creationTime = 0L;
        this.toDelete = false;
    }

    public Object getEnvId() {
        return this.envId;
    }

    public String getName() {
        return this.rd.getName();
    }

    public CloudMethodResourceDescription getDescription() {
        return this.rd;
    }

    public COMPSsWorker getNode() {
        return this.node;
    }

    public CloudMethodWorker getWorker() {
        return this.worker;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getImage() {
        return this.rd.getImage().getImageName();
    }

    public boolean isToDelete() {
        return this.toDelete;
    }

    public void computeCreationTime() {
        this.creationTime = this.startTime - this.requestTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setRequestTime(long requestTime) {
        this.requestTime = requestTime;
    }

    public void setWorker(CloudMethodWorker worker) {
        this.worker = worker;
    }

    public void setToDelete(boolean toDelete) {
        this.toDelete = toDelete;
    }

    @Override
    public int compareTo(VM vm) throws NullPointerException {
        if (vm == null) {
            throw new NullPointerException();
        }
        if (vm.getName().equals(this.getName())) {
            return 0;
        }
        long now = System.currentTimeMillis();
        int mod1 = (int)(now - this.getStartTime()) % 3600000;
        int mod2 = (int)(now - vm.getStartTime()) % 3600000;
        return mod2 - mod1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof VM) {
            VM vm = (VM)obj;
            return vm.getName().equals(this.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return "VM " + this.envId + " (ip = " + this.rd.getName() + ", request time = " + this.requestTime + ", start time = " + this.startTime + ", creation time = " + this.creationTime + ", image = " + this.rd.getImage().getImageName() + ", procs = CPU: " + this.rd.getTotalCPUComputingUnits() + ", GPU: " + this.rd.getTotalGPUComputingUnits() + ", FPGA: " + this.rd.getTotalFPGAComputingUnits() + ", OTHER: " + this.rd.getTotalOTHERComputingUnits() + ", memory = " + this.rd.getMemorySize() + ", disk = " + this.rd.getStorageSize() + ", to delete = " + this.toDelete + ")";
    }
}

