/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.resources;

import integratedtoolkit.types.COMPSsWorker;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.MethodResourceDescription;
import integratedtoolkit.types.resources.MethodWorker;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.types.resources.ResourceDescription;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.types.resources.configuration.MethodConfiguration;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;

public class CloudMethodWorker
extends MethodWorker {
    private final LinkedList<PendingReduction> pendingReductions;
    private final CloudMethodResourceDescription toRemove;

    public CloudMethodWorker(CloudMethodResourceDescription description, COMPSsWorker worker, int limitOfTasks, HashMap<String, String> sharedDisks) {
        super(description.getName(), description, worker, limitOfTasks, sharedDisks);
        this.toRemove = new CloudMethodResourceDescription();
        this.pendingReductions = new LinkedList();
    }

    public CloudMethodWorker(String name, CloudMethodResourceDescription description, MethodConfiguration config, HashMap<String, String> sharedDisks) {
        super(name, description, config, sharedDisks);
        if (this.description != null) {
            ((CloudMethodResourceDescription)this.description).setName(name);
        }
        this.toRemove = new CloudMethodResourceDescription();
        this.pendingReductions = new LinkedList();
    }

    public CloudMethodWorker(CloudMethodWorker cmw) {
        super(cmw);
        this.toRemove = cmw.toRemove.copy();
        this.pendingReductions = cmw.pendingReductions;
    }

    @Override
    public Resource.Type getType() {
        return Resource.Type.WORKER;
    }

    @Override
    public String getMonitoringData(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMonitoringData(prefix));
        String providerName = ((CloudMethodResourceDescription)this.description).getProviderName();
        if (providerName == null) {
            providerName = new String("");
        }
        sb.append(prefix).append("<Provider>").append(providerName).append("</Provider>").append("\n");
        String imageName = ((CloudMethodResourceDescription)this.description).getImage().getImageName();
        if (imageName == null) {
            imageName = new String("");
        }
        sb.append(prefix).append("<Image>").append(imageName).append("</Image>").append("\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseFeatures(CloudMethodResourceDescription increment) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            this.available.increase((ResourceDescription)increment);
        }
        methodResourceDescription = (MethodResourceDescription)this.description;
        synchronized (methodResourceDescription) {
            ((MethodResourceDescription)this.description).increase((ResourceDescription)increment);
        }
        this.updatedFeatures();
    }

    @Override
    public MethodResourceDescription reserveResource(MethodResourceDescription consumption) {
        if (!this.hasAvailable(consumption)) {
            return null;
        }
        return super.reserveResource(consumption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void releaseResource(MethodResourceDescription consumption) {
        LOGGER.debug("[CloudMethodWorker] Checking " + this.getName() + " cloud resource to release...");
        super.releaseResource(consumption);
        LinkedList<PendingReduction> linkedList = this.pendingReductions;
        synchronized (linkedList) {
            if (!this.pendingReductions.isEmpty()) {
                PendingReduction[] lpr;
                for (PendingReduction pRed : lpr = this.pendingReductions.toArray(new PendingReduction[this.pendingReductions.size()])) {
                    if (!this.isValidReduction(pRed.reduction)) break;
                    MethodResourceDescription methodResourceDescription = this.available;
                    synchronized (methodResourceDescription) {
                        this.available.reduce((ResourceDescription)pRed.reduction);
                    }
                    methodResourceDescription = this.toRemove;
                    synchronized (methodResourceDescription) {
                        this.toRemove.reduce((ResourceDescription)pRed.reduction);
                    }
                    LOGGER.debug("[CloudMethodWorker] Releasing cloud resource " + this.getName());
                    pRed.sem.release();
                    this.pendingReductions.remove(pRed);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Semaphore reduceFeatures(CloudMethodResourceDescription reduction) {
        LOGGER.debug("[CloudMethodWorker] Reducing features for " + this.getName());
        Semaphore sem = null;
        LinkedList<PendingReduction> linkedList = this.pendingReductions;
        synchronized (linkedList) {
            MethodResourceDescription methodResourceDescription = (MethodResourceDescription)this.description;
            synchronized (methodResourceDescription) {
                ((MethodResourceDescription)this.description).reduce((ResourceDescription)reduction);
            }
            if (this.hasAvailable(reduction)) {
                methodResourceDescription = this.available;
                synchronized (methodResourceDescription) {
                    this.available.reduce((ResourceDescription)reduction);
                }
            }
            if (this.getUsedTaskCount() > 0) {
                methodResourceDescription = this.toRemove;
                synchronized (methodResourceDescription) {
                    this.toRemove.reduce((ResourceDescription)reduction);
                }
                PendingReduction pRed = new PendingReduction(reduction);
                this.pendingReductions.add(pRed);
                sem = pRed.sem;
            }
        }
        this.updatedFeatures();
        return sem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidReduction(MethodResourceDescription red) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            boolean fits = this.available.containsDynamic(red);
            return fits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAvailable(MethodResourceDescription consumption) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            CloudMethodResourceDescription cloudMethodResourceDescription = this.toRemove;
            synchronized (cloudMethodResourceDescription) {
                consumption.increase((ResourceDescription)this.toRemove);
                boolean fits = this.available.containsDynamic(consumption);
                consumption.reduce((ResourceDescription)this.toRemove);
                return fits;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldBeStopped() {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            CloudMethodResourceDescription cloudMethodResourceDescription = this.toRemove;
            synchronized (cloudMethodResourceDescription) {
                return this.available.getTotalCPUComputingUnits() == 0 && this.toRemove.getTotalCPUComputingUnits() == 0;
            }
        }
    }

    @Override
    public Worker<MethodResourceDescription, Implementation<MethodResourceDescription>> getSchedulingCopy() {
        return new CloudMethodWorker(this);
    }

    public boolean hasPendingReductions() {
        return this.pendingReductions != null && !this.pendingReductions.isEmpty();
    }

    private class PendingReduction {
        private CloudMethodResourceDescription reduction;
        private Semaphore sem;

        private PendingReduction(CloudMethodResourceDescription reduction) {
            this.reduction = reduction;
            this.sem = new Semaphore(0);
        }
    }
}

