/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.resources;

import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.types.resources.ServiceResourceDescription;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.types.resources.configuration.Configuration;
import integratedtoolkit.types.resources.configuration.ServiceConfiguration;

public class ServiceWorker
extends Worker<ServiceResourceDescription, Implementation<ServiceResourceDescription>> {
    private String wsdl;

    public ServiceWorker(String wsdl, ServiceResourceDescription description, ServiceConfiguration conf) {
        super(wsdl, description, (Configuration)conf, null);
        this.wsdl = wsdl;
    }

    public ServiceWorker(ServiceWorker sw) {
        super(sw);
        this.wsdl = sw.getWsdl();
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public String getServiceName() {
        return ((ServiceResourceDescription)this.description).getServiceName();
    }

    public String getNamespace() {
        return ((ServiceResourceDescription)this.description).getNamespace();
    }

    public String getPort() {
        return ((ServiceResourceDescription)this.description).getPort();
    }

    public String getName() {
        return this.wsdl;
    }

    @Override
    public Integer fitCount(Implementation<ServiceResourceDescription> impl) {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean hasAvailable(ServiceResourceDescription consumption) {
        return true;
    }

    @Override
    public boolean usesGPU(ServiceResourceDescription consumption) {
        return false;
    }

    @Override
    public boolean usesFPGA(ServiceResourceDescription consumption) {
        return false;
    }

    @Override
    public boolean usesOthers(ServiceResourceDescription consumption) {
        return false;
    }

    @Override
    public ServiceResourceDescription reserveResource(ServiceResourceDescription consumption) {
        return consumption;
    }

    @Override
    public void releaseResource(ServiceResourceDescription consumption) {
    }

    @Override
    public void releaseAllResources() {
        super.resetUsedTaskCount();
    }

    public Resource.Type getType() {
        return Resource.Type.SERVICE;
    }

    @Override
    public String getMonitoringData(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("<TotalComputingUnits>").append(this.getMaxTaskCount()).append("</TotalComputingUnits>").append("\n");
        return sb.toString();
    }

    public int compareTo(Resource t) {
        if (t == null) {
            throw new NullPointerException();
        }
        switch (t.getType()) {
            case SERVICE: {
                return this.getName().compareTo(t.getName());
            }
            case WORKER: {
                return -1;
            }
            case MASTER: {
                return -1;
            }
        }
        return this.getName().compareTo(t.getName());
    }

    @Override
    public boolean canRun(Implementation<ServiceResourceDescription> implementation) {
        switch (implementation.getTaskType()) {
            case SERVICE: {
                ServiceResourceDescription s = (ServiceResourceDescription)implementation.getRequirements();
                return ((ServiceResourceDescription)this.description).getNamespace().compareTo(s.getNamespace()) == 0 && ((ServiceResourceDescription)this.description).getServiceName().compareTo(s.getServiceName()) == 0 && ((ServiceResourceDescription)this.description).getPort().compareTo(s.getPort()) == 0;
            }
        }
        return false;
    }

    @Override
    public String getResourceLinks(String prefix) {
        StringBuilder sb = new StringBuilder(super.getResourceLinks(prefix));
        sb.append(prefix).append("TYPE = SERVICE").append("\n");
        return sb.toString();
    }

    @Override
    public Worker<ServiceResourceDescription, Implementation<ServiceResourceDescription>> getSchedulingCopy() {
        return new ServiceWorker(this);
    }
}

